/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_xja;
import com.inscada.mono.alarm.z.c_gia;
import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.log.model.LogEntryDto;
import com.inscada.mono.project.z.c_ji;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AlarmController<T extends Alarm>
extends ProjectBasedImportExportController {
    protected final c_xja<T> E;
    protected final AlarmManager L;

    @PostMapping(value={"/filter/pages"})
    public Page<T> getAlarmsByFilter(@Valid @RequestBody AlarmFilter alarmFilter, Pageable a) {
        return this.E.m_nqc(alarmFilter, a);
    }

    @GetMapping(params={"projectId"})
    public Collection<T> getAlarms(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.E.m_la();
        }
        return this.E.m_sa(a);
    }

    @GetMapping(params={"projectId", "groupName"})
    public Collection<T> getAlarmsByGroupId(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="groupName") String a) {
        return this.E.m_skc(projectId, a);
    }

    @GetMapping(value={"/pages"})
    public Page<T> getAlarmsByProjectId(@RequestParam(name="projectId", required=false) Integer projectId, Pageable a) {
        if (projectId == null) {
            return this.E.m_ika(a);
        }
        return this.E.m_boa(projectId, a);
    }

    protected AlarmController(c_xja<T> a, AlarmManager a2, c_gh a3, c_ji a4) {
        AlarmController a5;
        AlarmController alarmController = a5;
        super(a3, EnumSet.of(c_vg.e), a4);
        alarmController.E = a;
        alarmController.L = a2;
    }

    @DeleteMapping(value={"/multi"}, params={"alarmIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmsByIds(@RequestParam(value="alarmIds") Integer[] a) {
        this.E.m_lnc(List.of(a));
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_gia> getAlarmStatuses(@RequestParam(value="projectId") Integer a) {
        return this.L.getAlarmStatuses(a);
    }

    @PostMapping
    public ResponseEntity<T> createAlarm(@Valid @RequestBody T alarm, UriComponentsBuilder a) {
        alarm = this.E.m_pgc(alarm);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarm.getId();
        return ResponseEntity.created((URI)a.path(LogEntryDto.m_le((Object)"d\u000f*\u0018*\u0006&=/\t")).buildAndExpand(objectArray).toUri()).body(alarm);
    }

    @GetMapping(value={"/{alarmId}/status"})
    public c_gia getAlarmStatus(@PathVariable(value="alarmId") Integer a) {
        return this.L.getAlarmStatus(a);
    }

    @GetMapping(value={"/parts"})
    public Collection<String> getPartsByProjectId(@RequestParam(name="projectId") Integer a) {
        return this.E.m_okc(a);
    }

    @DeleteMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarm(@PathVariable(value="alarmId") Integer a) {
        this.E.m_ga(a);
    }

    @GetMapping(value={"/name"})
    public T getAlarmByName(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="alarmName") String a) {
        return (T)this.E.m_ph(projectId, a);
    }

    @GetMapping(value={"/status"}, params={"alarmIds"})
    public Map<Integer, c_gia> getAlarmStatuses(@RequestParam(value="alarmIds") Integer[] a) {
        return this.L.getAlarmStatuses(Arrays.asList(a));
    }

    @GetMapping(value={"/{alarmId}"})
    public T getAlarm(@PathVariable(value="alarmId") Integer a) {
        return (T)this.E.m_ba(a);
    }

    @PutMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarm(@PathVariable(value="alarmId") Integer alarmId, @Valid @RequestBody T a) {
        this.E.m_ngc(alarmId, a);
    }

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_gia getAlarmStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.L.getAlarmStatus(projectId, a);
    }
}

