/*
 * ext-symbols.js
 *
 * Licensed under the Apache License, Version 2
 *
 * Copyright(c) 2010 Christian Tzurcanu
 * Copyright(c) 2010 Alexis Deveria
 *
 */

methodDraw.addExtension("symbols", function() {

  var canv = methodDraw.canvas;
  var categories = [];

  return {
    svgicons: "extensions/ext-symbols.xml",
    buttons: [{
      id: "tool_symbollib",
      type: "mode_flyout", // _flyout
      position: 6,
      title: "Symbol library",
      events: {
        "click": function() {}
      }
    }],

    callback: function() {
      $.getJSON('extensions/symbol_dir.json', function(result, textStatus) {
        categories = result.categories;
        sub_categories = result.sub_categories;

        var btn_div = $('<div id="symbol_buttons">');
        $('#tools_symbollib > *').wrapAll(btn_div);
        loadSvgNames(categories[0], sub_categories).then(result => {
          loadSymbols(categories[0], result);
        });

        // Do mouseup on parent element rather than each button
        $('#symbol_buttons').mouseup(function(evt) {
          var btn = $(evt.target).closest('div.tool_button');
          $.ajax({
            type: "GET",
            url: window.parent.svgConfig.apiUrl + '/files/svg-editor-icon?pathFile=' + btn[0].id,
            async: false,
            dataType: 'text',
            headers: {
              'X-Space': window.parent.svgConfig.getActiveSpace(),
              'X-Auth-Token': window.parent.svgConfig.getToken()
            },
            success: function(svg) {
              canv.importSvgString(svg, true);
              canv.ungroupSelectedElement()
              canv.ungroupSelectedElement()
              canv.groupSelectedElements()
              canv.alignSelectedElements("m", "page")
              canv.alignSelectedElements("c", "page")
            }
          });
          $('.tools_flyout').fadeOut();

        });

        var symbol_cats = $('<div id="symbol_cats">');
        var cat_str = '';

        categories.forEach(elem => {
          cat_str += '<div>' + elem + '</div>';
        });

        symbol_cats.html(cat_str).children().bind('mouseup', function() {
          var catlink = $(this);
          $('#symbol_buttons').empty();
          $('#symbol_buttons').html('Loading...');
          var categoryName = catlink.context.innerText;
          loadSvgNames(categoryName, sub_categories).then(result => {
            loadSymbols(categoryName, result);
          });

          catlink.siblings().removeClass('current');
          catlink.addClass('current');
          return false;
        });

        symbol_cats.children().eq(0).addClass('current');

        $('#tools_symbollib').prepend(symbol_cats);
        $('#tool_symbollib').remove();
        var h = $('#tools_symbollib').height();
        $('#tools_symbollib').css({
          'margin-top': -(h / 2),
          'margin-left': 3
        });
      });

    }
  }

  function loadSymbols(folderName, svgNames) {
    var iconButtons = [];
    var ajaxRequests = [];
    svgNames.forEach(svgName => {
      ajaxRequests.push($.ajax({
        type: "GET",
        url: window.parent.svgConfig.apiUrl + "/files/svg-editor-icon?pathFile=" + folderName + '/' + svgName,
        async: false,
        headers: {
          'X-Space': window.parent.svgConfig.getActiveSpace(),
          'X-Auth-Token': window.parent.svgConfig.getToken()
        },
      }));
    });
    $.when(ajaxRequests).done(responses => {
      responses.forEach((elem, i) => {
        iconButtons.push(createSvgDom(elem.responseText, folderName + "/" + svgNames[i], svgNames[i]));
      });
      loadIcons(iconButtons);
    })

    function createSvgDom(svg, path, name) {
      var shape_icon = new DOMParser().parseFromString(svg, 'text/xml');
      shape_icon.documentElement.setAttribute('width', 50);
      shape_icon.documentElement.setAttribute('height', 50);
      shape_icon.documentElement.setAttribute('id', name);
      var svg_elem = $(document.importNode(shape_icon.documentElement, true));
      var icon = svg_elem.clone();
      var icon_btn = icon.wrap('<div class="tool_button">').parent().attr({
        id: path,
        title: name
      });
      return icon_btn[0];
    }
  }

  function loadIcons(icon_buttons) {
    $('#symbol_buttons').empty();
    $('#symbol_buttons').append(icon_buttons);
  }

  function loadSvgNames(categoryName, array) {
    return new Promise((resolve, reject) => {
      try {
        $.ajax({
          success: function(data) {
            for (var i = 0; i < array.length; i++) {
              if (array[i].name == categoryName) {
                return resolve(array[i].svgs);
              }
            }
          }
        });
      } catch (ex) {
        return reject(new Error(ex));
      }
    });
  }

  // only available in development mode to make static json category file
  function makeJsonDirectoryFile() {
    loadFileNames('../../images/icons').then(categories => {
      var obj = {
        categories: categories,
        sub_categories: []
      };
      categories.forEach((category, i) => {
        category = category.replace("&amp;", "&");
        loadFileNames('../../images/icons/' + category).then(svgs => {
          var tempObj = { name: category, svgs: svgs }
          obj.sub_categories.push(tempObj);
          localStorage.setItem('directoryJSON', JSON.stringify(obj));
        });
      });
    });
  }

  function loadFileNames(dir) {
    return new Promise((resolve, reject) => {
      try {
        var fileNames = new Array();
        $.ajax({
          url: dir,
          success: function(data) {
            for (var i = 1; i < $(data).find('li span.name').length; i++) {
              var elem = $(data).find('li span.name')[i];
              fileNames.push(elem.innerHTML);
            }
            return resolve(fileNames);
          }
        });
      } catch (ex) {
        return reject(new Error(ex));
      }
    });
  }

});