/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.restcontrollers;

import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.repositories.BaseInfluxRepository;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.g.c_qa;
import com.inscada.mono.user.model.ResetPasswordToken;
import com.inscada.mono.user.model.Role;
import com.inscada.mono.user.model.User;
import com.inscada.mono.user.model.UserDto;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final c_qa G;

    @PostMapping(value={"/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetOwnPassword(@Valid @RequestBody ResetPasswordToken resetPasswordToken, Principal a) {
        this.G.m_yc(a.getName(), resetPasswordToken);
    }

    @DeleteMapping(value={""}, params={"userIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUsersByIds(@RequestParam(value="userIds") Integer[] a) {
        this.G.m_mc(List.of(a));
    }

    @PostMapping(value={"/{userId}/roles"})
    public ResponseEntity<Role> addRole(@PathVariable(value="userId") Integer userId, @RequestBody Integer roleId, UriComponentsBuilder a) {
        Role role = this.G.m_rc(userId, roleId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = roleId;
        return ResponseEntity.created((URI)a.path(BaseModel.m_cj((Object)"q +(;)\u0017?#t,42>-t%)17;\u0012:&")).buildAndExpand(objectArray).toUri()).body((Object)role);
    }

    @PostMapping(value={"/{userId}/spaces"})
    public ResponseEntity<Space> addSpace(@PathVariable(value="userId") Integer userId, @RequestBody Integer spaceId, UriComponentsBuilder a) {
        Space space = this.G.m_dc(userId, spaceId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = spaceId;
        return ResponseEntity.created((URI)a.path(BaseInfluxRepository.m_cj((Object)"\u0018>B6R7~!JjD5V&R6\u0018>D5V&R\fS8")).buildAndExpand(objectArray).toUri()).body((Object)space);
    }

    @DeleteMapping(value={"/{userId}/roles/{roleId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        this.G.m_sn(userId, a);
    }

    @DeleteMapping(value={"/{userId}/spaces/{spaceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        this.G.m_xc(userId, a);
    }

    @GetMapping(value={"/{userId}/spaces"})
    public Collection<Space> getSpaces(@PathVariable(value="userId") Integer a) {
        return this.G.m_bc(a);
    }

    @GetMapping(value={"/{userId}"})
    public User getUser(@PathVariable(value="userId") Integer a) {
        return this.G.m_aa(a);
    }

    @GetMapping
    public Collection<User> getUsers() {
        UserController a;
        return a.G.m_va();
    }

    @DeleteMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUser(@PathVariable(value="userId") Integer a) {
        this.G.m_ia(a);
    }

    @GetMapping(value={"/active-space"})
    public String[] getAllSpaceUsers() {
        UserController a;
        return a.G.m_ln();
    }

    @PutMapping(value={"/ui-configs"})
    public void setUIConfigs(@RequestBody String value, Principal a) {
        this.G.m_kc(value, a.getName());
    }

    public UserController(c_qa a) {
        UserController a2;
        a2.G = a;
    }

    @GetMapping(value={"/{userId}/roles/{roleId}"})
    public Role getRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        return this.G.m_hc(userId, a);
    }

    @GetMapping(value={"/{userId}/spaces/{spaceId}"})
    public Space getSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        return this.G.m_ec(userId, a);
    }

    @GetMapping(value={"/ui-configs"})
    public String getUIConfigs(Principal a) {
        UserController a2;
        return a2.G.m_tl(a.getName());
    }

    @PostMapping(value={"/{username}/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetPassword(@PathVariable(value="username") String username, @Valid @RequestBody ResetPasswordToken a) {
        this.G.m_zc(username, a);
    }

    @GetMapping(value={"/{userId}/roles"})
    public Collection<Role> getRoles(@PathVariable(value="userId") Integer a) {
        return this.G.m_pc(a);
    }

    @PutMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUser(@PathVariable(value="userId") Integer userId, @Valid @RequestBody User a) {
        this.G.m_wc(userId, a);
    }

    @PostMapping
    public ResponseEntity<User> createUser(@Valid @RequestBody UserDto userDto, UriComponentsBuilder a) {
        userDto = this.G.m_re(userDto);
        Object[] objectArray = new Object[1];
        objectArray[0] = userDto.getId();
        return ResponseEntity.created((URI)a.path(BaseModel.m_cj((Object)"t%.->,\u0012:&")).buildAndExpand(objectArray).toUri()).body((Object)userDto);
    }

    @PutMapping(value={"/agree"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void acceptEula(Principal a) {
        UserController a2;
        a2.G.m_qc(a.getName());
    }
}

