/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.trend.restcontrollers;

import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.g.c_kf;
import com.inscada.mono.space.c_ec;
import com.inscada.mono.trend.g.c_jb;
import com.inscada.mono.trend.model.Trend;
import com.inscada.mono.trend.model.TrendTag;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/trends"})
public class TrendController
extends ProjectBasedImportExportController {
    private final c_jb G;

    @PutMapping(value={"/{trendId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTrend(@PathVariable(value="trendId") Integer trendId, @Valid @RequestBody Trend a) {
        this.G.m_sf(trendId, a);
    }

    @PostMapping(value={"/{trendId}/tags"})
    public ResponseEntity<TrendTag> createTrendTag(@PathVariable(value="trendId") Integer trendId, @Valid @RequestBody TrendTag trendTag, UriComponentsBuilder a) {
        trendTag = this.G.m_fn(trendId, trendTag);
        Object[] objectArray = new Object[2];
        objectArray[0] = trendId;
        objectArray[1] = trendTag.getId();
        return ResponseEntity.created((URI)a.path(VariableFilter.m_cj((Object)"BI\u0019@\b\\\t{\tOBF\fU\u001e\u001d\u0016F\fU$V\u0010")).buildAndExpand(objectArray).toUri()).body((Object)trendTag);
    }

    @GetMapping
    public Collection<Trend> getTrends(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.G.m_va();
        }
        return this.G.m_da(a);
    }

    @DeleteMapping(value={"/{trendId}/tags/{tagId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteTrendTag(@PathVariable(value="trendId") Integer trendId, @PathVariable(value="tagId") Integer a) {
        this.G.m_uf(trendId, a);
    }

    @PutMapping(value={"/{trendId}/tags/{tagId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTrendTag(@PathVariable(value="trendId") Integer trendId, @PathVariable(value="tagId") Integer tagId, @Valid @RequestBody TrendTag a) {
        this.G.m_vi(trendId, tagId, a);
    }

    @GetMapping(value={"/{trendId}/tags"})
    public Collection<TrendTag> getTrendTags(@PathVariable(value="trendId") Integer a) {
        return this.G.m_wm(a);
    }

    @DeleteMapping(value={"/tags"}, params={"tagIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteTrendTagsByIds(@RequestParam(value="tagIds") Integer[] a) {
        this.G.m_go(List.of(a));
    }

    @GetMapping(value={"/{trendId}/tags/{tagId}"})
    public TrendTag getTrendTag(@PathVariable(value="trendId") Integer trendId, @PathVariable(value="tagId") Integer a) {
        return this.G.m_yg(trendId, a);
    }

    public TrendController(c_jb a, c_hh a2, c_kf a3) {
        super(a2, EnumSet.of(c_wk.m), a3);
        TrendController a4;
        a4.G = a;
    }

    @DeleteMapping(value={"/{trendId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteTrend(@PathVariable(value="trendId") Integer a) {
        this.G.m_ia(a);
    }

    @PostMapping
    public ResponseEntity<Trend> createTrend(@Valid @RequestBody Trend trend, UriComponentsBuilder a) {
        trend = this.G.m_jo(trend);
        Object[] objectArray = new Object[1];
        objectArray[0] = trend.getId();
        return ResponseEntity.created((URI)a.path(c_ec.m_cj((Object)"NP\u0015Y\u0004E\u0005b\u0005V")).buildAndExpand(objectArray).toUri()).body((Object)trend);
    }

    @PutMapping(value={"/date-options"})
    public void setTrendDateOptions(@RequestBody String value, Principal a) {
        this.G.m_kf(value, a.getName());
    }

    @DeleteMapping(value={""}, params={"trendIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteTrendsByIds(@RequestParam(value="trendIds") Integer[] a) {
        this.G.m_mc(List.of(a));
    }

    @GetMapping(value={"/date-options"})
    public String getTrendDateOptions(Principal a) {
        TrendController a2;
        return a2.G.m_eo(a.getName());
    }

    @GetMapping(value={"/{trendId}"})
    public Trend getTrend(@PathVariable(value="trendId") Integer a) {
        return this.G.m_aa(a);
    }
}

