/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.trend.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.trend.model.Trend;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="trend_tag")
@CheckAtLeastOneNotNull.List(value={@CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"}), @CheckAtLeastOneNotNull(fieldNames={"trendId", "trend"})})
public class TrendTag
extends SpaceBaseModel {
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="variable_id")
    private Variable<?, ?, ?> variable;
    @Column(name="trend_id", insertable=false, updatable=false)
    private Integer trendId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="trend_id")
    private Trend trend;
    @Size(max=7)
    private String color;
    @Column(name="variable_id", insertable=false, updatable=false)
    private Integer variableId;
    @Column(name="grid_thickness")
    private Double gridThickness;
    @Column(name="tag_order")
    private Integer order;
    @Column(name="max_scale")
    private Double maxScale;
    @NotNull
    @Column(name="status_flag")
    private Boolean status;
    @Column(name="hide_value_axe")
    private Boolean hideValueAxe;
    @Id
    @Column(name="trend_tag_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="trendTagSeq")
    @GenericGenerator(name="trendTagSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="trend_tag_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Min(value=1L)
    private Integer thickness;
    @Column(name="min_scale")
    private Double minScale;
    @Size(max=255)
    private String dsc;

    public void setHideValueAxe(Boolean a) {
        a.hideValueAxe = a;
    }

    public String getName() {
        TrendTag a;
        return a.name;
    }

    public Integer getVariableId() {
        TrendTag a;
        return a.variableId;
    }

    public void setVariableId(Integer a) {
        a.variableId = a;
    }

    public Short getVariableDecimalPoint() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getFractionalDigitCount();
        }
        return null;
    }

    public Double getMaxScale() {
        TrendTag a;
        return a.maxScale;
    }

    public String getColor() {
        TrendTag a;
        return a.color;
    }

    public Variable<?, ?, ?> getVariable() {
        TrendTag a;
        return a.variable;
    }

    public Integer getTrendId() {
        TrendTag a;
        return a.trendId;
    }

    public void setVariable(Variable<?, ?, ?> a) {
        TrendTag a2;
        TrendTag trendTag = a2;
        trendTag.variable = a;
        trendTag.variableId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setThickness(Integer a) {
        a.thickness = a;
    }

    public Double getGridThickness() {
        TrendTag a;
        return a.gridThickness;
    }

    public String getVariableName() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getName();
        }
        return null;
    }

    public void setOrder(Integer a) {
        a.order = a;
    }

    public String getVariableUnit() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getUnit();
        }
        return null;
    }

    public Trend getTrend() {
        TrendTag a;
        return a.trend;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Boolean getStatus() {
        TrendTag a;
        return a.status;
    }

    public void setGridThickness(Double a) {
        a.gridThickness = a;
    }

    public Integer getId() {
        TrendTag a;
        return a.id;
    }

    public Double getMinScale() {
        TrendTag a;
        return a.minScale;
    }

    public void setMaxScale(Double a) {
        a.maxScale = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public Integer getThickness() {
        TrendTag a;
        return a.thickness;
    }

    public Integer getOrder() {
        TrendTag a;
        return a.order;
    }

    public boolean equals(Object a) {
        TrendTag a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof TrendTag)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (TrendTag)a;
        return a2.getName().equals(a.getName()) && a2.getTrendId().equals(a.getTrendId());
    }

    public int hashCode() {
        TrendTag a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        objectArray[2] = a.getTrendId();
        return Objects.hash(objectArray);
    }

    public void setStatus(Boolean a) {
        a.status = a;
    }

    public Boolean getHideValueAxe() {
        TrendTag a;
        return a.hideValueAxe;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setTrendId(Integer a) {
        a.trendId = a;
    }

    public void setTrend(Trend a) {
        TrendTag a2;
        TrendTag trendTag = a2;
        trendTag.trend = a;
        trendTag.trendId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setMinScale(Double a) {
        a.minScale = a;
    }

    public void setColor(String a) {
        a.color = a;
    }

    public String getDsc() {
        TrendTag a;
        return a.dsc;
    }

    public TrendTag() {
        TrendTag a;
    }
}

