/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.tracking.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.tracking.model.MonitorVariable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="monitor_table")
public class MonitorTable
extends SpaceBaseModel {
    @Size(max=255)
    private String dsc;
    @Id
    @Column(name="monitor_table_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="monitorTableSeq")
    @GenericGenerator(name="monitorTableSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="monitor_table_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Column(name="x_count")
    private Integer xCount;
    @OneToMany(mappedBy="monitorTable", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<MonitorVariable> monitorVariables;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @NotBlank
    @Size(max=100)
    private String name;

    public Integer getxCount() {
        MonitorTable a;
        return a.xCount;
    }

    public Integer getId() {
        MonitorTable a;
        return a.id;
    }

    public Integer getProjectId() {
        MonitorTable a;
        return a.projectId;
    }

    public Set<MonitorVariable> getMonitorVariables() {
        MonitorTable a;
        return a.monitorVariables;
    }

    public void setMonitorVariables(Set<MonitorVariable> a) {
        a.monitorVariables = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public boolean equals(Object a) {
        MonitorTable a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof MonitorTable)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (MonitorTable)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public int hashCode() {
        MonitorTable a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setProject(Project a) {
        a.project = a;
    }

    public Project getProject() {
        MonitorTable a;
        return a.project;
    }

    public String getDsc() {
        MonitorTable a;
        return a.dsc;
    }

    public MonitorTable() {
        MonitorTable a;
        MonitorTable monitorTable = a;
        monitorTable.monitorVariables = new HashSet();
    }

    public void setxCount(Integer a) {
        a.xCount = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public String getName() {
        MonitorTable a;
        return a.name;
    }
}

