/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.communication.protocols.mqtt.model.MqttSetValueRequestSummary;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.shared.exceptions.c_al;
import com.inscada.mono.shared.exceptions.c_bh;
import com.inscada.mono.shared.exceptions.c_km;
import com.inscada.mono.shared.exceptions.c_pa;
import com.inscada.mono.shared.exceptions.c_rc;
import com.inscada.mono.shared.exceptions.c_rj;
import com.inscada.mono.shared.exceptions.c_ze;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String J = "Validation Error";
    private static final String m = "Already Exists Error";
    private static final Logger j = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String f = "Inscada Error";
    private static final String H = "Unknown Error";
    @Value(value="${spring.profiles.active}")
    private String h;
    private static final String c = "Relation Exists Error";
    private static final String A = "Not Found Error";
    private static final String i = "Mismatch Error";
    private static final String d = "Constraint Violation";
    private static final String k = "Security Error";
    private static final String D = "File Storage Error";
    private static final String F = "Database Error";
    private static final String G = "Not Active Error";

    @ExceptionHandler(value={TransactionSystemException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException a) {
        GeneralExceptionHandler a2;
        Throwable throwable = a.getRootCause();
        if (throwable instanceof ConstraintViolationException) {
            return a2.handleConstraintViolation((ConstraintViolationException)throwable);
        }
        throwable = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, F);
        j.error(c_ye.m_cj((Object)"\u0011o$s6|&i,r+=6d6i pex7o*o\u007f=>`"), (Object)throwable, (Object)a);
        return new ResponseEntity((Object)throwable, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException a) {
        GeneralExceptionHandler a2;
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getName();
        objectArray[1] = a.getValue();
        objectArray[2] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : c_ye.m_cj((Object)"h+v+r2s");
        String string = String.format(MqttSetValueRequestSummary.m_cj((Object)"K?i?v;o;i~<{hy;)r*s~m?w+~~<{hy;=t+w:;0t*;<~~x1u(~,o;\u007f~o1;*b.~~<{hy"), objectArray);
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, string, (Exception)a, J);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"\nb.~~v7h3z*x6!~`#"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4) {
        GeneralExceptionHandler a5;
        return a5.createExceptionDetails(a, a2, a3, a4, null);
    }

    private /* synthetic */ boolean isDevelopment() {
        GeneralExceptionHandler a;
        String[] stringArray = new String[2];
        stringArray[0] = c_ye.m_cj((Object)"y k");
        stringArray[1] = MqttSetValueRequestSummary.m_cj((Object)"o;h*");
        return Arrays.asList(stringArray).contains(a.h);
    }

    @ExceptionHandler(value={c_km.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMismatch(c_km a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, i);
        j.error(c_ye.m_cj((Object)"\bt6p$i&uex7o*o\u007f=>`"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ String sanitizeMessage(String a, Exception a2) {
        GeneralExceptionHandler a3;
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof c_ze) {
            return MqttSetValueRequestSummary.m_cj((Object)"\f~-t+i=~~z2i;z:b~~&r-o-");
        }
        if (a2 instanceof c_rj) {
            return c_ye.m_cj((Object)"[,q =*m o$i,r+=#|,q y");
        }
        if (a2 instanceof c_km) {
            return MqttSetValueRequestSummary.m_cj((Object)"\f~-t+i=~~v7h3z*x6");
        }
        if (a2 instanceof c_al) {
            return c_ye.m_cj((Object)"\u0017x6r0o&xet6=+r1=$~1t3x");
        }
        if (a2 instanceof c_bh) {
            return MqttSetValueRequestSummary.m_cj((Object)"I;h1n,x;;0t*;8t+u:");
        }
        if (a2 instanceof c_rc) {
            return c_ye.m_cj((Object)"O q$i yeo n*h7~ = e,n1n");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return MqttSetValueRequestSummary.m_cj((Object)"\u001az*z<z-~~x1u-o,z7u*;(r1w?o7t0");
        }
        if (a2 instanceof TransactionSystemException) {
            return c_ye.m_cj((Object)"\u0001|1|'|6xei7|+n$~1t*sex7o*o");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return MqttSetValueRequestSummary.m_cj((Object)"O7v;;-~,r;h~\u007f?o?y?h;;;i,t,");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return c_ye.m_cj((Object)"\\&~ n6=!x+t y");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return MqttSetValueRequestSummary.m_cj((Object)"\u0017u(z2r:;7u.n*");
        }
        if (a2 instanceof ConstraintViolationException) {
            return c_ye.m_cj((Object)"K$q,y$i,r+=&r+n1o$t+iek,r)|1t*s");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return MqttSetValueRequestSummary.m_cj((Object)"R0m?w7\u007f~i;j+~-o~}1i3z*");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return c_ye.m_cj((Object)"\bt6n,s\"=7x4h,o yem$o$p i o");
        }
        if (a2 instanceof IllegalStateException) {
            return MqttSetValueRequestSummary.m_cj((Object)"\u0017u(z2r:;?k.w7x?o7t0;-o?o;");
        }
        return c_ye.m_cj((Object)"\u0004seh+x=m ~1x!= o7r7=*~&h7o y");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleAllExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), a, H);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"N0~&k;x*~:;;i,t,!~`#"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a2) {
        headers = new HashMap();
        status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_ye.m_cj((Object)"\u000brep n6|\"xe|3|,q$\u007f)x");
        }, Collectors.toList())));
        a2 = ex.getBindingResult().getGlobalErrors().stream().map(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_ye.m_cj((Object)"\u000brep n6|\"xe|3|,q$\u007f)x");
        }).collect(Collectors.toList());
        headers.putAll(status);
        if (!a2.isEmpty()) {
            headers.put(c_ye.m_cj((Object)"\"q*\u007f$q"), a2);
        }
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, this.formatErrorMessages((Map)headers), (Exception)ex, J, (Map)headers);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"M?w7\u007f?o7t0;;i,t,!~`#"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, f);
        j.error(c_ye.m_cj((Object)"T)q z$qen1|1x\u007f=>`"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4, Map<String, List<String>> a5) {
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = a6;
        a2 = generalExceptionHandler.sanitizeMessage(a2, a3);
        String string = generalExceptionHandler.isDevelopment() ? a3.getClass().getName() : MqttSetValueRequestSummary.m_cj((Object)"\u001bc=~.o7t0");
        String string2 = a6.isDevelopment() ? a4 : c_ye.m_cj((Object)"X7o*o");
        String string3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a3) : null;
        return new ExceptionDetails(a.value(), a2, string, string2, a5, a4 = string3, new Date(), a6.getCurrentPath());
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = ex.getParameterName();
        objectArray[1] = ex.getParameterType();
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, String.format(MqttSetValueRequestSummary.m_cj((Object)"\f~/n7i;\u007f~k?i?v;o;i~<{hy;1}~o'k;;y>-<~r-;3r-h7u9"), objectArray), (Exception)ex, J);
        j.error(c_ye.m_cj((Object)"P,n6t+zem$o$p i o\u007f=>`"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return MqttSetValueRequestSummary.m_cj((Object)"k?o64+u5u1l0");
        }
    }

    @ExceptionHandler(value={c_pa.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInscadaException(c_pa a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, f);
        j.error(c_ye.m_cj((Object)"T+n&|!|ex7o*o\u007f=>`"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> a2) {
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)MqttSetValueRequestSummary.m_cj((Object)"7~"), (Iterable)a.getValue())).collect(Collectors.joining(MqttSetValueRequestSummary.m_cj((Object)"~g~")));
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(status, ex.getMessage(), ex, H);
        j.error(c_ye.m_cj((Object)"\fs1x7s$qex7o*o\u007f=>`"), (Object)ex);
        return new ResponseEntity((Object)ex, status);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, J);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"R2w;|?w~z,|+v;u*!~`#"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, F);
        j.error(c_ye.m_cj((Object)"\u0001|1|et+i z7t1dek,r)|1t*s\u007f=>`"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={c_rc.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleRelationExists(c_rc a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, c);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"\f~2z*r1u~~&r-o-;;i,t,!~`#"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException a2) {
        GeneralExceptionHandler a3;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails(HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, d, map);
        j.error(c_ye.m_cj((Object)"\u0006r+n1o$t+iek,r)|1t*s\u007f=>`"), (Object)a2);
        return new ResponseEntity((Object)a2, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={c_al.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleNotActive(c_al a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, G);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"U1o~z=o7m;;;i,t,!~`#"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, F);
        j.error(c_ye.m_cj((Object)"T+{)h=Y\u0007=(|5m oex7o*o\u007f=>`"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public GeneralExceptionHandler() {
        GeneralExceptionHandler a;
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, J);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"V;h-z9~~u1o~i;z:z<w;!~`#"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_bh.class, EntityNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    protected ResponseEntity<Object> handleEntityNotFound(Exception a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.NOT_FOUND, a.getMessage(), a, A);
        j.error(c_ye.m_cj((Object)"\u0000s1t1des*ie{*h+y\u007f=>`"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={c_rj.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleFileStorage(c_rj a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, D);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"]7w;;-o1i?|;;;i,t,!~`#"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    protected ResponseEntity<Object> handleSecurityExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.FORBIDDEN, a.getMessage(), a, k);
        j.error(c_ye.m_cj((Object)"\u0016x&h7t1dex7o*o\u007f=>`"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={c_ze.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleAlreadyExists(c_ze a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, m);
        j.error(MqttSetValueRequestSummary.m_cj((Object)"Z2i;z:b~~&r-o-;;i,t,!~`#"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }
}

