/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.auth.c_kka;
import com.inscada.mono.cluster.g.c_xga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_t;
import com.inscada.mono.communication.protocols.iec61850.model.Node;
import com.inscada.mono.job.i.c_fl;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.script.enums.c_df;
import com.inscada.mono.script.enums.c_on;
import com.inscada.mono.script.events.CancelEvent;
import com.inscada.mono.script.events.RescheduleEvent;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_ff;
import com.inscada.mono.script.services.c_jk;
import com.inscada.mono.script.services.c_qn;
import com.inscada.mono.shared.exceptions.c_al;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener {
    public static final short B = 307;
    private final c_fl L;
    private final Map<Integer, Job> M;
    public static final short J = 306;
    private final JedisPooled m;
    public static final short j = 301;
    private final c_t f;
    private final Lock H;
    public static final short h = 303;
    public static final short c = 302;
    private static final Logger A = LoggerFactory.getLogger(ScriptManager.class);
    private final c_qn i;
    public static final short d = 305;
    private final c_jk k;
    public static final short D = 304;
    private static final String F = "scheduled_scripts";
    private final c_ye G;

    protected void scheduleScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.scheduleScriptInternal(scriptManager.i.m_lj(a));
    }

    public ScriptManager(c_qn a, c_fl a2, c_jk a3, c_ye a4, JedisPooled a5, c_t a6) {
        ScriptManager a7;
        ScriptManager scriptManager = a7;
        ScriptManager scriptManager2 = a7;
        ScriptManager scriptManager3 = a7;
        ScriptManager scriptManager4 = a7;
        a7.H = new ReentrantLock();
        scriptManager4.M = new ConcurrentHashMap();
        scriptManager3.i = a;
        scriptManager3.L = a2;
        scriptManager2.k = a3;
        scriptManager2.G = a4;
        scriptManager.m = a5;
        scriptManager.f = a6;
    }

    public void notLeader() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        String string = scriptManager.f.m_wa().getNodeId();
        A.info(Node.m_cj((Object)"PzqpsmNxmxd|q##Mkpp9mvg|#1xd*9jj#WL9OVM^FK#MK\\#UFXG\\Q7#Zbw`|oujwd9buo9ov`xo9pzqpsm#sl{p7-7"), (Object)string);
        scriptManager.H.lock();
        try {
            new ArrayList(a.M.keySet()).forEach(a2 -> {
                ScriptManager a3;
                Job job = (Job)a3.M.get(a2);
                if (job != null) {
                    try {
                        A.info(EvalAnimationMessage.m_cj((Object)"v{WqUlhyKyB}W8\rVJl\u0005T@yA}W8^e\f\"\u0005[DvF}ItLvB8IwFyI8OwG8CwW8V{WqUl\u0005Qa\"\u0005cX"), (Object)string, a2);
                        a3.L.m_pca(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        A.error(Node.m_cj((Object)"PzqpsmNxmxd|q9+Wlm#Ufxg|q9xd*##\\qklk#zbw`|oujwd9ov`xo9iva9evq9pzqpsm#PG9xd99xd"), objectArray);
                    }
                }
            });
            a.M.clear();
            A.info(EvalAnimationMessage.m_cj((Object)"v{WqUlhyKyB}W8\rVJl\u0005T@yA}W8^e\f\"\u0005YIt\u0005tJ{Dt\u0005kFjLhQ8OwGk\u0005pDn@8G}@v\u0005j@iP}Vl@|\u0005lJ8FyK{@t\u0005yK|\u0005{I}Dj@|\u0005~WwH8IwFyI8QjD{NqK\u007f\u000b"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            A.error(Node.m_cj((Object)"J`kjiwTbwb~fk#1Mvw9O|b}fk#b~099Fkqvq9glqpm~#iqv`|pj#ve9`xmzfuopm~#ulzbu#j`kjiw9ivaj99xd"), objectArray);
            return;
        }
        finally {
            a.H.unlock();
        }
    }

    protected void scheduleScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_kka.m_vbc(() -> {
            ScriptManager a2;
            a2.H.lock();
            try {
                Job job;
                ScriptManager scriptManager;
                block14: {
                    a2.cancelScriptInternal(a);
                    if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                        throw new c_al("Project should be active to schedule script " + a.getName());
                    }
                    switch (c_ff.G[a.getType().ordinal()]) {
                        case 1: {
                            ScriptManager scriptManager2 = a2;
                            while (false) {
                            }
                            scriptManager = scriptManager2;
                            job = scriptManager2.createDailyScriptJob(a);
                            break block14;
                        }
                        case 2: {
                            ScriptManager scriptManager3 = a2;
                            scriptManager = scriptManager3;
                            job = scriptManager3.createPeriodicScriptJob(a);
                            break block14;
                        }
                        case 3: {
                            job = a2.createOnceScriptJob(a);
                            break;
                        }
                        case 4: {
                            return;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown schedule type of " + a.getType());
                        }
                    }
                    scriptManager = a2;
                }
                scriptManager.M.put(a.getId(), job);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.m.sadd(F, stringArray);
                return;
            }
            finally {
                a2.H.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ String generateJobName(RepeatableScript a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = a.getType().m_e();
        objectArray[1] = a.getName();
        return String.format(EvalAnimationMessage.m_cj((Object)"=V8v{WqUl\u00055\u0005=V"), objectArray);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            A.debug(Node.m_cj((Object)"UFXG\\Q##J`qf}vujwd9pzqpsm#b~9ov`xouz7"), (Object)a);
            a2.scheduleScriptInternal(a);
            return;
        }
        A.debug(EvalAnimationMessage.m_cj((Object)"VjV\bT`Ya]w\"\u0005J@iP}VlLvB8I}D|@j\u0005lJ8V{M}AmI}\u0005kFjLhQ8^e\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)301), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC schedule script " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_on> getScriptStatuses(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f.m_rb()) {
            A.debug(Node.m_cj((Object)"O\\B]FK99D|wmjwd9pzqpsm#jwxwlp|p9evq9xd#PGj#ulzbuo`99xd"), (Object)a.size(), a);
            return a2.getScriptStatusesByIdsInternal(a);
        }
        A.debug(EvalAnimationMessage.m_cj((Object)"VjV\bT`Ya]w\"\u0005J@iP}VlLvB8I}D|@j\u0005~Jj\u0005kFjLhQ8VlDlPk@k\u0005~Jj\u0005cX8l\\V\"\u0005cX"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.f.m_ib(Short.valueOf((short)306), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(Node.m_cj((Object)"5"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        String string = scriptManager.f.m_wa().getNodeId();
        A.info(EvalAnimationMessage.m_cj((Object)"v{WqUlhyKyB}W\"\u0005LMqV8KwA}\u00050^e\f8MyV8G}FwH}\u0005lM}\u0005T`Ya]w6\u0005J@kQwWqK\u007f\u0005kFp@|Pt@|\u0005kFjLhQk\u000b6\u000b"), (Object)string);
        scriptManager.H.lock();
        try {
            Set set = a2.m.smembers(F).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                A.info(Node.m_cj((Object)"PzqpsmNxmxd|q9+Ufxg|q9xd*##Wl9pzk|glo|g9pzqpsmp9evvwg9jw#Kf}jj#ml9q|pmlkf7"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            A.info(EvalAnimationMessage.m_cj((Object)"KFjLhQUDvD\u007f@j\u00050i}D|@j\u0005cX1\u001f8cwPvA8^e\u0005kFp@|Pt@|\u0005kFjLhQ8l\\V8Lv\u0005J@|Lk\u0005lJ8W}VlJj@\"\u0005cX"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = Node.m_cj((Object)"OJ\\TFPZQPSM");
            c_kka.m_rub(() -> {
                ScriptManager a3;
                arrayList.addAll(a3.i.m_ki(set));
            }, (String[])stringArray);
            A.info(EvalAnimationMessage.m_cj((Object)"KFjLhQUDvD\u007f@j\u00050i}D|@j\u0005cX1\u001f8dlQ}HhQqK\u007f\u0005lJ8W}VlJj@8^e\u0005kFjLhQk\u000b"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ScriptManager a2;
                ScriptManager scriptManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = EvalAnimationMessage.m_cj((Object)"v[m]aMi]zKfJlHq");
                stringArray[1] = Node.m_cj((Object)"ZBW@\\OFPZQPSM");
                c_kka.m_lub(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1(scriptManager.f.m_wa().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            A.info(Node.m_cj((Object)"J`kjiwTbwb~fk#1O|b}fk#b~099Epmppqf}#j`kjiw9q|pmlkbmjvm9sklzfjp7"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            A.error(EvalAnimationMessage.m_cj((Object)"KFjLhQUDvD\u007f@j\u00050i}D|@j\u0005cX1\u001f8`jWwW8AmWqK\u007f\u0005kFjLhQ8W}VlJjDlLwK8UjJ{@kV\"\u0005cX"), objectArray);
            return;
        }
        finally {
            a2.H.unlock();
        }
    }

    @Order(value=1)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            Integer n = a.getProject().getId();
            A.info(Node.m_cj((Object)"O\\B]FK99Kxm}opm~#Iqvi|`mG|bzwpuxw|Fofww9evq9sklsfzw9J]99xd"), (Object)n);
            a2.cancelScriptsByProjectIdInternal(n);
            return;
        }
        A.debug(EvalAnimationMessage.m_cj((Object)"VjV\bT`Ya]w\"\u0005QBvJjLvB8ujJr@{Q\\@yFlLnDl@]S}Kl\u0005~Jj\u0005hWwO}Fl\u0005Qa\"\u0005cX"), (Object)a.getProject().getId());
    }

    protected void cancelScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_kka.m_vbc(() -> {
            ScriptManager a2;
            a2.H.lock();
            try {
                Job job = (Job)a2.M.get(a.getId());
                if (job != null) {
                    a2.L.m_pca(job);
                }
                ScriptManager scriptManager = a2;
                scriptManager.M.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                scriptManager.m.srem(F, stringArray);
                return;
            }
            finally {
                a2.H.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(Integer a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            A.debug(Node.m_cj((Object)"O\\B]FK99@xmzfuopm~#xou#j`kjiwj#\u007flk#iqvi|`m#b~9ov`xouz7"), (Object)a);
            a2.cancelScriptsByProjectIdInternal(a);
            return;
        }
        A.debug(EvalAnimationMessage.m_cj((Object)"kWk5i]d\\`J\u001f8w}Tm@kQqK\u007f\u0005t@yA}W8Qw\u0005{DvF}I8DtI8V{WqUlV8CwW8UjJr@{Q8^e\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)305), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC cancel scripts for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            RepeatableScript repeatableScript = a.getScript();
            A.info(Node.m_cj((Object)"O\\B]FK99Kxm}opm~#Kfj`qf}vuf\\u|mm#\u007flk#j`kjiw##b~9+PG##b~0"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            if (a2.getScriptStatusInternal(repeatableScript.getId()) == c_on.k) {
                a2.scheduleScriptInternal(repeatableScript.getId());
                return;
            }
        } else {
            A.debug(EvalAnimationMessage.m_cj((Object)"kWk5i]d\\`J\u001f8l\u007fKwWqK\u007f\u0005J@kFp@|Pt@]S}Kl\u0005~Jj\u0005kFjLhQ\"\u0005cX"), (Object)a.getScript().getId());
        }
    }

    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String a, RepeatableScript a2) {
        ScriptManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            A.info(Node.m_cj((Object)"PzqpsmNxmxd|q9+Ufxg|q9xd*##Kfjwvqpm~#j`kjiw##b~9+PG##b~0"), objectArray);
            a3.scheduleScriptInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.G.m_lia(a2.getProject()).m_z("Script Restore (Leader " + a + ")", String.format(EvalAnimationMessage.m_cj((Object)"=V8\rQa\"\u0005=A1\u0005~DqI}A8Qw\u0005j@kQwW}\u000b8fyPk@\"\u0005=V"), objectArray));
            try {
                A.warn(Node.m_cj((Object)"PzqpsmNxmxd|q9+Ufxg|q9xd*##Xwmftsmjwd9wv#zbw`|o9pzqpsm#b~9b\u007fw|q9q|pmlkbmjvm9exjuvkf7"), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                A.error(EvalAnimationMessage.m_cj((Object)"v{WqUlhyKyB}W8\rT@yA}W8^e\f\"\u0005^DqI}A8Qw\u0005{DvF}I8V{WqUl\u0005cX8D~Q}W8W}VlJjDlLwK8CyLtPj@\"\u0005cX"), objectArray2);
                return;
            }
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ScriptManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.f.m_qb((short)301, (Object)a, ScriptManager.class.getDeclaredMethod(Node.m_cj((Object)"pzk|glo|PzqpsmJww|qwbu"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.f.m_qb((short)302, (Object)a, ScriptManager.class.getDeclaredMethod(EvalAnimationMessage.m_cj((Object)"{DvF}IKFjLhQQKl@jKyI"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.f.m_qb((short)303, (Object)a, ScriptManager.class.getDeclaredMethod(Node.m_cj((Object)"~fmPzqpsmPmbmvjJww|qwbu"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.f.m_qb((short)304, (Object)a, ScriptManager.class.getDeclaredMethod(EvalAnimationMessage.m_cj((Object)"kFp@|Pt@KFjLhQkgaujJr@{QQAQKl@jKyI"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.f.m_qb((short)305, (Object)a, ScriptManager.class.getDeclaredMethod(Node.m_cj((Object)"`xmzfuPzqpsmp[zIqvi|`mJ}Jww|qwbu"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.f.m_qb((short)306, (Object)a, ScriptManager.class.getDeclaredMethod(EvalAnimationMessage.m_cj((Object)"\u007f@lv{WqUlvlDlPk@kgal|VQKl@jKyI"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.f.m_qb((short)307, (Object)a, ScriptManager.class.getDeclaredMethod(Node.m_cj((Object)"d|wJ`kjiwJwxwlp|p[zIqvi|`mJ}Jww|qwbu"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(EvalAnimationMessage.m_cj((Object)"^DqI}A8Qw\u0005j@\u007fLkQ}W8v{WqUlhyKyB}W8wHf8H}QpJ|V"), noSuchMethodException);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.f.m_sa((ClusterNodeListener)a);
        A.info(Node.m_cj((Object)"PzqpsmNxmxd|q9jwjmjxopy|g9bwg9q|dppmfkf}#xp9@uvjw|qWl}fUjjw|m|q7"));
    }

    protected void cancelScriptsByProjectIdInternal(Integer a) {
        ScriptManager a2;
        if ((a = a2.i.m_da((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    protected c_on getScriptStatusInternal(Integer a) {
        ScriptManager a2;
        if (a2.M.containsKey(a)) {
            return c_on.k;
        }
        return c_on.F;
    }

    protected Map<Integer, c_on> getScriptStatusesByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.i.m_gg((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, a -> {
            ScriptManager a2;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_on getScriptStatus(Integer a, String a2) {
        ScriptManager a3;
        if ((a = a3.i.m_af(a, a2)) == null) {
            return c_on.F;
        }
        return a3.getScriptStatus(a.getId());
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            RepeatableScript repeatableScript = a.getScript();
            A.info(EvalAnimationMessage.m_cj((Object)"T`Ya]w\"\u0005PDvAtLvB8fyK{@t`n@vQ8CwW8V{WqUl\u001f8^e\u00050l\\\u001f8^e\f"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            a2.cancelScriptInternal(repeatableScript);
            return;
        }
        A.debug(Node.m_cj((Object)"WLW.UFXG\\Q##Pdwlkjwd9@xmzfuFofww9evq9pzqpsm99xd"), (Object)a.getScript().getId());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.cancelScript(scriptManager.i.m_rh(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_on getScriptStatus(Integer a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            A.debug(EvalAnimationMessage.m_cj((Object)"i]d\\`J\u001f8b}QlLvB8V{WqUl\u0005kQyQmV8CwW8^e\u0005tJ{DtIa\u000b"), (Object)a);
            return a2.getScriptStatusInternal(a);
        }
        A.debug(Node.m_cj((Object)"WLW.UFXG\\Q##Kfhv|pmjwd9o|b}fk#\u007flk#j`kjiw9pmbmvj#\u007flk#b~7"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_on)a2.f.m_ib(Short.valueOf((short)303), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get script status for " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.L.m_ria(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            Script script = Script.newBuilder((RepeatableScript)a).build();
            a2.k.m_gl(script);
            a2.cancelScript(a.getId());
        }, Duration.ofMillis(a.getDelay().intValue()), false);
    }

    protected void cancelScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.cancelScriptInternal(scriptManager.i.m_lj(a));
    }

    protected void scheduleScriptsByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.i.m_da((Integer)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> a.getType() != c_df.d).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_on> getScriptStatuses(Integer a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            A.debug(EvalAnimationMessage.m_cj((Object)"i]d\\`J\u001f8b}QlLvB8DtI8V{WqUl\u0005kQyQmV}V8CwW8UjJr@{Q8^e\u0005tJ{DtIa\u000b"), (Object)a);
            return a2.getScriptStatusesByProjectIdInternal(a);
        }
        A.debug(Node.m_cj((Object)"WLW.UFXG\\Q##Kfhv|pmjwd9o|b}fk#\u007flk#xou#j`kjiw9pmbmvjfj#\u007flk#iqvi|`m#b~7"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.f.m_ib(Short.valueOf((short)307), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    protected Map<Integer, c_on> getScriptStatusesByIdsInternal(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.scheduleScript(scriptManager.i.m_rh(a, a2).getId());
    }

    private /* synthetic */ Job createDailyScriptJob(RepeatableScript a) {
        ScriptManager a2;
        Comparable<Date> comparable = a.getTime();
        comparable = LocalTime.of(comparable.getHours(), comparable.getMinutes(), comparable.getSeconds());
        return a2.L.m_bja(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.k.m_gl((Script)a);
        }, (LocalTime)comparable);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            A.debug(EvalAnimationMessage.m_cj((Object)"i]d\\`J\u001f8fyK{@tIqK\u007f\u0005kFjLhQ8^e\u0005tJ{DtIa\u000b"), (Object)a);
            a2.cancelScriptInternal(a);
            return;
        }
        A.debug(Node.m_cj((Object)"MVM4O\\B]FK99Q|rlfjwpm~#ufxg|q9wv#zbw`|o9pzqpsm#b~7"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)302), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC cancel script " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(Integer a) {
        ScriptManager a2;
        if (a2.f.m_rb()) {
            A.debug(EvalAnimationMessage.m_cj((Object)"T`Ya]w\"\u0005KFp@|PtLvB8DtI8V{WqUlV8CwW8UjJr@{Q8^e\u0005tJ{DtIa\u000b"), (Object)a);
            a2.scheduleScriptsByProjectIdInternal(a);
            return;
        }
        A.debug(Node.m_cj((Object)"WLW.UFXG\\Q##Kfhv|pmjwd9o|b}fk#ml9pzk|glo|#xou#j`kjiwj#\u007flk#iqvi|`m#b~7"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)304), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC schedule scripts for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.L.m_wga(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.k.m_gl((Script)a);
        }, Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }
}

