/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.restcontrollers;

import com.inscada.mono.auth.security.model.AuthDetails;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.job.g.c_ql;
import com.inscada.mono.project.g.c_kf;
import com.inscada.mono.report.enums.c_ed;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.report.model.ReportVariable;
import com.inscada.mono.report.services.ReportManager;
import com.inscada.mono.report.services.c_jd;
import com.inscada.mono.report.services.c_zj;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/reports"})
public class ReportController
extends ProjectBasedImportExportController {
    private final c_jd D;
    private final c_zj F;
    private final ReportManager G;

    @GetMapping(value={"/{reportId}/excelExport"})
    public ResponseEntity<byte[]> exportToExcel(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.F.m_du(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = AuthDetails.m_cj((Object)"bQwD`Mn@mQ8\u0005eLo@mDn@>\u0007Q@sJqQ-]oV!");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(c_ql.m_cj((Object)"RP\u007fKtQe\u0012UVbO~LxKxP\u007f"), stringArray)).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportGroup a) {
        this.D.m_wv(reportId, groupId, a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public ResponseEntity<ReportSubgroup> createReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportSubgroup reportSubgroup, UriComponentsBuilder a) {
        reportSubgroup = this.D.m_gu(reportId, groupId, reportSubgroup);
        Object[] objectArray = new Object[3];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = reportSubgroup.getId();
        return ResponseEntity.created((URI)a.path(c_ql.m_cj((Object)">DcZaPcKX[l\u0010vM~JaL>DvM~JavuB>Ld]vM~JaL>DbJsXcPdOX[l")).buildAndExpand(objectArray).toUri()).body((Object)reportSubgroup);
    }

    @GetMapping(value={"/{reportId}/status"})
    public c_ed getReportStatus(@PathVariable(value="reportId") Integer a) {
        return this.G.getReportStatus(a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}"})
    public ReportGroup getReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.D.m_rx(reportId, a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    public ReportSubgroup getReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.D.m_hs(reportId, groupId, a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        this.D.m_uw(reportId, groupId, a);
    }

    @DeleteMapping(value={"/groups/subgroups/variables"}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.D.m_ux(List.of(a));
    }

    @PostMapping(value={"/{reportId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReport(@PathVariable(value="reportId") Integer a) {
        this.G.cancelReport(a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        this.D.m_gt(reportId, groupId, subgroupId, a);
    }

    @PostMapping(value={"/{reportId}/mail"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void mailReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.F.m_vw(reportId, startDate, endDate, false, a);
    }

    public ReportController(c_jd a, ReportManager a2, c_zj a3, c_hh a4, c_kf a5) {
        ReportController a6;
        ReportController reportController = a6;
        super(a4, EnumSet.of(c_wk.a), a5);
        a6.D = a;
        reportController.G = a2;
        reportController.F = a3;
    }

    @GetMapping(value={"/{reportId}/groups"})
    public Collection<ReportGroup> getReportGroups(@PathVariable(value="reportId") Integer a) {
        return this.D.m_ut(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReports(@RequestParam(value="projectId") Integer a) {
        this.G.scheduleReports(a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public Collection<ReportVariable> getReportVariables(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.D.m_ur(reportId, groupId, a);
    }

    @PostMapping(value={"/cancel"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReports(@RequestParam(value="projectId") Integer a) {
        this.G.cancelReports(a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        this.D.m_rw(reportId, a);
    }

    @DeleteMapping(value={"/groups"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.D.m_so(List.of(a));
    }

    @GetMapping(value={"/{reportId}/preview"})
    public ResponseEntity<byte[]> previewReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.F.m_tp(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = c_ql.m_cj((Object)"pKe^rW|Z\u007fK*\u001fwV}Z\u007f^|Z,\u001dcZaPcK?OuY3");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(AuthDetails.m_cj((Object)"@JmQfKw\bGLpUlVjQjJm"), stringArray)).contentType(MediaType.APPLICATION_PDF).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @DeleteMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReport(@PathVariable(value="reportId") Integer a) {
        this.D.m_ia(a);
    }

    @DeleteMapping(value={"/groups/subgroups"}, params={"subgroupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubgroupsByIds(@RequestParam(value="subgroupIds") Integer[] a) {
        this.D.m_hr(List.of(a));
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportSubgroup a) {
        this.D.m_ey(reportId, groupId, subgroupId, a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public ResponseEntity<ReportVariable> createReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportVariable reportVariable, UriComponentsBuilder a) {
        reportVariable = this.D.m_mw(reportId, groupId, subgroupId, reportVariable);
        Object[] objectArray = new Object[4];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = subgroupId;
        objectArray[3] = reportVariable.getId();
        return ResponseEntity.created((URI)a.path(AuthDetails.m_cj((Object)"\nxWfUlWwlgX,BqJvUp\nxBqJvUJA~\npPaBqJvUp\nxVvGdWlPslgX,SbWjDaIfV,^uDqLbGo@JA~")).buildAndExpand(objectArray).toUri()).body((Object)reportVariable);
    }

    @PostMapping(value={"/{reportId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReport(@PathVariable(value="reportId") Integer a) {
        this.G.scheduleReport(a);
    }

    @DeleteMapping(value={""}, params={"reportIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportsByIds(@RequestParam(value="reportIds") Integer[] a) {
        this.D.m_mc(List.of(a));
    }

    @GetMapping(value={"/{reportId}"})
    public Report getReport(@PathVariable(value="reportId") Integer a) {
        return this.D.m_aa(a);
    }

    @PostMapping
    public ResponseEntity<Report> createReport(@Valid @RequestBody Report report, UriComponentsBuilder a) {
        report = this.D.m_qx(report);
        Object[] objectArray = new Object[1];
        objectArray[0] = report.getId();
        return ResponseEntity.created((URI)a.path(c_ql.m_cj((Object)">DcZaPcKX[l")).buildAndExpand(objectArray).toUri()).body((Object)report);
    }

    @PutMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReport(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody Report a) {
        this.D.m_iy(reportId, a);
    }

    @GetMapping
    public Collection<Report> getReports(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.D.m_va();
        }
        return this.D.m_da(a);
    }

    @PostMapping(value={"/{reportId}/print"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void printReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.F.m_tt(reportId, startDate, endDate, false, a);
    }

    @GetMapping(value={"/statuses"})
    public Map<Integer, c_ed> getReportStatuses(@RequestParam(value="reportIds") Integer[] a) {
        return this.G.getReportStatuses(Arrays.asList(a));
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody ReportVariable a) {
        this.D.m_qp(reportId, groupId, subgroupId, variableId, a);
    }

    @PostMapping(value={"/{reportId}/groups"})
    public ResponseEntity<ReportGroup> createReportGroup(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody ReportGroup reportGroup, UriComponentsBuilder a) {
        reportGroup = this.D.m_dw(reportId, reportGroup);
        Object[] objectArray = new Object[2];
        objectArray[0] = reportId;
        objectArray[1] = reportGroup.getId();
        return ResponseEntity.created((URI)a.path(AuthDetails.m_cj((Object)"\nxWfUlWwlgX,BqJvUp\nxBqJvUJA~")).buildAndExpand(objectArray).toUri()).body((Object)reportGroup);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public Collection<ReportSubgroup> getReportSubgroups(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.D.m_it(reportId, a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    public ReportVariable getReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        return this.D.m_mx(reportId, groupId, subgroupId, a);
    }
}

