/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.report.enums.c_io;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="report")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Report
extends OwnedSpaceBaseModel {
    @Size(max=50)
    private String no;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="mail_day")
    private Short mailDay;
    private String lang;
    @NotNull
    @Column(name="mail_flag")
    private Boolean mailFlag;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="report_time")
    private Date reportTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="print_time")
    private Date printTime;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="print_day")
    private Short printDay;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @Column(name="mail_to")
    private String mailTo;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="mail_time")
    private Date mailTime;
    @Size(max=255)
    private String dsc;
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @OneToMany(mappedBy="report", orphanRemoval=true)
    private Set<ReportGroup> reportGroups;
    @Id
    @Column(name="report_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="reportSeq")
    @GenericGenerator(name="reportSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="report_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @NotNull
    private c_io period;
    @Min(value=1L)
    @Column(name="minutes")
    private Integer minutes;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="report_day")
    private Short reportDay;
    @NotNull
    @Column(name="logo_flag")
    private Boolean logoFlag;
    @NotNull
    @Column(name="print_flag")
    private Boolean printFlag;

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public String getNo() {
        Report a;
        return a.no;
    }

    public void setMailDay(Short a) {
        a.mailDay = a;
    }

    public String getMailTo() {
        Report a;
        return a.mailTo;
    }

    public Short getReportDay() {
        Report a;
        return a.reportDay;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public Date getMailTime() {
        Report a;
        return a.mailTime;
    }

    public c_io getPeriod() {
        Report a;
        return a.period;
    }

    public Set<ReportGroup> getReportGroups() {
        Report a;
        return a.reportGroups;
    }

    public Report() {
        Report a;
        Report report = a;
        report.reportGroups = new HashSet();
    }

    public Integer getId() {
        Report a;
        return a.id;
    }

    public String getName() {
        Report a;
        return a.name;
    }

    public void setPeriod(c_io a) {
        a.period = a;
    }

    public Project getProject() {
        Report a;
        return a.project;
    }

    public void setReportTime(Date a) {
        a.reportTime = a;
    }

    public int hashCode() {
        Report a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setMailFlag(Boolean a) {
        a.mailFlag = a;
    }

    public Date getPrintTime() {
        Report a;
        return a.printTime;
    }

    public String getDsc() {
        Report a;
        return a.dsc;
    }

    public Boolean getLogoFlag() {
        Report a;
        return a.logoFlag;
    }

    public Short getPrintDay() {
        Report a;
        return a.printDay;
    }

    public void setProject(Project a) {
        Report a2;
        Report report = a2;
        report.project = a;
        report.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Integer getProjectId() {
        Report a;
        return a.projectId;
    }

    public Short getMailDay() {
        Report a;
        return a.mailDay;
    }

    public void setLang(String a) {
        a.lang = a;
    }

    public void setPrintDay(Short a) {
        a.printDay = a;
    }

    public Integer getMinutes() {
        Report a;
        return a.minutes;
    }

    public void setMailTo(String a) {
        a.mailTo = a;
    }

    public void setLogoFlag(Boolean a) {
        a.logoFlag = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setMailTime(Date a) {
        a.mailTime = a;
    }

    public Boolean getMailFlag() {
        Report a;
        return a.mailFlag;
    }

    public void setReportDay(Short a) {
        a.reportDay = a;
    }

    public boolean equals(Object a) {
        Report a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Report)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Report)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setMinutes(Integer a) {
        a.minutes = a;
    }

    public void setPrintTime(Date a) {
        a.printTime = a;
    }

    public String getLang() {
        Report a;
        return a.lang;
    }

    public void setPrintFlag(Boolean a) {
        a.printFlag = a;
    }

    public void setNo(String a) {
        a.no = a;
    }

    public Date getReportTime() {
        Report a;
        return a.reportTime;
    }

    public Boolean getPrintFlag() {
        Report a;
        return a.printFlag;
    }

    public void setReportGroups(Set<ReportGroup> a) {
        a.reportGroups = a;
    }
}

