/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.restcontrollers;

import com.inscada.mono.auth.services.g.i.g.c_kaa;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.model.ImportResult;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.g.c_dn;
import com.inscada.mono.project.g.c_kf;
import com.inscada.mono.project.g.c_xg;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.project.model.ProjectClone;
import com.inscada.mono.project.model.ProjectLocationDto;
import com.inscada.mono.project.model.ProjectStatus;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/projects"})
public class ProjectController
extends ProjectBasedImportExportController {
    private final c_kf G;
    private final c_dn F;
    private final c_xg G;

    @GetMapping(value={"/{projectId}/status"})
    public ProjectStatus getStatus(@PathVariable(value="projectId") Integer a) {
        return this.F.m_hy(a);
    }

    @PostMapping
    public ResponseEntity<Project> createProject(@Valid @RequestBody Project project, UriComponentsBuilder a) {
        project = this.G.m_wz(project);
        Object[] objectArray = new Object[1];
        objectArray[0] = project.getId();
        return ResponseEntity.created((URI)a.path(c_kaa.m_cj((Object)"F\u0013\u0019\u001a\u0006\u0002\f\u000b\u001d!\r\u0015")).buildAndExpand(objectArray).toUri()).body((Object)project);
    }

    public ProjectController(c_kf a, c_dn a2, c_xg a3, c_hh a4) {
        ProjectController a5;
        ProjectController projectController = a5;
        super(a4, EnumSet.of(c_wk.i), a);
        a5.G = a;
        projectController.F = a2;
        projectController.G = a3;
    }

    @PostMapping(value={"/clone"})
    public ImportResult cloneProject(@Valid @RequestBody ProjectClone projectClone, @RequestParam(name="includeProjectAttachments", required=false) Boolean a) throws IOException {
        projectClone.setIncludeProjectAttachments(a);
        return this.G.m_zx(projectClone);
    }

    @DeleteMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteProject(@PathVariable(value="projectId") Integer a) {
        this.G.m_ia(a);
    }

    @GetMapping
    public Collection<Project> getProjects(@RequestParam(name="isActive", required=false) Boolean a) {
        if (a == null) {
            return this.G.m_va();
        }
        return this.G.m_tz(a);
    }

    @GetMapping(value={"/{projectId}"})
    public Project getProject(@PathVariable(value="projectId") Integer a) {
        return this.G.m_aa(a);
    }

    @GetMapping(value={"/name"}, params={"name"})
    public Project getProject(@RequestParam(name="name") String a) {
        return this.G.m_si(a);
    }

    @PutMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProject(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody Project a) {
        this.G.m_nz(projectId, a);
    }

    @PatchMapping(value={"/{projectId}/location"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProjectLocation(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody ProjectLocationDto a) {
        this.G.m_nt(projectId, a.getLatitude(), a.getLongitude());
    }
}

