/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.faceplate.restcontrollers;

import com.inscada.mono.communication.base.template.g.g.c_ve;
import com.inscada.mono.faceplate.g.c_jo;
import com.inscada.mono.faceplate.model.Faceplate;
import com.inscada.mono.faceplate.model.FaceplateElement;
import com.inscada.mono.faceplate.model.FaceplatePlaceholder;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.g.c_kf;
import com.inscada.mono.user.model.ResetPasswordToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/faceplates"})
public class FaceplateController
extends ProjectBasedImportExportController {
    private final c_jo G;

    @DeleteMapping(value={"/{faceplateId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElementsByIds(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(value="elementIds") Integer[] a) {
        this.G.m_tga(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/svg"})
    public ResponseEntity<InputStreamResource> getFaceplateSvg(@PathVariable(value="faceplateId") Integer a) {
        a = this.G.m_aa(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(ResetPasswordToken.m_cj((Object)"L*a1j+{hK,|5`6f1f*a"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)c_ve.m_cj((Object)"d\u001bl\u0011hY~\u0000j]u\u001ba"))).body((Object)byteArrayInputStream);
    }

    @GetMapping(value={"/{faceplateId}"})
    public Faceplate getFaceplate(@PathVariable(value="faceplateId") Integer a) {
        return this.G.m_aa(a);
    }

    @PutMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer placeholderId, @Valid @RequestBody FaceplatePlaceholder a) {
        this.G.m_baa(faceplateId, placeholderId, a);
    }

    @PostMapping
    public ResponseEntity<Faceplate> createFaceplate(@Valid @RequestBody Faceplate faceplate, UriComponentsBuilder a) {
        faceplate = this.G.m_wda(faceplate);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplate.getId();
        return ResponseEntity.created((URI)a.path(ResetPasswordToken.m_cj((Object)"jt#n&j5c${ F!r")).buildAndExpand(objectArray).toUri()).body((Object)faceplate);
    }

    @DeleteMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        this.G.m_uka(faceplateId, a);
    }

    @PostMapping(value={"/{faceplateId}/clone"}, params={"name"})
    public ResponseEntity<Faceplate> cloneFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        faceplateId = this.G.m_tfa(faceplateId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplateId.getId();
        return ResponseEntity.created((URI)a.path(c_ve.m_cj((Object)"Yv\u0010l\u0015h\u0006a\u0017y\u0013D\u0012p")).buildAndExpand(objectArray).toUri()).body((Object)faceplateId);
    }

    @GetMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    public FaceplatePlaceholder getFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        return this.G.m_mda(faceplateId, a);
    }

    public FaceplateController(c_jo a, c_hh a2, c_kf a3) {
        super(a2, EnumSet.of(c_wk.J), a3);
        FaceplateController a4;
        a4.G = a;
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Faceplate> getFaceplatesByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.G.m_yia(projectId, a);
    }

    @PostMapping(value={"/{faceplateId}/elements"})
    public ResponseEntity<FaceplateElement> createFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplateElement faceplateElement, UriComponentsBuilder a) {
        faceplateElement = this.G.m_via(faceplateId, faceplateElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplateElement.getId();
        return ResponseEntity.created((URI)a.path(ResetPasswordToken.m_cj((Object)" >i$l \u007f)n1j\fk8  c b a1|jt c b a1F!r")).buildAndExpand(objectArray).toUri()).body((Object)faceplateElement);
    }

    @PutMapping(value={"/{faceplateId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateSvg(@PathVariable(value="faceplateId") Integer faceplateId, @RequestBody String a) {
        this.G.m_uca(faceplateId, a);
    }

    @DeleteMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplate(@PathVariable(value="faceplateId") Integer a) {
        this.G.m_ia(a);
    }

    @GetMapping(value={"/{faceplateId}/elements"})
    public Collection<FaceplateElement> getFaceplateElements(@PathVariable(value="faceplateId") Integer a) {
        return this.G.m_fba(a);
    }

    @GetMapping(value={"/{faceplateId}/elements/{elementId}"})
    public FaceplateElement getFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        return this.G.m_kha(faceplateId, a);
    }

    @PutMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody FaceplateElement a) {
        this.G.m_nba(faceplateId, elementId, a);
    }

    @GetMapping
    public Collection<Faceplate> getFaceplates(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.G.m_va();
        }
        return this.G.m_da(a);
    }

    @PutMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody Faceplate a) {
        this.G.m_qja(faceplateId, a);
    }

    @DeleteMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        this.G.m_cla(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/placeholders"})
    public Collection<FaceplatePlaceholder> getFaceplatePlaceholders(@PathVariable(value="faceplateId") Integer a) {
        return this.G.m_ika(a);
    }

    @PostMapping(value={"/{faceplateId}/placeholders"})
    public ResponseEntity<FaceplatePlaceholder> createFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplatePlaceholder faceplatePlaceholder, UriComponentsBuilder a) {
        faceplatePlaceholder = this.G.m_wca(faceplateId, faceplatePlaceholder);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplatePlaceholder.getId();
        return ResponseEntity.created((URI)a.path(c_ve.m_cj((Object)"\"\rk\u0017n\u0013}\u001al\u0002h?i\u000b\"\u0006a\u0017n\u0013e\u0019a\u0012h\u0004~Yv\u0013a\u0013`\u0013c\u0002D\u0012p")).buildAndExpand(objectArray).toUri()).body((Object)faceplatePlaceholder);
    }
}

