/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.auth.c_kka;
import com.inscada.mono.cluster.g.c_xga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_t;
import com.inscada.mono.communication.base.enums.c_pda;
import com.inscada.mono.communication.base.enums.c_qha;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableIdentity;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_eda;
import com.inscada.mono.communication.base.services.c_hba;
import com.inscada.mono.communication.base.services.c_yca;
import com.inscada.mono.datatransfer.events.CancelEvent;
import com.inscada.mono.datatransfer.events.RescheduleEvent;
import com.inscada.mono.datatransfer.g.c_de;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.c_dg;
import com.inscada.mono.datatransfer.services.c_xe;
import com.inscada.mono.job.i.c_fl;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_al;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener {
    private final c_yca b;
    private final Map<Integer, Job> C;
    private final c_fl B;
    private static final String L = "scheduledDataTransfers";
    private final JedisPooled M;
    private final c_t J;
    public static final short m = 406;
    public static final short j = 405;
    public static final short f = 401;
    private static final Logger H = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short h = 403;
    private final c_hba c;
    private final c_eda A;
    public static final short i = 407;
    private final Lock d;
    public static final short k = 404;
    public static final short D = 402;
    private final c_ye F;
    private final c_dg G;

    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String a, DataTransfer a2) {
        DataTransferManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            H.info(VariableIdentity.m_cj((Object)"\f`<`\u001cs)o;g-s\u0005`&`/d:!`M-`,d:!3|a;hS-r<n:h&fhe)u)!<s)o;g-sr!3|h)\u0001Er!3|a"), objectArray);
            a3.scheduleDataTransferInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.F.m_lia(a2.getProject()).m_z("Data Transfer Restore (Leader " + a + ")", String.format(EvalAnimationMessage.m_cj((Object)"=V8\rQa\"\u0005=A1\u0005~DqI}A8Qw\u0005j@kQwW}\u000b8fyPk@\"\u0005=V"), objectArray));
            try {
                H.warn(VariableIdentity.m_cj((Object)"\f`<`\u001cs)o;g-s\u0005`&`/d:!`M-`,d:!3|a;h@<u-l8u!o/!<nhb)o+d$!,`<`hu:`&r.d:!3|h`.u-shs-r<n:`<h'ohg)h$t:df"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                H.error(EvalAnimationMessage.m_cj((Object)"\\DlDLWyKkC}WUDvD\u007f@j\u00050i}D|@j\u0005cX1\u001f8cyLt@|\u0005lJ8FyK{@t\u0005|DlD8QjDvV~@j\u0005cX8D~Q}W8W}VlJjDlLwK8CyLtPj@\"\u0005cX"), objectArray2);
                return;
            }
        }
    }

    public DataTransferManager(c_dg a, c_hba a2, c_eda a3, c_yca a4, c_fl a5, JedisPooled a6, c_ye a7, c_t a8) {
        DataTransferManager a9;
        DataTransferManager dataTransferManager = a9;
        DataTransferManager dataTransferManager2 = a9;
        DataTransferManager dataTransferManager3 = a9;
        DataTransferManager dataTransferManager4 = a9;
        DataTransferManager dataTransferManager5 = a9;
        a9.d = new ReentrantLock();
        dataTransferManager5.C = new ConcurrentHashMap();
        dataTransferManager4.G = a;
        dataTransferManager4.c = a2;
        dataTransferManager3.A = a3;
        dataTransferManager3.b = a4;
        dataTransferManager2.B = a5;
        dataTransferManager2.F = a7;
        dataTransferManager.M = a6;
        dataTransferManager.J = a8;
    }

    protected c_de getDataTransferStatusInternal(Integer a) {
        DataTransferManager a2;
        if (a2.C.containsKey(a)) {
            return c_de.D;
        }
        return c_de.F;
    }

    private /* synthetic */ void lambda$handleStatValues$17(Date a, Map a2, Map a3, Map a4, Date a5, List a6) {
        DataTransferManager a7;
        Integer[] integerArray = (Integer[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(Integer[]::new);
        c_qha[] c_qhaArray = (c_qha[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_qha[]::new);
        a = a7.b.m_lob(integerArray, a5, (Date)a, c_qhaArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableIdAsInt, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16((Map)a, a2, a3, a4, arg_0));
    }

    protected void scheduleDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_kka.m_vbc(() -> {
            DataTransferManager a2;
            a2.d.lock();
            try {
                a2.cancelDataTransferInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_al("Project should be active to schedule data transfer " + a.getName());
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = a.getName();
                PeriodicJob periodicJob = a2.B.m_naa(a.getProject(), String.format(EvalAnimationMessage.m_cj((Object)"=V8ayQy\u0005LWyKkC}W"), objectArray), () -> {
                    DataTransferManager a2;
                    a2.transfer(a);
                }, Duration.ofMillis(a.getPeriod().intValue()));
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.C.put(a.getId(), periodicJob);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.M.sadd(L, stringArray);
                return;
            }
            finally {
                a2.d.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            H.info(VariableIdentity.m_cj((Object)"\u0004D\tE\rSr!\u0000`&e$h&fhB)o+d$D>d&uhg'she)u)!<s)o;g-sr!3|h)\u0001Er!3|a"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            a2.cancelDataTransferInternal(dataTransfer);
            return;
        }
        H.debug(EvalAnimationMessage.m_cj((Object)"VjV\bT`Ya]w\"\u0005QBvJjLvB8fyK{@t`n@vQ8CwW8AyQy\u0005lWyKkC}W\"\u0005cX"), (Object)a.getDataTransfer().getId());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            H.debug(VariableIdentity.m_cj((Object)"\u0004D\tE\rSr!\u000b`&b-m$h&fh`$mhe)u)!<s)o;g-s;!.n:!8s'k-b<!3|hm'b)m$xf"), (Object)a);
            a2.cancelDataTransfersByProjectIdInternal(a);
            return;
        }
        H.debug(EvalAnimationMessage.m_cj((Object)"VjV\bT`Ya]w\"\u0005J@iP}VlLvB8I}D|@j\u0005lJ8FyK{@t\u0005yIt\u0005|DlD8QjDvV~@jV8CwW8UjJr@{Q8^e\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)405), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC cancel data transfers for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, VariableValue<?> a2, VariableValue<?> a3) {
        double d;
        double d2;
        if (a == null || a3 == null) {
            return true;
        }
        if (!(a2 instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d3 = ((Number)a2.getValue()).doubleValue();
        double d4 = ((Number)a3.getValue()).doubleValue();
        return (d3 == 0.0 ? (d2 = Math.abs(d4 - d3)) : (d = Math.abs((d4 - d3) / d3 * 100.0))) >= a;
    }

    protected Map<Integer, c_de> getDataTransferStatusesByIdsInternal(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    public void notLeader() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        String string = dataTransferManager.J.m_wa().getNodeId();
        H.info(VariableIdentity.m_cj((Object)"\f`<`\u001cs)o;g-s\u0005`&`/d:;hU h;!&n,dh)3|a!!rhO\u0007!\u0004N\u0006F\rShU\u0000DhM\r@\fD\u001a/hB)o+d$m!o/!)m$!$n+`$!,`<`hu:`&r.d:!\"n*rf/f"), (Object)string);
        dataTransferManager.d.lock();
        try {
            new ArrayList(a.C.keySet()).forEach(a2 -> {
                DataTransferManager a3;
                Job job = (Job)a3.C.get(a2);
                if (job != null) {
                    try {
                        H.info(VariableIdentity.m_cj((Object)"E)u)U:`&r.d:L)o)f-sh)\u0006n<!\u0004d)e-shz5(r!\u000b`&b-m$h&fhm'b)mhk'chg'she)u)!<s)o;g-shH\f;hz5"), (Object)string, a2);
                        a3.B.m_pca(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        H.error(EvalAnimationMessage.m_cj((Object)"ayQyqjDvV~@jhyKyB}W8\rVJl\u0005T@yA}W8^e\f\"\u0005]WjJj\u0005{DvF}ItLvB8IwFyI8OwG8CwW8AyQy\u0005lWyKkC}W8l\\\u0005cX\"\u0005cX"), objectArray);
                    }
                }
            });
            a.C.clear();
            H.info(EvalAnimationMessage.m_cj((Object)"\\DlDLWyKkC}WUDvD\u007f@j\u00050kwQ8i}D|@j\u0005cX1\u001f8dtI8IwFyI8AyQy\u0005lWyKkC}W8OwGk\u0005pDn@8G}@v\u0005j@iP}Vl@|\u0005lJ8FyK{@t\u0005yK|\u0005{I}Dj@|\u0005~WwH8IwFyI8QjD{NqK\u007f\u000b"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            H.error(VariableIdentity.m_cj((Object)"E)u)U:`&r.d:L)o)f-sh)\u0006n<!\u0004d)e-shz5(r!\rs:n:!,t:h&fhq:n+d;rhn.!+`&b-m$h&fhm'b)mhe)u)!<s)o;g-shk'c;;hz5"), objectArray);
            return;
        }
        finally {
            a.d.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail a, Date a2, String a3) {
        Date date;
        int n;
        boolean bl;
        DataTransferManager a4;
        if (a3 == null) {
            return true;
        }
        a3 = Calendar.getInstance();
        String string = a4.M.get(a4.buildStatLastCalcTimeKey(a));
        if (string == null) {
            return true;
        }
        ((Calendar)a3).setTimeInMillis(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(a2);
        boolean bl2 = false;
        switch (c_xe.F[a.getRangeType().ordinal()]) {
            case 1: 
            case 2: {
                bl = bl2 = ((Calendar)a3).get(11) != calendar.get(11);
                break;
            }
            case 3: 
            case 4: {
                bl = bl2 = ((Calendar)a3).get(6) != calendar.get(6);
                break;
            }
            case 5: 
            case 6: {
                bl = bl2 = ((Calendar)a3).get(3) != calendar.get(3);
                break;
            }
            case 7: 
            case 8: {
                bl = bl2 = ((Calendar)a3).get(2) != calendar.get(2);
                break;
            }
            case 9: 
            case 10: {
                bl2 = ((Calendar)a3).get(1) != calendar.get(1);
            }
            default: {
                bl = bl2;
            }
        }
        if (bl) {
            DataTransferManager dataTransferManager = a4;
            String string2 = dataTransferManager.buildStatCacheKey(a);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey(a);
            String[] stringArray = new String[2];
            stringArray[0] = string2;
            stringArray[1] = string3;
            dataTransferManager.M.del(stringArray);
            return true;
        }
        if (!a.getRangeType().toString().startsWith(EvalAnimationMessage.m_cj((Object)"fmWj@vQ"))) {
            return false;
        }
        switch (c_xe.F[a.getRangeType().ordinal()]) {
            case 1: {
                n = 5;
                date = a2;
                break;
            }
            case 3: {
                n = 5;
                date = a2;
                break;
            }
            case 5: {
                n = 60;
                date = a2;
                break;
            }
            case 7: {
                n = 720;
                date = a2;
                break;
            }
            case 9: {
                n = 720;
                date = a2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected range type: " + a.getRangeType());
            }
        }
        long l = date.getTime();
        long l2 = Long.parseLong(string);
        return l - l2 >= (long)(n * 60 * 1000);
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(VariableIdentity.m_cj((Object)"e)u),<s)o;g-srm)r<,+`$beu!l-;>`:h)c$dr$,;mrr$;"), objectArray);
    }

    private /* synthetic */ void lambda$handleStatValues$16(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        if ((a = (LoggedVariableValueStats)a.get(a5.getSourceVariableId())) != null && (a2 = (Variable)a2.get(a5.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = a6.extractValue((LoggedVariableValueStats)a, a5.getCalcType());
            a = (VariableValue)a3.get(a5.getTargetVariableId());
            DataTransferManager dataTransferManager = a6;
            a3 = dataTransferManager.buildStatCacheKey(a5);
            String string = dataTransferManager.buildStatLastCalcTimeKey(a5);
            int n = dataTransferManager.getMaxTTLForRangeType(a5.getRangeType());
            dataTransferManager.M.setex((String)a3, (long)n, String.valueOf(d));
            a6.M.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager.isValueInThresholdRange(a5.getThreshold(), Double.valueOf(d), (VariableValue)a)) {
                a = new HashMap<String, Double>();
                a.put(EvalAnimationMessage.m_cj((Object)"SyIm@"), d);
                a4.put(a2.getName(), a);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats a, c_qha a2) {
        switch (c_xe.G[a2.ordinal()]) {
            case 1: {
                return a.getMinValue();
            }
            case 2: {
                return a.getMaxValue();
            }
            case 3: {
                return a.getAvgValue();
            }
            case 4: {
                return a.getSumValue();
            }
            case 5: {
                return a.getCountValue();
            }
            case 6: {
                return a.getFirstValue();
            }
            case 7: {
                return a.getLastValue();
            }
            case 8: {
                return a.getMaxDiffValue();
            }
            case 9: {
                return a.getLastFirstDiffValue();
            }
            case 10: {
                return a.getMiddleValue();
            }
            case 11: {
                return a.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + a2);
    }

    private /* synthetic */ void lambda$handleCurrentValues$10(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        a = (VariableValue)a.get(a5.getSourceVariableId());
        a2 = (VariableValue)a2.get(a5.getTargetVariableId());
        a3 = (Variable)a3.get(a5.getTargetVariableId());
        if (a != null && a3 != null && a6.isValueInThresholdRange(a5.getThreshold(), (VariableValue)a, (VariableValue)a2)) {
            a2 = new HashMap<String, Object>();
            a2.put(VariableIdentity.m_cj((Object)">`$t-"), a.getValue());
            a4.put(a3.getName(), a2);
        }
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, Double a2, VariableValue<?> a3) {
        DataTransferManager a4;
        return a4.isValueInThresholdRange(a, (VariableValue)new NumberVariableValue((Number)a2, new Date()), a3);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            H.debug(EvalAnimationMessage.m_cj((Object)"i]d\\`J\u001f8v{M}AmIqK\u007f\u0005yIt\u0005|DlD8QjDvV~@jV8CwW8UjJr@{Q8^e\u0005tJ{DtIa\u000b"), (Object)a);
            a2.scheduleDataTransfersByProjectIdInternal(a);
            return;
        }
        H.debug(VariableIdentity.m_cj((Object)"O\u0007OeM\r@\fD\u001a;hS-p=d;u!o/!$d)e-shu'!;b d,t$dh`$mhe)u)!<s)o;g-s;!.n:!8s'k-b<!3|f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)404), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC schedule data transfers for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_de> getDataTransferStatuses(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.J.m_rb()) {
            H.debug(EvalAnimationMessage.m_cj((Object)"i]d\\`J\u001f8b}QlLvB8AyQy\u0005lWyKkC}W8VlDlPk@k\u0005~Jj\u0005cX8l\\V8IwFyIt\\\"\u0005cX"), (Object)a.size(), a);
            return a2.getDataTransferStatusesByIdsInternal(a);
        }
        H.debug(VariableIdentity.m_cj((Object)"\u0006N\u0006,\u0004D\tE\rSr!\u001ad9t-r<h&fhm-`,d:!.n:!,`<`hu:`&r.d:!;u)u=r-rhg'shz5!\u0001E;;hz5"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.J.m_ib(Short.valueOf((short)406), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(EvalAnimationMessage.m_cj((Object)"\t"))), (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_pda a) {
        switch (c_xe.F[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.G.m_rh(a, a2).getId());
    }

    private /* synthetic */ boolean lambda$handleStatValues$12(Date a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        DataTransferManager dataTransferManager = a6;
        String string = dataTransferManager.buildStatCacheKey(a5);
        if (!dataTransferManager.shouldRecalculateStats(a5, a, string = dataTransferManager.M.get(string))) {
            a6.updateVariableWithCachedValue(string, a5, a2, a3, a4);
            return false;
        }
        return true;
    }

    protected void scheduleDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.G.m_zka(a));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            H.debug(VariableIdentity.m_cj((Object)"M\r@\fD\u001a;hR+i-e=m!o/!,`<`hu:`&r.d:!3|hm'b)m$xf"), (Object)a);
            a2.scheduleDataTransferInternal(a);
            return;
        }
        H.debug(EvalAnimationMessage.m_cj((Object)"kWk5i]d\\`J\u001f8w}Tm@kQqK\u007f\u0005t@yA}W8Qw\u0005kFp@|Pt@8AyQy\u0005lWyKkC}W8^e\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)401), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC schedule data transfer " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void transfer(DataTransfer a) {
        DataTransferManager a2;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(a3 -> {
            if (a3.getCalcType() != null && a3.getRangeType() != null) {
                arrayList2.add(a3);
                return;
            }
            arrayList.add(a3);
        });
        HashMap hashMap = new HashMap();
        if (!arrayList.isEmpty()) {
            a2.handleCurrentValues(arrayList, hashMap);
        }
        if (!arrayList2.isEmpty()) {
            a2.handleStatValues(arrayList2, hashMap);
        }
        if (!hashMap.isEmpty()) {
            a2.A.m_gsb(a.getProjectId(), hashMap);
        }
    }

    protected void cancelDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_kka.m_vbc(() -> {
            DataTransferManager a2;
            a2.d.lock();
            try {
                Job job = (Job)a2.C.get(a.getId());
                if (job != null) {
                    a2.B.m_pca(job);
                }
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.C.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.M.srem(L, stringArray);
                return;
            }
            finally {
                a2.d.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(VariableIdentity.m_cj((Object)",`<`eu:`&r.d:;;u)u;;>`:h)c$dr$,;mrr$;"), objectArray);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.cancelDataTransfer(dataTransferManager.G.m_rh(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_de getDataTransferStatus(Integer a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            H.debug(EvalAnimationMessage.m_cj((Object)"T`Ya]w\"\u0005_@lQqK\u007f\u0005|DlD8QjDvV~@j\u0005kQyQmV8CwW8l\\\u001f8^e\u0005tJ{DtIa\u000b"), (Object)a);
            return a2.getDataTransferStatusInternal(a);
        }
        H.debug(VariableIdentity.m_cj((Object)"O\u0007OeM\r@\fD\u001a;hS-p=d;u!o/!$d)e-shg'she)u)!<s)o;g-shr<`<t;!.n:!\u0001Er!3|f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_de)a2.J.m_ib(Short.valueOf((short)403), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get data transfer status for " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            H.info(EvalAnimationMessage.m_cj((Object)"i]d\\`J\u001f8myK|IqK\u007f\u0005J@kFp@|Pt@]S}Kl\u0005~Jj\u0005|DlD8QjDvV~@j\u001f8^e\u00050l\\\u001f8^e\f"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            if (a2.getDataTransferStatusInternal(dataTransfer.getId()) == c_de.D) {
                a2.scheduleDataTransferInternal(dataTransfer.getId());
                return;
            }
        } else {
            H.debug(VariableIdentity.m_cj((Object)"O\u0007OeM\r@\fD\u001a;hH/o's!o/!\u001ad;b d,t$d\rw-o<!.n:!,`<`hu:`&r.d:;hz5"), (Object)a.getDataTransfer().getId());
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            DataTransferManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.J.m_qb((short)401, (Object)a, DataTransferManager.class.getDeclaredMethod(EvalAnimationMessage.m_cj((Object)"kFp@|Pt@\\DlDLWyKkC}WQKl@jKyI"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.J.m_qb((short)402, (Object)a, DataTransferManager.class.getDeclaredMethod(VariableIdentity.m_cj((Object)"b)o+d$E)u)U:`&r.d:H&u-s&`$"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.J.m_qb((short)403, (Object)a, DataTransferManager.class.getDeclaredMethod(EvalAnimationMessage.m_cj((Object)"B}Q\\DlDLWyKkC}WKQyQmVQKl@jKyI"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.J.m_qb((short)404, (Object)a, DataTransferManager.class.getDeclaredMethod(VariableIdentity.m_cj((Object)"r+i-e=m-E)u)U:`&r.d:r\nx\u0018s'k-b<H,H&u-s&`$"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.J.m_qb((short)405, (Object)a, DataTransferManager.class.getDeclaredMethod(EvalAnimationMessage.m_cj((Object)"{DvF}I\\DlDLWyKkC}WkgaujJr@{QQAQKl@jKyI"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.J.m_qb((short)406, (Object)a, DataTransferManager.class.getDeclaredMethod(VariableIdentity.m_cj((Object)"f-u\f`<`\u001cs)o;g-s\u001bu)u=r-r\nx\u0001e;H&u-s&`$"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.J.m_qb((short)407, (Object)a, DataTransferManager.class.getDeclaredMethod(EvalAnimationMessage.m_cj((Object)"\u007f@layQyqjDvV~@jvlDlPk@kgaujJr@{QQAQKl@jKyI"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(VariableIdentity.m_cj((Object)"G)h$d,!<nhs-f!r<d:!\f`<`\u001cs)o;g-s\u0005`&`/d:!\u001aQ\u000b!%d<i'e;"), noSuchMethodException);
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.G.m_da((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_de getDataTransferStatus(Integer a, String a2) {
        DataTransferManager a3;
        if ((a = a3.G.m_af(a, a2)) == null) {
            return c_de.F;
        }
        return a3.getDataTransferStatus(a.getId());
    }

    protected Map<Integer, c_de> getDataTransferStatusesByProjectIdInternal(Integer a2) {
        DataTransferManager a3;
        if ((a2 = a3.G.m_da((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(DataTransfer::getId, a -> {
            DataTransferManager a2;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    protected void cancelDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.G.m_lj(a));
    }

    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a2) {
        DataTransferManager a3;
        Object object = (Integer[])a.stream().map(DataTransferDetail::getSourceVariableId).toArray(Integer[]::new);
        Object object2 = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a3.c.m_xma(object2).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        DataTransferManager dataTransferManager = a3;
        object = dataTransferManager.A.m_rob(object);
        object2 = dataTransferManager.A.m_rob((Integer[])object2.toArray(Integer[]::new));
        a.forEach(arg_0 -> a3.lambda$handleCurrentValues$10((Map)object, (Map)object2, map, a2, arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_de> getDataTransferStatuses(Integer a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            H.debug(VariableIdentity.m_cj((Object)"M\r@\fD\u001a;hF-u<h&fh`$mhe)u)!<s)o;g-shr<`<t;d;!.n:!8s'k-b<!3|hm'b)m$xf"), (Object)a);
            return a2.getDataTransferStatusesByProjectIdInternal(a);
        }
        H.debug(EvalAnimationMessage.m_cj((Object)"VjV\bT`Ya]w\"\u0005J@iP}VlLvB8I}D|@j\u0005~Jj\u0005yIt\u0005|DlD8QjDvV~@j\u0005kQyQmV}V8CwW8UjJr@{Q8^e\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.J.m_ib(Short.valueOf((short)407), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            Integer n = a.getProject().getId();
            H.info(VariableIdentity.m_cj((Object)"M\r@\fD\u001a;hI)o,m!o/!\u0018s'k-b<E-`+u!w)u-D>d&uhg'shq:n\"d+uhH\f;hz5"), (Object)n);
            a2.cancelDataTransfersByProjectIdInternal(n);
            return;
        }
        H.debug(EvalAnimationMessage.m_cj((Object)"VjV\bT`Ya]w\"\u0005QBvJjLvB8ujJr@{Q\\@yFlLnDl@]S}Kl\u0005~Jj\u0005hWwO}Fl\u0005Qa\"\u0005cX"), (Object)a.getProject().getId());
    }

    protected void scheduleDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.G.m_wha((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date a, c_pda a2) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        calendar.setTime(a);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Calendar calendar3 = (Calendar)calendar2.clone();
        switch (c_xe.F[a2.ordinal()]) {
            case 1: {
                Calendar calendar4 = calendar;
                while (false) {
                }
                calendar4.set(12, 0);
                return Pair.of((Object)calendar4.getTime(), (Object)a);
            }
            case 2: {
                calendar3.add(11, -1);
                Calendar calendar5 = calendar;
                calendar5.add(11, -2);
                calendar5.set(12, 0);
                return Pair.of((Object)calendar5.getTime(), (Object)calendar3.getTime());
            }
            case 3: {
                Calendar calendar6 = calendar;
                calendar6.set(11, 0);
                calendar6.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 4: {
                calendar3.add(5, -1);
                Calendar calendar7 = calendar;
                calendar.add(5, -2);
                calendar7.set(11, 0);
                calendar7.set(12, 0);
                return Pair.of((Object)calendar7.getTime(), (Object)calendar3.getTime());
            }
            case 5: {
                Calendar calendar8 = calendar;
                Calendar calendar9 = calendar;
                calendar9.set(7, calendar9.getFirstDayOfWeek());
                calendar8.set(11, 0);
                calendar8.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 6: {
                calendar3.add(3, -1);
                Calendar calendar10 = calendar;
                calendar.add(3, -2);
                Calendar calendar11 = calendar;
                calendar11.set(7, calendar11.getFirstDayOfWeek());
                calendar10.set(11, 0);
                calendar10.set(12, 0);
                return Pair.of((Object)calendar10.getTime(), (Object)calendar3.getTime());
            }
            case 7: {
                Calendar calendar12 = calendar;
                calendar.set(5, 1);
                calendar12.set(11, 0);
                calendar12.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 8: {
                calendar3.add(2, -1);
                Calendar calendar13 = calendar;
                Calendar calendar14 = calendar;
                calendar14.add(2, -2);
                calendar14.set(5, 1);
                calendar13.set(11, 0);
                calendar13.set(12, 0);
                return Pair.of((Object)calendar13.getTime(), (Object)calendar3.getTime());
            }
            case 9: {
                Calendar calendar15 = calendar;
                calendar.set(6, 1);
                calendar15.set(11, 0);
                calendar15.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 10: {
                calendar3.add(1, -1);
                Calendar calendar16 = calendar;
                Calendar calendar17 = calendar;
                calendar17.add(1, -2);
                calendar17.set(6, 1);
                calendar16.set(11, 0);
                calendar16.set(12, 0);
                return Pair.of((Object)calendar16.getTime(), (Object)calendar3.getTime());
            }
        }
        throw new IllegalArgumentException(VariableIdentity.m_cj((Object)"\u001do-y8d+u-ehs)o/dhu1q-"));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.J.m_rb()) {
            H.debug(EvalAnimationMessage.m_cj((Object)"T`Ya]w\"\u0005[DvF}ItLvB8AyQy\u0005lWyKkC}W8^e\u0005tJ{DtIa\u000b"), (Object)a);
            a2.cancelDataTransferInternal(a);
            return;
        }
        H.debug(VariableIdentity.m_cj((Object)"\u0006N\u0006,\u0004D\tE\rSr!\u001ad9t-r<h&fhm-`,d:!<nhb)o+d$!,`<`hu:`&r.d:!3|f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)402), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC cancel data transfer " + a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.J.m_sa((ClusterNodeListener)a);
        H.info(EvalAnimationMessage.m_cj((Object)"\\DlDLWyKkC}WUDvD\u007f@j\u0005qKqQqDtLb@|\u0005yK|\u0005j@\u007fLkQ}W}A8Dk\u0005[ImVl@jkwA}iqVl@v@j\u000b"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        String string = dataTransferManager.J.m_wa().getNodeId();
        H.info(VariableIdentity.m_cj((Object)"E)u)U:`&r.d:L)o)f-sr!\u001ci!rho'e-!`z5(hi)rhc-b'l-!<i-!\u0004D\tE\rSf!\u001ad;u's!o/!;b d,t$d,!,`<`hu:`&r.d:rf/f"), (Object)string);
        dataTransferManager.d.lock();
        try {
            Set set = a2.M.smembers(L).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                H.info(EvalAnimationMessage.m_cj((Object)"ayQyqjDvV~@jhyKyB}W8\rT@yA}W8^e\f\"\u0005VJ8V{M}AmI}A8AyQy\u0005lWyKkC}Wk\u0005~JmK|\u0005qK8w}AqV8Qw\u0005j@kQwW}\u000b"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            H.info(VariableIdentity.m_cj((Object)"\f`<`\u001cs)o;g-s\u0005`&`/d:!`M-`,d:!3|a;hG't&ehz5!;b d,t$d,!,`<`hu:`&r.d:!\u0001E;!!ohS-e!rhu'!:d;u's-;hz5"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = EvalAnimationMessage.m_cj((Object)"Nl]rGaYqYzLwYkKc]w");
            c_kka.m_rub(() -> {
                DataTransferManager a3;
                arrayList.addAll(a3.G.m_ija(set));
            }, (String[])stringArray);
            H.info(VariableIdentity.m_cj((Object)"\f`<`\u001cs)o;g-s\u0005`&`/d:!`M-`,d:!3|a;h@<u-l8u!o/!<nhs-r<n:dhz5!,`<`hu:`&r.d:rf"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                DataTransferManager a2;
                DataTransferManager dataTransferManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = VariableIdentity.m_cj((Object)"R\u000bI\rE\u001dM\r^\f@\u001c@\u0017U\u001a@\u0006R\u000eD\u001a");
                stringArray[1] = EvalAnimationMessage.m_cj((Object)"[dVf]iGaYqYzLwYkKc]w");
                c_kka.m_lub(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1(dataTransferManager.J.m_wa().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            H.info(EvalAnimationMessage.m_cj((Object)"\\DlDLWyKkC}WUDvD\u007f@j\u00050i}D|@j\u0005cX1\u001f8cqKqVp@|\u0005|DlD8QjDvV~@j\u0005j@kQwWyQqJv\u0005hWwF}Vk\u000b"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            H.error(VariableIdentity.m_cj((Object)"\f`<`\u001cs)o;g-s\u0005`&`/d:!`M-`,d:!3|a;hD:s'she=s!o/!,`<`hu:`&r.d:!:d;u's)u!n&!8s'b-r;;hz5"), objectArray);
            return;
        }
        finally {
            a2.d.unlock();
        }
    }

    private /* synthetic */ void updateVariableWithCachedValue(String a, DataTransferDetail a2, Map<Integer, Variable<?, ?, ?>> a3, Map<String, Map<String, Object>> a4, Map<Integer, VariableValue<?>> a5) {
        if ((a3 = a3.get(a2.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = Double.parseDouble((String)a);
            a = a5.get(a2.getTargetVariableId());
            if (a6.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), a)) {
                a = new HashMap<String, Double>();
                a.put(EvalAnimationMessage.m_cj((Object)"SyIm@"), d);
                a4.put(a3.getName(), (Map<String, Object>)a);
            }
        }
    }

    private /* synthetic */ void handleStatValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a3) {
        DataTransferManager a4;
        Object object = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a4.c.m_xma(object).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = a4.A.m_rob((Integer[])object.toArray(Integer[]::new));
        Date date = new Date();
        a.stream().filter(arg_0 -> a4.lambda$handleStatValues$12(date, map, a3, (Map)object, arg_0)).collect(Collectors.groupingBy(a2 -> {
            DataTransferManager a3;
            return (Date)a3.calculateDateRange(date, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> a4.lambda$handleStatValues$17(date, map, (Map)object, a3, arg_0, arg_1));
    }
}

