/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.restcontrollers;

import com.inscada.mono.communication.protocols.opcda.model.Leaf;
import com.inscada.mono.datatransfer.g.c_de;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.DataTransferManager;
import com.inscada.mono.datatransfer.services.c_dg;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.job.g.c_ql;
import com.inscada.mono.project.g.c_kf;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/datatransfer"})
public class DataTransferController
extends ProjectBasedImportExportController {
    private final c_dg F;
    private final DataTransferManager G;

    @PutMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer detailId, @Valid @RequestBody DataTransferDetail a) {
        this.F.m_jba(dataTransferId, detailId, a);
    }

    @PostMapping
    public ResponseEntity<DataTransfer> createDataTransfer(@Valid @RequestBody DataTransfer dataTransfer, UriComponentsBuilder a) {
        dataTransfer = this.F.m_xha(dataTransfer);
        Object[] objectArray = new Object[1];
        objectArray[0] = dataTransfer.getId();
        return ResponseEntity.created((URI)a.path(Leaf.m_cj((Object)"[a\u0010{\u0000{ h\u0015t\u0007|\u0011h=~\t")).buildAndExpand(objectArray).toUri()).body((Object)dataTransfer);
    }

    @DeleteMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        this.F.m_ia(a);
    }

    @DeleteMapping(value={"/details"}, params={"dataTransferDetailIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransferDetailsByIds(@RequestParam(value="dataTransferDetailIds") Integer[] a) {
        this.F.m_dga(List.of(a));
    }

    public DataTransferController(c_dg a, DataTransferManager a2, c_hh a3, c_kf a4) {
        DataTransferController a5;
        DataTransferController dataTransferController = a5;
        super(a3, EnumSet.of(c_wk.j), a4);
        dataTransferController.F = a;
        dataTransferController.G = a2;
    }

    @GetMapping(value={"/{dataTransferId}/status"})
    public c_de getDataTransferStatus(@PathVariable(value="dataTransferId") Integer a) {
        return this.G.getDataTransferStatus(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.G.scheduleDataTransfers(a);
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_de> getDataTransferStatuses(@RequestParam(value="dataTransferIds") Integer[] a) {
        return this.G.getDataTransferStatuses(Arrays.asList(a));
    }

    @GetMapping(value={"/{dataTransferId}"})
    public DataTransfer getDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        return this.F.m_aa(a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.G.cancelDataTransfers(a);
    }

    @PostMapping(value={"/{dataTransferId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="dataTransferId") Integer a) {
        this.G.scheduleDataTransfer(a);
    }

    @DeleteMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        this.F.m_hga(dataTransferId, a);
    }

    @GetMapping(value={"/{dataTransferId}/details/{detailId}"})
    public DataTransferDetail getDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        return this.F.m_xca(dataTransferId, a);
    }

    @GetMapping
    public Collection<DataTransfer> getDataTransfers(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.F.m_va();
        }
        return this.F.m_da(a);
    }

    @PostMapping(value={"/{dataTransferId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="dataTransferId") Integer a) {
        this.G.cancelDataTransfer(a);
    }

    @PutMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDataTransfer(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransfer a) {
        this.F.m_haa(dataTransferId, a);
    }

    @GetMapping(value={"/{dataTransferId}/details"})
    public Collection<DataTransferDetail> getDetails(@PathVariable(value="dataTransferId") Integer a) {
        return this.F.m_sba(a);
    }

    @PostMapping(value={"/{dataTransferId}/details"})
    public ResponseEntity<DataTransferDetail> createDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransferDetail dataTransferDetail, UriComponentsBuilder a) {
        dataTransferDetail = this.F.m_fja(dataTransferId, dataTransferDetail);
        Object[] objectArray = new Object[2];
        objectArray[0] = dataTransferId;
        objectArray[1] = dataTransferDetail.getId();
        return ResponseEntity.created((URI)a.path(c_ql.m_cj((Object)"\u0010j[pKpkc^\u007fLwZcvuB>[tKpV}L>DuZe^xSX[l")).buildAndExpand(objectArray).toUri()).body((Object)dataTransferDetail);
    }

    @DeleteMapping(value={""}, params={"dataTransferIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfersByIds(@RequestParam(value="dataTransferIds") Integer[] a) {
        this.F.m_yda(List.of(a));
    }
}

