/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="data_transfer")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class DataTransfer
extends OwnedSpaceBaseModel {
    @JsonIgnore
    @OneToMany(mappedBy="dataTransfer", orphanRemoval=true)
    private Set<DataTransferDetail> dataTransferDetails;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @NotBlank
    @Size(max=100)
    private String name;
    @NotNull
    @Min(value=1000L)
    private Integer period;
    @Size(max=255)
    private String dsc;
    @Id
    @Column(name="data_transfer_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="dataTransferSeq")
    @GenericGenerator(name="dataTransferSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="data_transfer_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;

    public DataTransfer() {
        DataTransfer a;
        DataTransfer dataTransfer = a;
        dataTransfer.dataTransferDetails = new HashSet();
    }

    public int hashCode() {
        DataTransfer a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void removeDetail(Integer a) {
        DataTransfer a3;
        a3.dataTransferDetails.removeIf(a2 -> a2.getId().equals(a));
    }

    public Integer getPeriod() {
        DataTransfer a;
        return a.period;
    }

    public Integer getProjectId() {
        DataTransfer a;
        return a.projectId;
    }

    public boolean equals(Object a) {
        DataTransfer a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof DataTransfer)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (DataTransfer)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public Project getProject() {
        DataTransfer a;
        return a.project;
    }

    public String getName() {
        DataTransfer a;
        return a.name;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public Integer getId() {
        DataTransfer a;
        return a.id;
    }

    public String getDsc() {
        DataTransfer a;
        return a.dsc;
    }

    public void setProject(Project a) {
        DataTransfer a2;
        DataTransfer dataTransfer = a2;
        dataTransfer.project = a;
        dataTransfer.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void addDetail(DataTransferDetail a) {
        DataTransfer a2;
        DataTransfer dataTransfer = a2;
        a.setDataTransfer(dataTransfer);
        dataTransfer.dataTransferDetails.add(a);
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setPeriod(Integer a) {
        a.period = a;
    }

    public void setDataTransferDetails(Set<DataTransferDetail> a) {
        a.dataTransferDetails = a;
    }

    public Set<DataTransferDetail> getDataTransferDetails() {
        DataTransfer a;
        return a.dataTransferDetails;
    }
}

