/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.c_bja;
import com.inscada.mono.config.BrokerProperties;
import com.inscada.mono.config.ListenerBrokerProperties;
import com.inscada.mono.script.services.c_vh;
import com.inscada.mono.shared.interfaces.Listener;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ListenerBrokerProperties.class})
@ConditionalOnProperty(value={"spring.remote.broker.enabled"}, havingValue="true")
@EnableJms
public class ListenerBrokerConfig
implements JmsListenerConfigurer {
    private final String nodeId;
    private final ListenerBrokerProperties brokerProperties;
    private final JmsProperties jmsProperties;
    private final List<Listener<?>> listenerList;
    private final ObjectMapper objectMapper;

    @Bean(destroyMethod="stop")
    JmsListenerEndpointRegistry jmsListenerEndpointRegistry() {
        return new JmsListenerEndpointRegistry();
    }

    @Bean
    public MessageConverter jacksonReceiveJmsMessageConverter() {
        ListenerBrokerConfig a;
        MappingJackson2MessageConverter mappingJackson2MessageConverter;
        MappingJackson2MessageConverter mappingJackson2MessageConverter2 = mappingJackson2MessageConverter = new MappingJackson2MessageConverter();
        mappingJackson2MessageConverter.setObjectMapper(a.objectMapper);
        mappingJackson2MessageConverter2.setTargetType(MessageType.TEXT);
        mappingJackson2MessageConverter2.setTypeIdPropertyName(c_bja.m_cj((Object)"$8\u0002<\u001e"));
        return mappingJackson2MessageConverter2;
    }

    public ListenerBrokerConfig(List<Listener<?>> listenerList, ObjectMapper objectMapper, JmsProperties jmsProperties, ListenerBrokerProperties brokerProperties, @Value(value="${ins.node.id}") String a) {
        ListenerBrokerConfig listenerBrokerConfig = this;
        ListenerBrokerConfig listenerBrokerConfig2 = this;
        this.listenerList = listenerList;
        listenerBrokerConfig2.objectMapper = objectMapper;
        listenerBrokerConfig2.jmsProperties = jmsProperties;
        listenerBrokerConfig.brokerProperties = brokerProperties;
        listenerBrokerConfig.nodeId = a;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar a) {
        ListenerBrokerConfig a2;
        JmsListenerEndpointRegistrar jmsListenerEndpointRegistrar = a;
        ListenerBrokerConfig listenerBrokerConfig = a2;
        jmsListenerEndpointRegistrar.setEndpointRegistry(listenerBrokerConfig.jmsListenerEndpointRegistry());
        jmsListenerEndpointRegistrar.afterPropertiesSet();
        if (listenerBrokerConfig.brokerProperties.getList() == null) {
            return;
        }
        for (BrokerProperties brokerProperties : a2.brokerProperties.getList()) {
            Object object = new HashMap();
            object.put(c_vh.m_cj((Object)",O7T"), brokerProperties.getHost());
            object.put(c_bja.m_cj((Object)"<\u0014>\u000f"), brokerProperties.getPort());
            object = new TransportConfiguration(NettyConnectorFactory.class.getName(), object);
            TransportConfiguration[] transportConfigurationArray = new TransportConfiguration[1];
            transportConfigurationArray[0] = object;
            object = new ActiveMQConnectionFactory(false, transportConfigurationArray);
            String string = brokerProperties.getUser();
            if (StringUtils.hasText((String)string)) {
                object.setUser(string);
                object.setPassword(brokerProperties.getPassword());
            }
            object.setClientID(a2.nodeId);
            ListenerBrokerConfig listenerBrokerConfig2 = a2;
            brokerProperties = listenerBrokerConfig2.jmsProperties.getCache();
            object = new CachingConnectionFactory((ConnectionFactory)object);
            TransportConfiguration transportConfiguration = object;
            BrokerProperties brokerProperties2 = brokerProperties;
            object.setCacheConsumers(brokerProperties2.isConsumers());
            transportConfiguration.setCacheProducers(brokerProperties2.isProducers());
            transportConfiguration.setSessionCacheSize(brokerProperties.getSessionCacheSize());
            BrokerProperties brokerProperties3 = brokerProperties = new DefaultJmsListenerContainerFactory();
            ListenerBrokerConfig listenerBrokerConfig3 = a2;
            brokerProperties.setConnectionFactory((ConnectionFactory)object);
            brokerProperties.setMessageConverter(listenerBrokerConfig3.jacksonReceiveJmsMessageConverter());
            brokerProperties3.setPubSubDomain(Boolean.valueOf(listenerBrokerConfig3.jmsProperties.isPubSubDomain()));
            brokerProperties3.setSubscriptionDurable(Boolean.valueOf(true));
            object = listenerBrokerConfig2.jmsProperties.getListener();
            TransportConfiguration transportConfiguration2 = object;
            brokerProperties.setAutoStartup(transportConfiguration2.isAutoStartup());
            if (transportConfiguration2.getAcknowledgeMode() != null) {
                brokerProperties.setSessionAcknowledgeMode(Integer.valueOf(object.getAcknowledgeMode().getMode()));
            }
            if ((string = object.formatConcurrency()) != null) {
                brokerProperties.setConcurrency(string);
            }
            if ((object = object.getReceiveTimeout()) != null) {
                brokerProperties.setReceiveTimeout(Long.valueOf(((Duration)object).toMillis()));
            }
            Object object2 = object = a2.listenerList.iterator();
            while (object2.hasNext()) {
                SimpleJmsListenerEndpoint simpleJmsListenerEndpoint;
                string = (Listener)object.next();
                SimpleJmsListenerEndpoint simpleJmsListenerEndpoint2 = simpleJmsListenerEndpoint = new SimpleJmsListenerEndpoint();
                String string2 = string;
                simpleJmsListenerEndpoint.setId(string2.m_n());
                simpleJmsListenerEndpoint2.setSubscription(string2.m_u());
                simpleJmsListenerEndpoint2.setDestination(string.m_p());
                String string3 = string = new MessageListenerAdapter((Object)string);
                string3.setMessageConverter(a2.jacksonReceiveJmsMessageConverter());
                string3.setDefaultListenerMethod(c_vh.m_cj((Object)"R!C!I2E"));
                simpleJmsListenerEndpoint2.setMessageListener((MessageListener)string3);
                object2 = object;
                a.registerEndpoint((JmsListenerEndpoint)simpleJmsListenerEndpoint, (JmsListenerContainerFactory)brokerProperties);
            }
        }
    }
}

