/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.template.g.c_uh;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.fs.model.FileResult;
import com.inscada.mono.system.restcontrollers.SystemController;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class TemplateController<TDeviceTemplate extends DeviceTemplate<TFrameTemplate>, TFrameTemplate extends FrameTemplate<TDeviceTemplate, TVariableTemplate>, TVariableTemplate extends VariableTemplate<TFrameTemplate, TDeviceTemplate>, TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TTemplateService extends c_uh<TDeviceTemplate, TFrameTemplate, TVariableTemplate, TConnection, TDevice, TFrame, TVariable>> {
    private final TTemplateService G;

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariableTemplate a) {
        this.G.m_uwa(deviceId, frameId, variableId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames"})
    public Collection<TFrameTemplate> getFrames(@PathVariable(value="deviceId") Integer a) {
        return this.G.m_woa(a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    public TFrameTemplate getFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrameTemplate)this.G.m_bta(deviceId, a);
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        this.G.m_rqa(deviceId, frameId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public Collection<TVariableTemplate> getVariables(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return this.G.m_yta(deviceId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    public TVariableTemplate getVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        return (TVariableTemplate)this.G.m_pua(deviceId, frameId, a);
    }

    @GetMapping(value={"/devices/{deviceId}"})
    public TDeviceTemplate getDevice(@PathVariable(value="deviceId") Integer a) {
        return (TDeviceTemplate)this.G.m_goa(a);
    }

    @PostMapping(value={"/devices/{deviceId}/frames"})
    public ResponseEntity<TFrameTemplate> createFrame(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrameTemplate frame, UriComponentsBuilder a) {
        frame = this.G.m_bwa(deviceId, frame);
        Object[] objectArray = new Object[2];
        objectArray[0] = deviceId;
        objectArray[1] = frame.getId();
        return ResponseEntity.created((URI)a.path(FileResult.m_cj((Object)"m#'1+$'4m<&\"4.!\"\u000b#?h$5#*'4m<$5#*'\u000e&:")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrameTemplate a) {
        this.G.m_xsa(deviceId, frameId, a);
    }

    @PostMapping(value={"/devices"})
    public ResponseEntity<TDeviceTemplate> createDevice(@Valid @RequestBody TDeviceTemplate device, UriComponentsBuilder a) {
        device = this.G.m_pqa(device);
        Object[] objectArray = new Object[1];
        objectArray[0] = device.getId();
        return ResponseEntity.created((URI)a.path(SystemController.m_cj((Object)"_~\u0015l\u0019y\u0015i_a\u0014\u007f\u0006s\u0013\u007f9~\r")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDeviceTemplate> getDevices() {
        TemplateController a;
        return a.G.m_xoa();
    }

    public TemplateController(TTemplateService a) {
        TemplateController a2;
        a2.G = a;
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.G.m_cwa(deviceId, a);
    }

    @PutMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDeviceTemplate a) {
        this.G.m_rva(deviceId, a);
    }

    @PostMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public ResponseEntity<TVariableTemplate> createVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TVariableTemplate variable, UriComponentsBuilder a) {
        variable = this.G.m_dra(deviceId, frameId, variable);
        Object[] objectArray = new Object[3];
        objectArray[0] = deviceId;
        objectArray[1] = frameId;
        objectArray[2] = variable.getId();
        return ResponseEntity.created((URI)a.path(FileResult.m_cj((Object)"h&\"4.!\"1h9#'1+$'\u000e&:m!0&/\"1h9!0&/\"\u000b#?h4&0.#%.\"1h91#5+& +'\u000e&:")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @DeleteMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="deviceId") Integer a) {
        this.G.m_uva(a);
    }
}

