/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="frame")
@Inheritance(strategy=InheritanceType.JOINED)
@CheckAtLeastOneNotNull(fieldNames={"deviceId", "device"})
public class FrameTemplate<TDeviceTemplate extends DeviceTemplate<?>, TVariableTemplate extends VariableTemplate<?, ?>>
extends SpaceBaseModel {
    @Column(name="scan_time_factor")
    protected Integer scanTimeFactor;
    @NotNull
    @Column(name="readable_flag", nullable=false)
    protected Boolean isReadable;
    @JsonIgnore
    @ManyToOne(optional=false, targetEntity=DeviceTemplate.class)
    @JoinColumn(name="device_id")
    protected TDeviceTemplate device;
    @Size(max=255)
    protected String dsc;
    @Id
    @Column(name="frame_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="frameTemplateSeq")
    @GenericGenerator(name="frameTemplateSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="frame_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @NotBlank
    @Size(max=100)
    protected String name;
    @JsonIgnore
    @OneToMany(mappedBy="frame", orphanRemoval=true, targetEntity=VariableTemplate.class)
    protected Set<TVariableTemplate> variables;
    @Column(name="device_id", insertable=false, updatable=false)
    protected Integer deviceId;
    @Column(name="minutes_offset")
    protected Integer minutesOffset;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;

    public void setDevice(TDeviceTemplate a) {
        FrameTemplate a2;
        FrameTemplate frameTemplate = a2;
        frameTemplate.device = a;
        frameTemplate.deviceId = a != null && a.getId() != null ? a.getId() : null;
    }

    public int hashCode() {
        FrameTemplate a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getDeviceId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setIsReadable(boolean a) {
        a.isReadable = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public boolean getIsWritable() {
        FrameTemplate a;
        return a.isWritable;
    }

    public String getDsc() {
        FrameTemplate a;
        return a.dsc;
    }

    public Integer getScanTimeFactor() {
        FrameTemplate a;
        return a.scanTimeFactor;
    }

    public void setMinutesOffset(Integer a) {
        a.minutesOffset = a;
    }

    public void setDeviceId(Integer a) {
        a.deviceId = a;
    }

    public boolean equals(Object a) {
        FrameTemplate a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof FrameTemplate)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (FrameTemplate)a;
        return a2.getDeviceId().equals(a.getDeviceId()) && a2.getName().equals(a.getName());
    }

    public Set<TVariableTemplate> getVariables() {
        FrameTemplate a;
        return a.variables;
    }

    public void setScanTimeFactor(Integer a) {
        a.scanTimeFactor = a;
    }

    public void setVariables(Set<TVariableTemplate> a) {
        a.variables = a;
    }

    public void setIsWritable(boolean a) {
        a.isWritable = a;
    }

    public FrameTemplate() {
        FrameTemplate a;
        FrameTemplate frameTemplate = a;
        frameTemplate.variables = new HashSet();
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public TDeviceTemplate getDevice() {
        FrameTemplate a;
        return (TDeviceTemplate)a.device;
    }

    public void setName(String a) {
        a.name = a;
    }

    public String getName() {
        FrameTemplate a;
        return a.name;
    }

    public boolean getIsReadable() {
        FrameTemplate a;
        return a.isReadable;
    }

    public Integer getId() {
        FrameTemplate a;
        return a.id;
    }

    public Integer getMinutesOffset() {
        FrameTemplate a;
        return a.minutesOffset;
    }

    public Integer getDeviceId() {
        FrameTemplate a;
        return a.deviceId;
    }
}

