/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.repositories.VariableRepository;
import com.inscada.mono.communication.base.services.c_me;
import com.inscada.mono.communication.protocols.opcda.model.Leaf;
import com.inscada.mono.expression.g.c_ag;
import com.inscada.mono.fs.model.FileResult;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.g.c_kf;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_bh;
import com.inscada.mono.shared.exceptions.c_km;
import com.inscada.mono.shared.exceptions.c_rc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_hn<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>> {
    protected final VariableRepository<TVariable> i;
    protected final c_me<TConnection, TDevice, TFrame> d;
    protected final ApplicationEventPublisher k;
    protected static final String[] D;
    protected final c_kf F;
    protected final c_ag G;

    protected void m_jwa(TVariable a) {
        c_hn a2;
        if (a.getProject() == null) {
            TVariable TVariable = a;
            TVariable.setProject(a2.F.m_lj(TVariable.getProjectId()));
        }
        if (a.getFrame() == null) {
            TVariable TVariable = a;
            TVariable.setFrame(a2.d.m_yna(TVariable.getFrameId()));
        }
        if (a.getValueExpression() == null && a.getValueExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setValueExpression(a2.G.m_lj(TVariable.getValueExpressionId()));
        }
        if (a.getLogExpression() == null && a.getLogExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setLogExpression(a2.G.m_lj(TVariable.getLogExpressionId()));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_uua(Integer a, Pageable a2) {
        c_hn a3;
        return a3.i.findByProjectId(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE')")
    public TVariable m_ema(TVariable a) {
        c_hn a2;
        return (TVariable)a2.m_nqa(a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_xma(List<Integer> a) {
        c_hn a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyList();
        }
        return a2.i.findAllById(a);
    }

    public c_hn(c_kf a, c_me<TConnection, TDevice, TFrame> a2, c_ag a3, VariableRepository<TVariable> a4, ApplicationEventPublisher a5) {
        c_hn a6;
        c_hn c_hn2 = a6;
        c_hn c_hn3 = a6;
        a6.F = a;
        c_hn3.d = a2;
        c_hn3.G = a3;
        c_hn2.i = a4;
        c_hn2.k = a5;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_fta(Integer a, String a2, String a3, String a4) {
        c_hn a5;
        if ((a = a5.i.findVariablesByFrameName((Integer)a, a2, a3, a4)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    public void m_koa(TVariable a) {
        c_hn a2;
        c_hn c_hn2 = a2;
        c_hn2.m_jwa(a);
        c_hn2.m_dqa(a);
    }

    public Long m_pwa() {
        c_hn a;
        return a.i.count();
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_ql(Collection<TVariable> a2, boolean a3) {
        c_hn a4;
        a2.forEach(arg_0 -> a4.m_jwa(arg_0));
        Object object = a2.stream().map(Variable::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.i.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Variable::getProjectId, Collectors.mapping(Variable::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_hn a2;
            return a2.i.findByProjectIdAndNameIn((Integer)a.getKey(), (String[])((Set)a.getValue()).stream().toArray(String[]::new)).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        HashSet<Connection> hashSet = new HashSet<Connection>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Variable variable = (Variable)a2.next();
            if ((variable.getId() != null ? (Variable)map.get(variable.getId()) : (Variable)object.get(ImmutablePair.of((Object)variable.getProjectId(), (Object)variable.getName()))) != null) {
                Variable variable2;
                Variable variable3 = variable2;
                Connection connection = variable3.getConnection();
                Variable variable4 = variable;
                BeanUtils.copyProperties((Object)variable4, (Object)variable2, (String[])D);
                a4.m_dqa(variable4);
                Connection connection2 = variable3.getConnection();
                if (connection.getId() != null) {
                    hashSet.add(connection);
                }
                if (connection2.getId() != null && !connection2.getId().equals(connection.getId())) {
                    hashSet.add(connection2);
                }
                arrayList.add(variable2);
                continue;
            }
            a4.m_dqa(variable);
            arrayList.add(variable);
            hashSet.add(variable.getConnection());
        }
        a4.i.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_hn a2;
                a2.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_jma(VariableFilter a2) {
        c_hn a3;
        c_hn c_hn2 = a3;
        c_hn2.i.deleteAllByFilter(a2);
        c_hn2.d.m_da(a2.getProjectId()).forEach(a -> {
            c_hn a2;
            a2.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_nta(Integer a, String a2) {
        c_hn a3;
        Variable variable = a3.m_ca(a, a2);
        if (variable == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_bh(String.format(Leaf.m_cj((Object)"L\u0015h\u001d{\u0016v\u0011:\u001au\u0000:\u0012u\u0001t\u0010 Tj\u0006u\u001e\u007f\u0017nTs\u0010 T?\u00106Tt\u0015w\u0011 T?\u0007"), objectArray));
        }
        return (TVariable)variable;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_yka(Pageable a) {
        c_hn a2;
        return a2.i.findAll(a);
    }

    @Order(value=5)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_vm(ProjectDeleteEvent a) {
        c_hn a2;
        a2.m_ha(a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_da(Integer a) {
        c_hn a2;
        if ((a = a2.i.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_aa(Integer a) {
        c_hn a2;
        return (TVariable)((Variable)a2.i.findById((Object)a).orElse(null));
    }

    protected void m_dqa(TVariable a) {
        if (!a.getConnection().getProject().equals((Object)a.getProject())) {
            throw new c_km(FileResult.m_cj((Object)"\u00045#*'g \".(, 1g6(b&,(6/'5b70((\"!3"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_ssa(Integer a) {
        c_hn a2;
        if ((a = a2.i.findByFrameId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_vwa(VariableFilter a, Pageable a2) {
        c_hn a3;
        return a3.i.findVariablesByFilter(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_ca(Integer a, String a2) {
        c_hn a3;
        return (TVariable)a3.i.findOneByProjectIdAndName(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_cpa(List<Integer> a2) {
        c_hn a3;
        c_hn c_hn2 = a3;
        a2 = c_hn2.m_xma(a2);
        c_hn2.i.deleteInBatch(a2);
        a2.stream().map(Variable::getConnection).distinct().forEach(a -> {
            c_hn a2;
            a2.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_wva(TVariable a, boolean a2) {
        Variable variable;
        c_hn a3;
        TVariable TVariable = a;
        a3.m_jwa(TVariable);
        if ((TVariable.getId() != null ? (variable = a3.m_aa(a.getId())) : (variable = a3.m_ca(a.getProjectId(), a.getName()))) != null) {
            a3.m_yma(a, variable, a2);
            return;
        }
        a3.m_nqa(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_ata(Integer a, String[] a2) {
        c_hn a3;
        if (a2 == null || a2.length == 0) {
            return Collections.emptyList();
        }
        if ((a = a3.i.findByProjectIdAndNameIn((Integer)a, a2)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_ha(Integer a2) {
        if (a2 != null) {
            c_hn a3;
            c_hn c_hn2 = a3;
            c_hn2.i.deleteByProjectId(a2);
            c_hn2.d.m_da(a2).forEach(a -> {
                c_hn a2;
                a2.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    private /* synthetic */ TVariable m_nqa(TVariable a, boolean a2) {
        c_hn a3;
        c_hn c_hn2 = a3;
        c_hn2.m_koa(a);
        Variable variable = (Variable)c_hn2.i.save(a);
        if (a2) {
            a3.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a3, a.getConnection()));
        }
        return (TVariable)variable;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_VARIABLE')")
    public void m_gwa(Integer a, TVariable a2) {
        c_hn a3;
        c_hn c_hn2 = a3;
        a = c_hn2.m_lj(a);
        c_hn2.m_yma(a2, (Variable)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_lj(Integer a) {
        c_hn a2;
        Variable variable = a2.m_aa(a);
        if (variable == null) {
            throw new c_bh("Variable not found with id of " + a);
        }
        return (TVariable)variable;
    }

    static {
        String[] stringArray = new String[7];
        stringArray[0] = Leaf.m_cj((Object)"s\u0010");
        stringArray[1] = FileResult.m_cj((Object)"42&!\"");
        stringArray[2] = Leaf.m_cj((Object)"\u0004h\u001bp\u0011y\u0000");
        stringArray[3] = FileResult.m_cj((Object)"$0\"#3'#\u0000>");
        stringArray[4] = Leaf.m_cj((Object)"y\u0006\u007f\u0015n\u001du\u001a^\u0015n\u0011");
        stringArray[5] = FileResult.m_cj((Object)".&13\u000f(&.$.'#\u0000>");
        stringArray[6] = Leaf.m_cj((Object)"v\u0015i\u0000W\u001b~\u001d|\u001d\u007f\u0010^\u0015n\u0011");
        D = stringArray;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_ia(Integer a) {
        c_hn a2;
        if ((a = a2.m_aa(a)) != null) {
            if (a.getSourceVariableDataTransferDetails() != null && !a.getSourceVariableDataTransferDetails().isEmpty()) {
                throw new c_rc(FileResult.m_cj((Object)"\u0011#5+& +'g&\".\"6.-)b!#..\"&ib\u0003#3#g65#)1!'5b#'3#..g'?+464"));
            }
            if (a.getTargetVariableDataTransferDetails() != null && !a.getTargetVariableDataTransferDetails().isEmpty()) {
                throw new c_rc(Leaf.m_cj((Object)"\"{\u0006s\u0015x\u0018\u007fT~\u0011v\u0011n\u001du\u001a:\u0012{\u001dv\u0011~Z:0{\u0000{Tn\u0006{\u001ai\u0012\u007f\u0006:\u0010\u007f\u0000{\u001dvT\u007f\fs\u0007n\u0007"));
            }
            c_hn c_hn2 = a2;
            c_hn2.i.delete((Object)a);
            c_hn2.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a.getConnection()));
        }
    }

    private /* synthetic */ void m_yma(TVariable a, TVariable a2, boolean a3) {
        c_hn a4;
        TVariable TVariable = a2;
        c_hn c_hn2 = a4;
        c_hn2.m_jwa(a);
        Connection connection = TVariable.getConnection();
        BeanUtils.copyProperties(a, a2, (String[])D);
        c_hn2.m_dqa(TVariable);
        a = a2.getConnection();
        if (a3) {
            a4.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, connection));
            if (!a.getId().equals(connection.getId())) {
                a4.k.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, a));
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_va() {
        c_hn a;
        return a.i.findAll();
    }
}

