/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_kka;
import com.inscada.mono.cluster.g.c_xga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_t;
import com.inscada.mono.communication.base.enums.c_taa;
import com.inscada.mono.communication.base.events.DeleteEvent;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.ConnectorFactory;
import com.inscada.mono.communication.base.services.c_gh;
import com.inscada.mono.communication.base.services.c_iaa;
import com.inscada.mono.communication.base.services.c_w;
import com.inscada.mono.license.services.c_of;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.aspects.SetSpaceIdAspect;
import com.inscada.mono.shared.exceptions.c_al;
import com.inscada.mono.shared.exceptions.c_bh;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.g.c_va;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener {
    public static final short b = 203;
    private final ConnectorFactory<C, V> C;
    public static final short B = 210;
    public static final short L = 207;
    private final JedisPooled M;
    public static final short J = 204;
    private final Lock m;
    public static final short j = 206;
    private final c_t f;
    private static final Logger H = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short h = 201;
    private static final String c = "activeConnections";
    public static final short A = 205;
    public static final short i = 209;
    private final c_iaa d;
    public static final short k = 208;
    private final c_of D;
    private final c_ye F;
    public static final short G = 202;

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.startConnection(connectionManager.d.m_xub(a, a2).getId());
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ConnectionManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.f.m_qb((short)201, (Object)a, ConnectionManager.class.getDeclaredMethod(c_va.m_cj((Object)"fMtKazzW{\\vM|V{p{MpK{Xy"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.f.m_qb((short)202, (Object)a, ConnectionManager.class.getDeclaredMethod(SetSpaceIdAspect.m_cj((Object)"$(8,\u00143922?#582\u001e2#9%260"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.f.m_qb((short)203, (Object)a, ConnectionManager.class.getDeclaredMethod(c_va.m_cj((Object)"r\\azzW{\\vM|V{jaXaLfp{MpK{Xy"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = SetValueRequest.class;
            a.f.m_qb((short)204, (Object)a, ConnectionManager.class.getDeclaredMethod(SetSpaceIdAspect.m_cj((Object)"$9#\n6.>=502\n60\"9\u001e2#9%260"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Collection.class;
            a.f.m_qb((short)205, (Object)a, ConnectionManager.class.getDeclaredMethod(c_va.m_cj((Object)"f\\aotK|XwUpotU`\\fp{MpK{Xy"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.f.m_qb((short)206, (Object)a, ConnectionManager.class.getDeclaredMethod(SetSpaceIdAspect.m_cj((Object)"/#=%(\u00143922?#582$\u001e.\f%3=94(\u001e8\u001e2#9%260"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.f.m_qb((short)207, (Object)a, ConnectionManager.class.getDeclaredMethod(c_va.m_cj((Object)"JaVezzW{\\vM|V{JW@EKzSpZapqp{MpK{Xy"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.f.m_qb((short)208, (Object)a, ConnectionManager.class.getDeclaredMethod(SetSpaceIdAspect.m_cj((Object)"09#\u001f82994(>39\u000f#=#)$9$\u001e.\f%3=94(\u001e8\u001e2#9%260"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer[].class;
            a.f.m_qb((short)209, (Object)a, ConnectionManager.class.getDeclaredMethod(c_va.m_cj((Object)"^pMVV{WpZaPzWFMtM`JpJW@\\]fp{MpK{Xy"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = Integer.class;
            a.f.m_qb((short)210, (Object)a, ConnectionManager.class.getDeclaredMethod(SetSpaceIdAspect.m_cj((Object)"5.8+$9\u00143922?#582\u001e2#9%260"), classArray10));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(c_va.m_cj((Object)"\u007ftPy\\q\u0019aV5Kp^|Ja\\g\u0019VV{WpZaPzWXX{Xr\\g\u0019GiV\u0019x\\aQz]f"), noSuchMethodException);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> a) {
        ConnectionManager a2;
        c_gh c_gh2 = a2.C.getConnector(a.getConnectionId());
        if (c_gh2 == null) {
            throw new c_bh("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_gh2.m_sgb(a);
    }

    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String a, Connection a2) {
        ConnectionManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            H.info(SetSpaceIdAspect.m_cj((Object)"\u00143922?#582\u001a=9=09%|\u007f\u00102=39%|,!~fw\u000e2/#3%59;w?82994(>39fw'*|\u007f\u0015\u0013fw'*u"), objectArray);
            a3.startConnectionInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.F.m_lia(a2.getProject()).m_z("Connection Restore (Leader " + a + ")", String.format(c_va.m_cj((Object)"\u001cf\u0019=pQ\u00035\u001cq\u00105_tPy\\q\u0019aV5KpJaVg\\;\u0019VX`Jp\u00035\u001cf"), objectArray));
            try {
                H.warn(SetSpaceIdAspect.m_cj((Object)"\u00143922?#582\u001a=9=09%|\u007f\u00102=39%|,!~fw\u001d#(21'(>20|#3w/#3'|43922?#582w'*|6:#9%|%9$(8.6(>39|1=>0\".2r"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                H.error(c_va.m_cj((Object)"VV{WpZaPzWXX{Xr\\g\u0019=upXq\\g\u0019nD<\u00035\u007ftPy\\q\u0019aV5JaVe\u0019vV{WpZaPzW5Bh\u0019t_a\\g\u0019g\\fMzKtM|V{\u0019sX|U`Kp\u00035Bh"), objectArray2);
                return;
            }
        }
    }

    protected void startConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_kka.m_vbc(() -> {
            ConnectionManager a2;
            a2.m.lock();
            try {
                a2.stopConnectionInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_al("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.D.m_sga();
                connectionManager.C.provideConnector(a).m_nxa();
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                connectionManager.M.sadd(c, stringArray);
                return;
            }
            finally {
                a2.m.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> a22) {
        ConnectionManager a3;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, c_va.m_cj((Object)"jpMCXyLpkpH`\\fM5ZtW{Va\u0019w\\5W`Uy")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), SetSpaceIdAspect.m_cj((Object)"\u00143922?#582\u001e8w59|\u00049#\n60\"9\u00059&)2/#|4=928(w>2|9);0")));
        if (a3.f.m_rb()) {
            H.debug(SetSpaceIdAspect.m_cj((Object)"\u0010\u0012\u001d\u0013\u0019\u0005fw\u000f2(#59;w'*|!=%56>;9w*60\"9$|;34=;0.r"), (Object)a22.size());
            a3.setVariableValuesInternal(a22);
            return;
        }
        H.debug(c_va.m_cj((Object)"wZw8uPxQ|G\u00035kpH`\\fM|Wr\u0019y\\t]pK5Mz\u0019f\\a\u0019nD5OtK|XwUp\u0019cXyLpJ;"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<SetValueRequest<V>>(a22);
            a3.f.m_ib(Short.valueOf((short)205), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new c_xga(SetSpaceIdAspect.m_cj((Object)"\u001a65;93|#3w\u000e\u0007\u001fw/2(w*6.>=502|!=;)2/"), (Throwable)a22);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        String string = connectionManager.f.m_wa().getNodeId();
        H.info(c_va.m_cj((Object)"zzW{\\vM|V{ttWt^pK/\u0019AQ|J5Wz]p\u0019=Bh\u00105QtJ5[pZzTp\u0019aQp\u0019Y|T}Pk;\u0019G\\fMzK|Wr\u0019tZaPc\\5ZzW{\\vM|V{J;\u0017;"), (Object)string);
        connectionManager.m.lock();
        try {
            Set set = a2.M.smembers(c).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                H.info(SetSpaceIdAspect.m_cj((Object)"\u001f82994(>39\u0011626;2.wt\u001b9682.w'*um|\u00193w=4(>*2|43922?#582$|13\"23|>2w\u000e28>/w(8|%9$(8.2r"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            H.info(c_va.m_cj((Object)"VV{WpZaPzWXX{Xr\\g\u0019=upXq\\g\u0019nD<\u00035\u007fzL{]5Bh\u0019tZaPc\\5ZzW{\\vM|V{\u0019\\}f\u0019|W5kp]|J5Mz\u0019g\\fMzKp\u00035Bh"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = SetSpaceIdAspect.m_cj((Object)"\u0001\u0015\u0012\u000b\b\u001f\u0018\u0012\u0019\u0019\u0014\b\u001e\u0013\u0019\u0003\u001e\b\u0012\u0011");
            c_kka.m_rub(() -> {
                ConnectionManager a3;
                arrayList.addAll(a3.d.m_ryb(set));
            }, (String[])stringArray);
            H.info(c_va.m_cj((Object)"zzW{\\vM|V{ttWt^pK5\u0011Y\\t]pK5Bh\u0010/\u0019TMa\\xIaP{^5Mz\u0019g\\fMzKp\u0019nD5ZzW{\\vM|V{J;"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ConnectionManager a2;
                ConnectionManager connectionManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = SetSpaceIdAspect.m_cj((Object)"\u0004\b\u0016\u000e\u0003\u0003\u0014\u0013\u0019\u0012\u0012\u001f\u0003\u0015\u0018\u0012");
                stringArray[1] = c_va.m_cj((Object)"FmZiJzZw[|Vm\\v[");
                c_kka.m_lub(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1(connectionManager.f.m_wa().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            H.info(SetSpaceIdAspect.m_cj((Object)"\u001f82994(>39\u0011626;2.wt\u001b9682.w'*um|\u0011595$428w?82994(>39|%9$(8.6(>39|'.8?2/$r"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            H.error(c_va.m_cj((Object)"zzW{\\vM|V{ttWt^pK5\u0011Y\\t]pK5Bh\u0010/\u0019PKgVg\u0019qLgP{^5ZzW{\\vM|V{\u0019g\\fMzKtM|V{\u0019eKzZpJf\u00035Bh"), objectArray);
            return;
        }
        finally {
            a2.m.unlock();
        }
    }

    protected void stopConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.stopConnectionInternal(connectionManager.d.m_lj(a));
    }

    public ConnectionManager(c_iaa a, c_of a2, c_ye a3, ConnectorFactory<C, V> a4, JedisPooled a5, c_t a6) {
        ConnectionManager a7;
        ConnectionManager connectionManager = a7;
        ConnectionManager connectionManager2 = a7;
        ConnectionManager connectionManager3 = a7;
        ConnectionManager connectionManager4 = a7;
        connectionManager4.m = new ReentrantLock();
        connectionManager3.d = a;
        connectionManager3.D = a2;
        connectionManager2.F = a3;
        connectionManager2.C = a4;
        connectionManager.M = a5;
        connectionManager.f = a6;
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(Integer a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            H.debug(SetSpaceIdAspect.m_cj((Object)"\u001b\u0019\u0016\u0018\u0012\u000em|\u00079%:8.:59;w>%3 /2|8,2.6(>39|13%|43922?#582w'*|;34=;0.r"), (Object)a);
            return a2.browseConnectionInternal(a);
        }
        H.debug(c_va.m_cj((Object)"wZw8uPxQ|G\u00035kpH`\\fM|Wr\u0019y\\t]pK5Mz\u0019e\\g_zKx\u0019wKzNf\\5Ve\\gXaPzW5_zK5ZzW{\\vM|V{\u0019nD;"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return a2.f.m_ib(Short.valueOf((short)210), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC browse connection " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={DeleteEvent.class})
    public void handleDeleteEvent(DeleteEvent a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            Connection connection = a.getConnection();
            H.info(SetSpaceIdAspect.m_cj((Object)"\u001b\u0019\u0016\u0018\u0012\u000em|\u001f=98;59;w\u0018202(2\u0019!99(w:8.w?82994(>39fw'*|\u007f\u0015\u0013fw'*u"), (Object)connection.getName(), (Object)connection.getId());
            a2.stopConnectionInternal(connection);
            return;
        }
        H.debug(c_va.m_cj((Object)"[v[\u0014Y|T}Pk/\u0019\\^{VgP{^5}pUpMp|c\\{M5_zK5ZzW{\\vM|V{\u00035Bh"), (Object)a.getConnection().getId());
    }

    protected void startConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.d.m_bac((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.startConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"Y|T}Pk/\u0019FMtKaP{^5ZzW{\\vM|V{\u0019nD5UzZtUy@;"), (Object)a);
            a2.startConnectionInternal(a);
            return;
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0012\u0018\u0012z\u0010\u0012\u001d\u0013\u0019\u0005fw\u000e2-\"9$(>20|;9682.w(8|$(6.#|43922?#582w'*r"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)201), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC start connection " + a, (Throwable)exception);
        }
    }

    protected void stopConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_kka.m_vbc(() -> {
            ConnectionManager a2;
            a2.m.lock();
            try {
                c_gh c_gh2 = a2.C.getConnector(a.getId());
                if (c_gh2 != null) {
                    c_gh2.m_cza();
                    a2.C.removeConnector(a.getId(), c_gh2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.M.srem(c, stringArray);
                return;
            }
            finally {
                a2.m.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> a) {
        ConnectionManager a2;
        Objects.requireNonNull(a, c_va.m_cj((Object)"jpMCXyLpkpH`\\fM5ZtW{Va\u0019w\\5W`Uy"));
        Objects.requireNonNull(a.getConnectionId(), SetSpaceIdAspect.m_cj((Object)"\u00143922?#582\u001e8w59|\u00049#\n60\"9\u00059&)2/#|4=928(w>2|9);0"));
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"uPxQ|G\u00035jpMaP{^5OtK|XwUp\u0019cXyLp\u0019sVg\u0019vV{WpZaPzW5Bh\u0019yVvXyUl\u00035Bh"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0012\u0018\u0012z\u0010\u0012\u001d\u0013\u0019\u0005fw\u000e2-\"9$(>20|;9682.w(8|$9#|!=%56>;9w*60\"9w:8.w?82994(>39|,!m|,!"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)204), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f.m_sa((ClusterNodeListener)a);
        H.info(SetSpaceIdAspect.m_cj((Object)"\u00143922?#582\u001a=9=09%|>2>(>=;5-93|623|%905$(2.28w=$|\u00140\"/#9%\u0012882\u0010>/#999%r"));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.stopConnection(connectionManager.d.m_xub(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_taa> getConnectionStatuses(Integer[] a) {
        ConnectionManager a2;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"Y|T}Pk/\u0019R\\aM|Wr\u0019vV{WpZaPzW5JaXaLf\\f\u0019sVg\u0019nD5pQJ5UzZtUy@;"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal(a);
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0012\u0018\u0012z\u0010\u0012\u001d\u0013\u0019\u0005fw\u000e2-\"9$(>20|;9682.w:8.w?82994(>39|$(6(\"/2/w:8.w'*|\u001e\u0018$r"), (Object)a.length);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.f.m_ib(Short.valueOf((short)209), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get connection statuses for IDs " + Arrays.toString((Object[])a), (Throwable)exception);
        }
    }

    protected Map<Integer, c_taa> getConnectionStatusesByIdsInternal(Integer[] a2) {
        ConnectionManager a3;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> a3.getConnectionStatusInternal(arg_0)));
    }

    public void notLeader() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        String string = connectionManager.f.m_wa().getNodeId();
        H.info(SetSpaceIdAspect.m_cj((Object)"\u001f82994(>39\u0011626;2.m|\u00034>/w2882|\u007f'*uw5$|\u0019\u0013w\u0010\u0018\u0012\u0010\u0019\u0005|\u0003\u0014\u0012|\u001b\u0019\u0016\u0018\u0012\u000ey|\u0004(8,'59;w=;0w08?60w?82994(8.$ryr"), (Object)string);
        connectionManager.m.lock();
        try {
            a.C.stopAllLocalConnectors();
            H.info(c_va.m_cj((Object)"zzW{\\vM|V{ttWt^pK5\u0011[Va\u0019Y\\t]pK5Bh\u0010/\u0019TUy\u0019yVvXy\u0019vV{WpZaVgJ5QtOp\u0019w\\pW5KpH`\\fMp]5Mz\u0019fMzI5X{]5Zy\\tKp]5_gVx\u0019yVvXy\u0019aKtZ~P{^;"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            H.error(SetSpaceIdAspect.m_cj((Object)"\u00143922?#582\u001a=9=09%|\u007f\u00128(w\u00102=39%|,!~fw\u0019%.8.w8\".>20|'.8?2/$|8:w/#3',>20|;34=;|43922?#3%/m|,!"), objectArray);
            return;
        }
        finally {
            a.m.unlock();
        }
    }

    @TransactionalEventListener(value={RestartEvent.class})
    public void handleRestartEvent(RestartEvent a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            Connection connection = a.getConnection();
            H.info(c_va.m_cj((Object)"Y|T}Pk/\u0019]X{]yP{^5kpJaXgMPOpWa\u0019sVg\u0019vV{WpZaPzW/\u0019nD5\u0011\\}/\u0019nD<"), (Object)connection.getName(), (Object)connection.getId());
            a2.m.lock();
            try {
                if (a2.getConnectionStatusInternal(connection.getId()) == c_taa.G) {
                    a2.startConnectionInternal(connection.getId());
                }
                return;
            }
            finally {
                a2.m.unlock();
            }
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0019\u0013\u0019q\u001b\u0019\u0016\u0018\u0012\u000em|\u001e;93%59;w\u000e2/#=%(\u0012*22#|13%|43922?#582m|,!"), (Object)a.getConnection().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_taa> getConnectionStatuses(Integer a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"Y|T}Pk/\u0019R\\aM|Wr\u0019tUy\u0019vV{WpZaPzW5JaXaLf\\f\u0019sVg\u0019eKzSpZa\u0019nD5UzZtUy@;"), (Object)a);
            return a2.getConnectionStatusesByProjectIdInternal(a);
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0012\u0018\u0012z\u0010\u0012\u001d\u0013\u0019\u0005fw\u000e2-\"9$(>20|;9682.w:8.w=;0w?82994(>39|$(6(\"/2/w:8.w,%3=94(w'*r"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.f.m_ib(Short.valueOf((short)208), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get connection statuses for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(Integer a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"uPxQ|G\u00035jaXgM|Wr\u0019tUy\u0019vV{WpZaPzWf\u0019sVg\u0019eKzSpZa\u0019nD5UzZtUy@;"), (Object)a);
            a2.startConnectionsByProjectIdInternal(a);
            return;
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0019\u0013\u0019q\u001b\u0019\u0016\u0018\u0012\u000em|\u00059&)2/#59;w02=39%|#3w/#=%(w=;0w?82994(>39/w:8.w,%3=94(w'*r"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)206), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC start connections for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_taa getConnectionStatus(Integer a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"Y|T}Pk/\u0019R\\aM|Wr\u0019vV{WpZaPzW5JaXaLf\u0019sVg\u0019nD5UzZtUy@;"), (Object)a);
            return a2.getConnectionStatusInternal(a);
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0012\u0018\u0012z\u0010\u0012\u001d\u0013\u0019\u0005fw\u000e2-\"9$(>20|;9682.w:8.w?82994(>39|$(6(\"/w:8.w'*r"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_taa)a2.f.m_ib(Short.valueOf((short)203), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get connection status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_taa getConnectionStatus(Integer a, String a2) {
        ConnectionManager a3;
        if ((a = a3.d.m_af(a, a2)) == null) {
            return c_taa.F;
        }
        return a3.getConnectionStatus(a.getId());
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> a3) {
        ConnectionManager a4;
        a3.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((a, a2) -> {
            ConnectionManager a3;
            if ((a = a3.C.getConnector(a)) != null) {
                a.m_uhb(a2);
            }
        });
    }

    protected Map<Integer, c_taa> getConnectionStatusesByProjectIdInternal(Integer a2) {
        ConnectionManager a3;
        if ((a2 = a3.d.m_da((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Connection::getId, a -> {
            ConnectionManager a2;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    protected c_taa getConnectionStatusInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.C.getConnector(a)) != null && a.m_bxa()) {
            return c_taa.G;
        }
        return c_taa.F;
    }

    protected Object browseConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        Connection connection = connectionManager.d.m_lj(a);
        return c_kka.m_kyb(() -> {
            ConnectionManager a2;
            if ((a = a2.C.getConnector(a)) instanceof c_w) {
                return ((c_w)a).m_ta();
            }
            throw new RuntimeException(c_va.m_cj((Object)"{gVbJp\u0019zIpKtM|V{\u0019{Va\u0019fLeIzKa\\q"));
        }, (OwnedSpaceBaseModel)connection);
    }

    protected void stopConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.d.m_da((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"Y|T}Pk/\u0019FMzIeP{^5ZzW{\\vM|V{\u0019nD5UzZtUy@;"), (Object)a);
            a2.stopConnectionInternal(a);
            return;
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0019\u0013\u0019q\u001b\u0019\u0016\u0018\u0012\u000em|\u00059&)2/#59;w02=39%|#3w/#3'|43922?#582w'*r"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)202), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC stop connection " + a, (Throwable)exception);
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            Integer n = a.getProject().getId();
            H.info(c_va.m_cj((Object)"uPxQ|G\u00035qtWqU|Wr\u0019EKzSpZa}pXvM|OtMp|c\\{M5_zK5IgV\u007f\\vM5pQ\u00035Bh"), (Object)n);
            a2.stopConnectionsByProjectIdInternal(n);
            return;
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0019\u0013\u0019q\u001b\u0019\u0016\u0018\u0012\u000em|\u001e;93%59;w\f%3=94(\u001396?#5!=#9\u0012*22#|13%|'.862?#|\u001e\u0018m|,!"), (Object)a.getProject().getId());
    }

    protected void startConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.startConnectionInternal(connectionManager.d.m_ldc(a));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(Integer a) {
        ConnectionManager a2;
        if (a2.f.m_rb()) {
            H.debug(c_va.m_cj((Object)"uPxQ|G\u00035jaVeI|Wr\u0019tUy\u0019vV{WpZaPzWf\u0019sVg\u0019eKzSpZa\u0019nD5UzZtUy@;"), (Object)a);
            a2.stopConnectionsByProjectIdInternal(a);
            return;
        }
        H.debug(SetSpaceIdAspect.m_cj((Object)"\u0012\u0018\u0012z\u0010\u0012\u001d\u0013\u0019\u0005fw\u000e2-\"9$(>20|;9682.w(8|$(8,w=;0w?82994(>39/w:8.w,%3=94(w'*r"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.f.m_ib(Short.valueOf((short)207), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC stop connections for project " + a, (Throwable)exception);
        }
    }
}

