/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_me;
import com.inscada.mono.communication.base.template.g.c_uh;
import com.inscada.mono.communication.base.template.model.DeviceGenerationRequest;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.model.ProjectClone;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TConnectionService extends c_me<TConnection, TDevice, TFrame>, TTemplateService extends c_uh> {
    protected final TConnectionService F;
    protected final TTemplateService G;

    @PutMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConnection(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TConnection a) {
        this.F.m_hqa(connectionId, a);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public Collection<TFrame> getFrames(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return this.F.m_ywa(connectionId, a);
    }

    @GetMapping(value={"/device/{deviceId}"})
    public TDevice getDeviceById(@PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.F.m_vqa(a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        this.F.m_vua(connectionId, a);
    }

    @PostMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public ResponseEntity<TFrame> createFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrame frame, UriComponentsBuilder a) {
        frame = this.F.m_wwa(connectionId, deviceId, frame, Boolean.valueOf(true));
        Object[] objectArray = new Object[3];
        objectArray[0] = connectionId;
        objectArray[1] = deviceId;
        objectArray[2] = frame.getId();
        return ResponseEntity.created((URI)a.path(ProjectClone.m_cj((Object)"X2\u0014&\u0019'\u0012*\u0003 \u0018'>-\nf\u0013,\u0001 \u0014,\u0004f\f-\u0012?\u001e*\u0012\u0000\u00134X/\u0005(\u001a,\u0004f\f/\u0005(\u001a,>-\n")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    public TFrame getFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrame)this.F.m_ina(connectionId, deviceId, a);
    }

    @GetMapping(value={"/frames"})
    public Collection<TFrame> getFrames(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.F.m_hua();
        }
        return this.F.m_foa(a);
    }

    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnection(@PathVariable(value="connectionId") Integer a) {
        this.F.m_ia(a);
    }

    protected ConnectionController(TConnectionService a, TTemplateService a2) {
        ConnectionController a3;
        ConnectionController connectionController = a3;
        connectionController.F = a;
        connectionController.G = a2;
    }

    @DeleteMapping(value={"/frames"}, params={"frameIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFramesByIds(@RequestParam(value="frameIds") Integer[] a) {
        this.F.m_lua(List.of(a));
    }

    @DeleteMapping(value={"/devices"}, params={"deviceIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevicesByIds(@RequestParam(value="deviceIds") Integer[] a) {
        this.F.m_zva(List.of(a));
    }

    @DeleteMapping(value={""}, params={"connectionIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnectionsByIds(@RequestParam(value="connectionIds") Integer[] a) {
        this.F.m_fsa(List.of(a));
    }

    @PostMapping
    public ResponseEntity<TConnection> createConnection(@Valid @RequestBody TConnection connection, UriComponentsBuilder a) {
        connection = this.F.m_zsa(connection);
        Object[] objectArray = new Object[1];
        objectArray[0] = connection.getId();
        return ResponseEntity.created((URI)a.path(c_ye.m_cj((Object)"2>~*s+x&i,r+T!`")).buildAndExpand(objectArray).toUri()).body(connection);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDevice a) {
        this.F.m_cma(connectionId, deviceId, a, Boolean.valueOf(true));
    }

    @GetMapping(value={"/devices"})
    public Collection<TDevice> getDevicesByProjectId(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.F.m_xoa();
        }
        return this.F.m_xva(a);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}"})
    public TDevice getDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.F.m_fwa(connectionId, a);
    }

    @GetMapping
    public Collection<TConnection> getConnections(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.F.m_va();
        }
        return this.F.m_da(a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.F.m_rsa(connectionId, deviceId, a);
    }

    @PostMapping(value={"/{connectionId}/devices/generate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void generateFromTemplate(@PathVariable(value="connectionId") Integer connectionId, @RequestBody DeviceGenerationRequest a) {
        this.G.m_cua(connectionId, a);
    }

    public static String m_cj(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (2 ^ 5) << 4 ^ (2 ^ 5);
        int cfr_ignored_0 = 5 << 4 ^ 5;
        int n4 = n2;
        int n5 = 4 << 3;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @GetMapping(value={"/{connectionId}/devices"})
    public Collection<TDevice> getDevices(@PathVariable(value="connectionId") Integer a) {
        return this.F.m_sva(a);
    }

    @GetMapping(value={"/{connectionId}"})
    public TConnection getConnection(@PathVariable(value="connectionId") Integer a) {
        return (TConnection)this.F.m_aa(a);
    }

    @GetMapping(value={"/frame/{frameId}"})
    public TFrame getFrameById(@PathVariable(value="frameId") Integer a) {
        return (TFrame)this.F.m_coa(a);
    }

    @PostMapping(value={"/{connectionId}/devices"})
    public ResponseEntity<TDevice> createDevice(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TDevice device, UriComponentsBuilder a) {
        device = this.F.m_ita(connectionId, device, Boolean.valueOf(true));
        Object[] objectArray = new Object[2];
        objectArray[0] = connectionId;
        objectArray[1] = device.getId();
        return ResponseEntity.created((URI)a.path(ProjectClone.m_cj((Object)"f\f*\u0018'\u0019,\u0014=\u001e&\u0019\u0000\u00134X-\u0012?\u001e*\u0012:X2\u0013,\u0001 \u0014,>-\n")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrame a) {
        this.F.m_poa(connectionId, deviceId, frameId, a, Boolean.valueOf(true));
    }
}

