/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.repositories;

import com.inscada.mono.communication.base.enums.c_ica;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.Collection;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ConnectionRepository<TConnection extends Connection<?>>
extends BaseJpaRepository<TConnection, Integer> {
    public Collection<TConnection> findByProjectId(Integer var1);

    public Collection<TConnection> findByProjectIdAndNameIn(Integer var1, Set<String> var2);

    @Query(value="select c from Connection c left join fetch c.devices d left join fetch d.frames f left join fetch f.variables v where c.id = :connectionId")
    public TConnection fetchOne(@Param(value="connectionId") Integer var1);

    public Collection<TConnection> findByPortAndProtocolIn(Integer var1, Collection<c_ica> var2);

    @Query(value="select distinct c from Connection c left join fetch c.devices d left join fetch d.frames f left join fetch f.variables v where c.projectId = :projectId")
    public Collection<TConnection> fetchByProjectId(@Param(value="projectId") Integer var1);

    @Query(value="select c from Connection c left join fetch c.devices d left join fetch d.frames f left join fetch f.variables v where c.projectId = :projectId and c.name = :name")
    public TConnection fetchOneByProjectIdAndName(@Param(value="projectId") Integer var1, @Param(value="name") String var2);

    public void deleteByProjectId(Integer var1);

    @Query(value="select distinct c from Connection c left join fetch c.devices d left join fetch d.frames f left join fetch f.variables v where c.id in (:activeConnectionIds)")
    public Collection<TConnection> fetchAllById(@Param(value="activeConnectionIds") Set<Integer> var1);

    public void deleteAllByIdIn(Collection<Integer> var1);

    public TConnection findOneByProjectIdAndName(Integer var1, String var2);
}

