/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.restcontrollers;

import com.inscada.mono.animation.enums.c_yga;
import com.inscada.mono.animation.g.c_dba;
import com.inscada.mono.animation.g.c_sja;
import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.animation.model.RunAnimScriptDto;
import com.inscada.mono.auth.restcontrollers.AuthController;
import com.inscada.mono.communication.base.services.g.c_zm;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.g.c_kf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/animations"})
public class AnimationController
extends ProjectBasedImportExportController {
    private final c_sja F;
    private final c_dba G;

    @GetMapping
    public Collection<Animation> getAnimations(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.G.m_va();
        }
        return this.G.m_da(a);
    }

    @PostMapping(value={"/{animationId}/clone"}, params={"name"})
    public ResponseEntity<Animation> cloneAnimation(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        animationId = this.G.m_tfa(animationId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = animationId.getId();
        return ResponseEntity.created((URI)a.path(c_zm.m_cj((Object)"\fdBqJrBkJpMVGb")).buildAndExpand(objectArray).toUri()).body((Object)animationId);
    }

    @PostMapping(value={"/{animationId}/scripts"})
    public ResponseEntity<AnimationScript> createAnimationScript(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationScript animationScript, UriComponentsBuilder a) {
        animationScript = this.G.m_hfc(animationId, animationScript);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationScript.getId();
        return ResponseEntity.created((URI)a.path(AuthController.m_cj((Object)"<\u0014r\u0001z\u0002r\u001bz\u0000}&w\u0012<\u001cp\u001dz\u001fg\u001c<\u0014`\fa\u0006c\u001bZ\u000bn")).buildAndExpand(objectArray).toUri()).body((Object)animationScript);
    }

    @GetMapping(value={"/{animationId}/elements/{elementId}"})
    public AnimationElement getAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        return this.G.m_kha(animationId, a);
    }

    @GetMapping(value={"/{animationId}/scripts/{scriptId}"})
    public AnimationScript getAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        return this.G.m_uxb(animationId, a);
    }

    @DeleteMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        this.G.m_uka(animationId, a);
    }

    @DeleteMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimation(@PathVariable(value="animationId") Integer a) {
        this.G.m_ia(a);
    }

    @GetMapping(value={"/{animationId}/svg"})
    public ResponseEntity<InputStreamResource> getAnimationSvg(@PathVariable(value="animationId") Integer a) {
        a = this.G.m_lj(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(c_zm.m_cj((Object)"\\LqWzMk\u000e[JlSpPvWvLq"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)AuthController.m_cj((Object)"z\u0002r\bv@`\u0019tDk\u0002\u007f"))).body((Object)byteArrayInputStream);
    }

    @GetMapping(value={"/name/elements"}, params={"name", "type"})
    public AnimationElement getAnimationElementByNameAndType(@RequestParam(name="name") String name, @RequestParam(name="type") c_yga a) {
        return this.G.m_xqc(name, a);
    }

    public AnimationController(c_dba a, c_sja a2, c_hh a3, c_kf a4) {
        AnimationController a5;
        AnimationController animationController = a5;
        super(a3, EnumSet.of(c_wk.B), a4);
        animationController.G = a;
        animationController.F = a2;
    }

    @DeleteMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        this.G.m_lic(animationId, a);
    }

    @GetMapping(value={"/project/{projectId}"}, params={"name"})
    public Animation getAnimationByProjectId(@PathVariable(value="projectId") Integer projectId, @RequestParam(name="name") String a) {
        return this.G.m_af(projectId, a);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Animation> getAnimationsByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.G.m_yia(projectId, a);
    }

    @GetMapping(value={"/{animationId}/elements"})
    public Collection<AnimationElement> getAnimationElements(@PathVariable(value="animationId") Integer a) {
        return this.G.m_fba(a);
    }

    @PutMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimation(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody Animation a) {
        this.G.m_fwb(animationId, a);
    }

    @GetMapping(value={"/{animationId}"})
    public Animation getAnimation(@PathVariable(value="animationId") Integer a) {
        return this.G.m_aa(a);
    }

    @PostMapping
    public ResponseEntity<Animation> createAnimation(@Valid @RequestBody Animation animation, UriComponentsBuilder a) {
        animation = this.G.m_cxb(animation);
        Object[] objectArray = new Object[1];
        objectArray[0] = animation.getId();
        return ResponseEntity.created((URI)a.path(c_zm.m_cj((Object)"\fdBqJrBkJpMVGb")).buildAndExpand(objectArray).toUri()).body((Object)animation);
    }

    @MessageMapping(value={"/eval-animation"})
    public void animationResultMessage(@Payload EvalAnimationMessage evalAnimationMessage, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.F.m_ric(evalAnimationMessage, a.getName(), sessionId);
    }

    @GetMapping(value={"/project"}, params={"projectName", "name"})
    public Animation getAnimationByProjectName(@RequestParam(name="projectName") String projectName, @RequestParam(name="name") String a) {
        return this.G.m_plc(projectName, a);
    }

    @MessageMapping(value={"/run-animation-script"})
    public void runAnimationScript(@Payload RunAnimScriptDto runAnimScriptDto, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.F.m_tnc(runAnimScriptDto, a.getName(), sessionId);
    }

    @PutMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody AnimationElement a) {
        this.G.m_fjc(animationId, elementId, a);
    }

    @PutMapping(value={"/{animationId}/placeholders"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updatePlaceholders(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.G.m_fmc(animationId, a);
    }

    @GetMapping(value={"/{animationId}/elements"}, params={"type"})
    public Collection<AnimationElement> getAnimationElementsByType(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="type") c_yga a) {
        return this.G.m_mjc(animationId, a);
    }

    @GetMapping(value={"/{animationId}/scripts"})
    public Collection<AnimationScript> getAnimationScripts(@PathVariable(value="animationId") Integer a) {
        return this.G.m_ofc(a);
    }

    @DeleteMapping(value={"/{animationId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElementsByIds(@PathVariable(value="animationId") Integer animationId, @RequestParam(value="elementIds") Integer[] a) {
        this.G.m_fvb(animationId, a);
    }

    @DeleteMapping(value={"/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="elementId") Integer a) {
        this.G.m_omc(a);
    }

    @PutMapping(value={"/{animationId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationSvg(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.G.m_uca(animationId, a);
    }

    @PostMapping(value={"/{animationId}/elements"})
    public ResponseEntity<AnimationElement> createAnimationElement(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationElement animationElement, UriComponentsBuilder a) {
        animationElement = this.G.m_gqc(animationId, animationElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationElement.getId();
        return ResponseEntity.created((URI)a.path(AuthController.m_cj((Object)"<\u0014r\u0001z\u0002r\u001bz\u0000}&w\u0012<\n\u007f\n~\n}\u001b`@h\n\u007f\n~\n}\u001bZ\u000bn")).buildAndExpand(objectArray).toUri()).body((Object)animationElement);
    }

    @PutMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody AnimationScript a) {
        this.G.m_gjc(animationId, scriptId, a);
    }
}

