/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="animation_script")
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"animationId", "animation"}), @CheckAtLeastOneNotNull(fieldNames={"scriptId", "script"})})
public class AnimationScript
extends SpaceBaseModel {
    @Column(name="script_id", updatable=false, insertable=false)
    private Integer scriptId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="script_id")
    private RepeatableScript script;
    @NotBlank
    @Size(max=20)
    private String type;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="animation_id")
    private Animation animation;
    @Column(name="animation_id", updatable=false, insertable=false)
    private Integer animationId;
    @Id
    @Column(name="animation_script_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="animationScriptSeq")
    @GenericGenerator(name="animationScriptSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="animation_script_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;

    public void setScript(RepeatableScript a) {
        AnimationScript a2;
        AnimationScript animationScript = a2;
        animationScript.script = a;
        animationScript.scriptId = a != null && a.getId() != null ? a.getId() : null;
    }

    public RepeatableScript getScript() {
        AnimationScript a;
        return a.script;
    }

    public Integer getScriptId() {
        AnimationScript a;
        return a.scriptId;
    }

    public String getType() {
        AnimationScript a;
        return a.type;
    }

    public void setScriptId(Integer a) {
        a.scriptId = a;
    }

    public void setType(String a) {
        a.type = a;
    }

    public boolean equals(Object a) {
        AnimationScript a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof AnimationScript)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (AnimationScript)a;
        return a2.getAnimationId().equals(a.getAnimationId()) && a2.getScriptId().equals(a.getScriptId()) && a2.getType().equals(a.getType());
    }

    public Integer getId() {
        AnimationScript a;
        return a.id;
    }

    public AnimationScript(String a) {
        AnimationScript a2;
        a2.type = a;
    }

    public int hashCode() {
        AnimationScript a;
        Object[] objectArray = new Object[4];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getAnimationId();
        objectArray[2] = a.getScriptId();
        objectArray[3] = a.getType();
        return Objects.hash(objectArray);
    }

    public AnimationScript() {
        AnimationScript a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public Animation getAnimation() {
        AnimationScript a;
        return a.animation;
    }

    public void setAnimationId(Integer a) {
        a.animationId = a;
    }

    public Integer getAnimationId() {
        AnimationScript a;
        return a.animationId;
    }

    public void setAnimation(Animation a) {
        AnimationScript a2;
        AnimationScript animationScript = a2;
        animationScript.animation = a;
        animationScript.animationId = a != null && a.getId() != null ? a.getId() : null;
    }
}

