/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.repositories.AlarmGroupRepository;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.g.c_kf;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.services.c_qn;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_bh;
import com.inscada.mono.shared.exceptions.c_km;
import com.inscada.mono.shared.exceptions.c_rc;
import com.inscada.mono.shared.model.BaseModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@EnableSpaceFilter
public class c_lha {
    private final c_qn d;
    private final AlarmGroupRepository k;
    private final ApplicationEventPublisher D;
    private static final String[] F;
    private final c_kf G;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_aa(Integer a) {
        c_lha a2;
        return a2.k.findById((Object)a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_lj(Integer a) {
        c_lha a2;
        AlarmGroup alarmGroup = a2.m_aa(a);
        if (alarmGroup == null) {
            throw new c_bh("Alarm group not found with id of " + a);
        }
        return alarmGroup;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_rh(Integer a, String a2) {
        c_lha a3;
        if ((a = a3.m_af(a, a2)) == null) {
            throw new c_bh("Alarm group not found with name of " + a2);
        }
        return a;
    }

    public c_lha(c_kf a, c_qn a2, AlarmGroupRepository a3, ApplicationEventPublisher a4) {
        c_lha a5;
        c_lha c_lha2 = a5;
        c_lha c_lha3 = a5;
        c_lha3.G = a;
        c_lha3.d = a2;
        c_lha2.k = a3;
        c_lha2.D = a4;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_kq(List<AlarmGroup> a2, boolean a3) {
        c_lha a4;
        a2.forEach(a -> {
            RepeatableScript repeatableScript;
            c_lha a2;
            if (a.getProject() == null) {
                AlarmGroup alarmGroup = a;
                alarmGroup.setProject(a2.G.m_lj(alarmGroup.getProjectId()));
            }
            if (a.getOnScript() == null && a.getOnScriptId() != null) {
                repeatableScript = a2.d.m_lj(a.getOnScriptId());
                a.setOnScript(repeatableScript);
            }
            if (a.getOffScript() == null && a.getOffScriptId() != null) {
                repeatableScript = a2.d.m_lj(a.getOffScriptId());
                a.setOffScript(repeatableScript);
            }
            if (a.getAckScript() == null && a.getAckScriptId() != null) {
                repeatableScript = a2.d.m_lj(a.getAckScriptId());
                a.setAckScript(repeatableScript);
            }
        });
        Object object = a2.stream().map(AlarmGroup::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.k.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(AlarmGroup::getProjectId, Collectors.mapping(AlarmGroup::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_lha a2;
            return a2.k.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(AlarmGroup::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<AlarmGroup> arrayList = new ArrayList<AlarmGroup>();
        HashSet<AlarmGroup> hashSet = new HashSet<AlarmGroup>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a2.next();
            if ((alarmGroup.getId() != null ? (AlarmGroup)map.get(alarmGroup.getId()) : (AlarmGroup)object.get(ImmutablePair.of((Object)alarmGroup.getProjectId(), (Object)alarmGroup.getName()))) != null) {
                AlarmGroup alarmGroup2;
                AlarmGroup alarmGroup3 = alarmGroup2;
                a4.m_khc(alarmGroup, alarmGroup3, false);
                hashSet.add(alarmGroup3);
                arrayList.add(alarmGroup2);
                continue;
            }
            a4.m_wgc(alarmGroup);
            arrayList.add(alarmGroup);
        }
        a4.k.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_lha a2;
                a2.D.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a2, a));
            });
        }
    }

    private /* synthetic */ void m_wgc(AlarmGroup a) {
        if (a.getOnScript() != null && !a.getOnScript().getProject().equals((Object)a.getProject())) {
            throw new c_km(BaseModel.m_cj((Object)"\u001f7?)3{9)1..{.)11;8*{?5:{15~(=)7+*{.)11;8*{3.-/~6?/=3"));
        }
        if (a.getOffScript() != null && !a.getOffScript().getProject().equals((Object)a.getProject())) {
            throw new c_km(SetValueRequest.m_cj((Object)"+\\\u000bB\u0007\u0010\rB\u0005E\u001a\u0010\u001aB\u0005Z\u000fS\u001e\u0010\u000b^\u000e\u0010\u0005V\f\u0010\u0019S\u0018Y\u001aDJ@\u0018_\u0000U\tDJ]\u001fC\u001e\u0010\u0007Q\u001eS\u0002"));
        }
        if (a.getAckScript() != null && !a.getAckScript().getProject().equals((Object)a.getProject())) {
            throw new c_km(BaseModel.m_cj((Object)"\u001a2:,6~<,4++~+,44>=/~:0?~:=0~(=)7+*{.)11;8*{3.-/~6?/=3"));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP')")
    public void m_ljc(Integer a, AlarmGroup a2) {
        c_lha a3;
        c_lha c_lha2 = a3;
        a = c_lha2.m_lj(a);
        c_lha2.m_khc(a2, (AlarmGroup)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_dpc(Set<Integer> a) {
        c_lha a2;
        if ((a = a2.k.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_va() {
        c_lha a;
        return a.k.findAll();
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_qqc(AlarmGroup a, boolean a2) {
        AlarmGroup alarmGroup;
        c_lha a3;
        AlarmGroup alarmGroup2 = a;
        a3.m_kqc(alarmGroup2);
        if ((alarmGroup2.getId() != null ? (alarmGroup = a3.m_aa(a.getId())) : (alarmGroup = a3.m_af(a.getProjectId(), a.getName()))) != null) {
            a3.m_khc(a, alarmGroup, a2);
            return;
        }
        c_lha c_lha2 = a3;
        c_lha2.m_wgc(a);
        c_lha2.k.save((Object)a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM_GROUP')")
    public AlarmGroup m_slc(AlarmGroup a) {
        c_lha a2;
        c_lha c_lha2 = a2;
        c_lha2.m_clc(a);
        return (AlarmGroup)c_lha2.k.save((Object)a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_ha(Integer a) {
        if (a != null) {
            c_lha a2;
            a2.k.deleteByProjectId(a);
        }
    }

    @Order(value=4)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_vm(ProjectDeleteEvent a) {
        c_lha a2;
        a2.m_ha(a.getProject().getId());
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_ia(Integer a) {
        c_lha a2;
        if ((a = a2.m_aa(a)) != null) {
            Set set = a.getAlarms();
            if (!set.isEmpty()) {
                throw new c_rc("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
            }
            c_lha c_lha2 = a2;
            c_lha2.k.delete((Object)a);
            c_lha2.D.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, (AlarmGroup)a));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_af(Integer a, String a2) {
        c_lha a3;
        return a3.k.findOneByProjectIdAndName(a, a2);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = SetValueRequest.m_cj((Object)"Y\u000e");
        stringArray[1] = BaseModel.m_cj((Object)"(.:=>");
        stringArray[2] = SetValueRequest.m_cj((Object)"\u001aB\u0005Z\u000fS\u001e");
        stringArray[3] = BaseModel.m_cj((Object)"?7?)3(");
        stringArray[4] = SetValueRequest.m_cj((Object)"\tB\u000fQ\u001eU\u000er\u0013");
        stringArray[5] = BaseModel.m_cj((Object)"=);:*215\u001a:*>");
        stringArray[6] = SetValueRequest.m_cj((Object)"\\\u000bC\u001e}\u0005T\u0003V\u0003U\u000er\u0013");
        stringArray[7] = BaseModel.m_cj((Object)"2:-/\u00134:282;?\u001a:*>");
        F = stringArray;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_da(Integer a) {
        c_lha a2;
        if ((a = a2.k.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    @DisableSpaceFilter
    public Collection<AlarmGroup> m_ki(Set<Integer> a) {
        c_lha a2;
        if ((a = a2.k.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    private /* synthetic */ void m_khc(AlarmGroup a, AlarmGroup a2, boolean a3) {
        c_lha a4;
        AlarmGroup alarmGroup = a2;
        a4.m_kqc(a);
        BeanUtils.copyProperties((Object)a, (Object)alarmGroup, (String[])F);
        a4.m_wgc(alarmGroup);
        if (a3) {
            a4.D.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a4, a2));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_smc(List<Integer> a2) {
        c_lha a3;
        if (!(a2 = a3.k.findAllById(a2)).isEmpty()) {
            c_lha c_lha2 = a3;
            List list = a2;
            c_lha2.k.deleteInBatch((Iterable)list);
            list.forEach(a -> {
                c_lha a2;
                Set set = a.getAlarms();
                if (!set.isEmpty()) {
                    throw new c_rc("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
                }
                a2.D.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, a));
            });
        }
    }

    public void m_clc(AlarmGroup a) {
        c_lha a2;
        c_lha c_lha2 = a2;
        c_lha2.m_kqc(a);
        c_lha2.m_wgc(a);
    }
}

