/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.model.AnalogAlarm;
import com.inscada.mono.alarm.model.DigitalAlarm;
import com.inscada.mono.alarm.repositories.AlarmRepository;
import com.inscada.mono.alarm.services.c_lha;
import com.inscada.mono.c_bja;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_hba;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.g.c_kf;
import com.inscada.mono.settings.restcontrollers.BroadcastSettingsController;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_bh;
import com.inscada.mono.shared.exceptions.c_km;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_dha<T extends Alarm> {
    protected static final String[] i;
    protected final c_lha d;
    protected final AlarmRepository<T> k;
    protected final ApplicationEventPublisher D;
    protected final c_hba F;
    protected final c_kf G;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_af(Integer a, String a2) {
        c_dha a3;
        return (T)a3.k.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_yka(Pageable a) {
        c_dha a2;
        return a2.k.findAll(a);
    }

    protected void m_dhc(T a) {
        Variable variable;
        c_dha a2;
        if (a.getProject() == null) {
            T t = a;
            t.setProject(a2.G.m_lj(t.getProjectId()));
        }
        if (a.getGroup() == null) {
            T t = a;
            t.setGroup(a2.d.m_lj(t.getGroupId()));
        }
        if (a.getOnTimeVariable() == null && a.getOnTimeVariableId() != null) {
            variable = a2.F.m_lj(a.getOnTimeVariableId());
            a.setOnTimeVariable(variable);
        }
        if (a.getOffTimeVariable() == null && a.getOffTimeVariableId() != null) {
            variable = a2.F.m_lj(a.getOffTimeVariableId());
            a.setOffTimeVariable(variable);
        }
        if (a instanceof DigitalAlarm) {
            Variable variable2;
            variable = (DigitalAlarm)a;
            if (variable.getVariableA() == null) {
                variable2 = a2.F.m_lj(variable.getVariableAId());
                variable.setVariableA(variable2);
            }
            if (variable.getVariableB() == null && variable.getVariableBId() != null) {
                variable2 = a2.F.m_lj(variable.getVariableBId());
                variable.setVariableB(variable2);
                return;
            }
        } else if (a instanceof AnalogAlarm && (variable = (AnalogAlarm)a).getVariable() == null) {
            Variable variable3 = a2.F.m_lj(variable.getVariableId());
            variable.setVariable(variable3);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_aa(Integer a) {
        c_dha a2;
        return (T)((Alarm)a2.k.findById((Object)a).orElse(null));
    }

    protected c_dha(c_kf a, c_lha a2, AlarmRepository<T> a3, c_hba a4, ApplicationEventPublisher a5) {
        c_dha a6;
        c_dha c_dha2 = a6;
        c_dha c_dha3 = a6;
        a6.G = a;
        c_dha3.d = a2;
        c_dha3.k = a3;
        c_dha2.F = a4;
        c_dha2.D = a5;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_ujc(Collection<Integer> a) {
        c_dha a2;
        return a2.k.findAllById(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM')")
    public T m_ggc(T a) {
        c_dha a2;
        c_dha c_dha2 = a2;
        c_dha2.m_eqc(a);
        a = (Alarm)c_dha2.k.save(a);
        a2.D.publishEvent((ApplicationEvent)new AlarmAddEvent((Object)a2, a));
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_da(Integer a) {
        c_dha a2;
        return a2.k.findByProjectId(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM')")
    public void m_pmc(Integer a, T a2) {
        c_dha a3;
        c_dha c_dha2 = a3;
        a = c_dha2.m_lj(a);
        c_dha2.m_tlc(a2, (Alarm)a, true);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_glc(T a, boolean a2) {
        Alarm alarm;
        c_dha a3;
        T t = a;
        a3.m_dhc(t);
        if ((t.getId() != null ? (alarm = a3.m_aa(a.getId())) : (alarm = a3.m_af(a.getProjectId(), a.getName()))) != null) {
            a3.m_tlc(a, alarm, a2);
            return;
        }
        c_dha c_dha2 = a3;
        c_dha2.m_ckc(a);
        c_dha2.k.save(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_epc(AlarmFilter a, Pageable a2) {
        c_dha a3;
        return a3.k.findAlarmsByFilter(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_wjc(Integer a, String a2) {
        c_dha a3;
        return a3.k.findByGroupName(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_kq(List<T> a2, boolean a3) {
        c_dha a4;
        a2.forEach(arg_0 -> a4.m_dhc(arg_0));
        Object object = a2.stream().map(Alarm::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.k.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Alarm::getProjectId, Collectors.mapping(Alarm::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_dha a2;
            return a2.k.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Alarm::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Alarm> arrayList = new ArrayList<Alarm>();
        HashSet<Alarm> hashSet = new HashSet<Alarm>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Alarm alarm = (Alarm)a2.next();
            if ((alarm.getId() != null ? (Alarm)map.get(alarm.getId()) : (Alarm)object.get(ImmutablePair.of((Object)alarm.getProjectId(), (Object)alarm.getName()))) != null) {
                Alarm alarm2;
                Alarm alarm3 = alarm2;
                a4.m_tlc(alarm, alarm3, false);
                hashSet.add(alarm3);
                arrayList.add(alarm2);
                continue;
            }
            a4.m_ckc(alarm);
            arrayList.add(alarm);
        }
        a4.k.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_dha a2;
                a2.D.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a2, a));
            });
        }
    }

    @Order(value=3)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_vm(ProjectDeleteEvent a) {
        c_dha a2;
        a2.m_ha(a.getProject().getId());
    }

    protected void m_ckc(T a) {
        AnalogAlarm analogAlarm;
        if (!a.getGroup().getProject().equals((Object)a.getProject())) {
            throw new c_km(BroadcastSettingsController.m_cj((Object)"\u000f\u0004/\u001a#H)\u001a!\u001d>H>\u001a!\u0002+\u000b:H/\u0006*H/\u0004/\u001a#H>\u001a!\u0002+\u000b:H#\u001d=\u001cn\u0005/\u001c-\u0000"));
        }
        if (a.getOnTimeVariable() != null && !a.getOnTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_km(c_bja.m_cj((Object)": \u001a>\u0016l\u000b>\u0014&\u001e/\u000fl\u001a\"\u001fl\r-\t%\u001a.\u0017)[<\t#\u0011)\u00188[!\u000e?\u000fl\u0016-\u000f/\u0013"));
        }
        if (a.getOffTimeVariable() != null && !a.getOffTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_km(BroadcastSettingsController.m_cj((Object)")\"\t<\u0005n\u0018<\u0007$\r-\u001cn\t \fn\u001e/\u001a'\t,\u0004+H>\u001a!\u0002+\u000b:H#\u001d=\u001cn\u0005/\u001c-\u0000"));
        }
        if (a instanceof DigitalAlarm) {
            DigitalAlarm digitalAlarm = (DigitalAlarm)a;
            if (!digitalAlarm.getVariableA().getProject().equals((Object)a.getProject())) {
                throw new c_km(c_bja.m_cj((Object)": \u001a>\u0016l\u000b>\u0014&\u001e/\u000fl\u001a\"\u001fl\r-\t%\u001a.\u0017)[<\t#\u0011)\u00188[!\u000e?\u000fl\u0016-\u000f/\u0013"));
            }
            if (digitalAlarm.getVariableB() != null && !digitalAlarm.getVariableB().getProject().equals((Object)a.getProject())) {
                throw new c_km(BroadcastSettingsController.m_cj((Object)")\"\t<\u0005n\u0018<\u0007$\r-\u001cn\t \fn\u001e/\u001a'\t,\u0004+H>\u001a!\u0002+\u000b:H#\u001d=\u001cn\u0005/\u001c-\u0000"));
            }
        } else if (a instanceof AnalogAlarm && !(analogAlarm = (AnalogAlarm)a).getVariable().getProject().equals((Object)a.getProject())) {
            throw new c_km(c_bja.m_cj((Object)": \u001a>\u0016l\u000b>\u0014&\u001e/\u000fl\u001a\"\u001fl\r-\t%\u001a.\u0017)[<\t#\u0011)\u00188[!\u000e?\u000fl\u0016-\u000f/\u0013"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_rh(Integer a, String a2) {
        c_dha a3;
        Alarm alarm = a3.m_af(a, a2);
        if (alarm == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_bh(String.format(BroadcastSettingsController.m_cj((Object)")\"\t<\u0005n\u0006!\u001cn\u000e!\u001d \ftH>\u001a!\u0002+\u000b:H'\ftHk\fbH \t#\rtHk\u001b"), objectArray));
        }
        return (T)alarm;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_cic(Integer a) {
        c_dha a2;
        return a2.k.findByGroupIdAndIsActiveTrue(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_tic(Integer a, String[] a2) {
        c_dha a3;
        return a3.k.findByProjectIdAndNameIn(a, Arrays.stream(a2).collect(Collectors.toSet()));
    }

    private /* synthetic */ void m_tlc(T a, T a2, boolean a3) {
        c_dha a4;
        if (!a.getClass().equals(a2.getClass())) {
            throw new c_km(c_bja.m_cj((Object)"\r\u0017-\t![8\u0002<\u001e?[?\u0013#\u000e \u001fl\u0019)[?\u001a!\u001e"));
        }
        T t = a2;
        a4.m_dhc(a);
        BeanUtils.copyProperties(a, t, (String[])i);
        a4.m_ckc(t);
        if (a3) {
            a4.D.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a4, a2));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_ha(Integer a) {
        if (a != null) {
            c_dha a2;
            a2.k.deleteByProjectId(a);
        }
    }

    public void m_eqc(T a) {
        c_dha a2;
        c_dha c_dha2 = a2;
        c_dha2.m_dhc(a);
        c_dha2.m_ckc(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_ia(Integer a) {
        c_dha a2;
        if ((a = a2.m_aa(a)) != null) {
            c_dha c_dha2 = a2;
            c_dha2.k.delete((Object)a);
            c_dha2.D.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, (Alarm)a));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_tkc(List<Integer> a2) {
        c_dha a3;
        c_dha c_dha2 = a3;
        a2 = c_dha2.m_ujc(a2);
        c_dha2.k.deleteInBatch(a2);
        a2.forEach(a -> {
            c_dha a2;
            a2.D.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_uua(Integer a, Pageable a2) {
        c_dha a3;
        return a3.k.findByProjectId(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_va() {
        c_dha a;
        return a.k.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_lj(Integer a) {
        c_dha a2;
        Alarm alarm = a2.m_aa(a);
        if (alarm == null) {
            throw new c_bh("Alarm not found with id of " + a);
        }
        return (T)alarm;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<String> m_ykc(Integer a) {
        c_dha a2;
        return a2.k.findDistinctPartsByProjectId(a);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = BroadcastSettingsController.m_cj((Object)"'\f");
        stringArray[1] = c_bja.m_cj((Object)"\b<\u001a/\u001e");
        stringArray[2] = BroadcastSettingsController.m_cj((Object)"\u0018<\u0007$\r-\u001c");
        stringArray[3] = c_bja.m_cj((Object)"\u001c>\u00149\u000b");
        stringArray[4] = BroadcastSettingsController.m_cj((Object)"\u000b<\r/\u001c+\f\f\u0011");
        stringArray[5] = c_bja.m_cj((Object)"/\t)\u001a8\u0012#\u0015\b\u001a8\u001e");
        stringArray[6] = BroadcastSettingsController.m_cj((Object)"\"\t=\u001c\u0003\u0007*\u0001(\u0001+\f\f\u0011");
        stringArray[7] = c_bja.m_cj((Object)" \u001a?\u000f\u0001\u0014(\u0012*\u0012)\u001f\b\u001a8\u001e");
        i = stringArray;
    }
}

