/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.g.c_mba;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.c_fha;
import com.inscada.mono.alarm.services.c_kba;
import com.inscada.mono.alarm.services.c_lha;
import com.inscada.mono.alarm.services.c_mga;
import com.inscada.mono.auth.c_kka;
import com.inscada.mono.cluster.g.c_xga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_t;
import com.inscada.mono.communication.base.model.FrameSummary;
import com.inscada.mono.job.model.JobDto;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_al;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener {
    private final c_fha C;
    public static final short B = 107;
    private static final String L = "activeAlarmGroups";
    public static final short M = 106;
    private final c_t J;
    public static final short m = 104;
    private final c_lha j;
    private final JedisPooled f;
    public static final short H = 108;
    private final c_kba h;
    public static final short c = 101;
    public static final short A = 102;
    private final Lock i;
    private final c_ye d;
    public static final short k = 105;
    public static final short D = 103;
    private static final Logger F = LoggerFactory.getLogger(AlarmManager.class);
    public static final short G = 109;

    @TransactionalEventListener(value={AlarmGroupChangeEvent.class})
    public void handleAlarmGroupChangeEvent(AlarmGroupChangeEvent a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.info(FrameSummary.m_cj((Object)"=\r0\f4\u001aKh9)\u001f,\u001d!\u001f/Q\t\u001d)\u0003%6:\u001e=\u0001\u000b\u0019)\u001f/\u0014\r\u0007-\u001f<Q.\u001e:Q/\u0003'\u00048Q\u00015rQ3\f"), (Object)a.getAlarmGroup().getId());
            a2.i.lock();
            try {
                Integer n = a.getAlarmGroup().getId();
                if (a2.getAlarmGroupStatusInternal(n) == c_mba.G) {
                    AlarmManager alarmManager = a2;
                    alarmManager.deactivateAlarmGroupInternal(n);
                    alarmManager.activateAlarmGroupInternal(n);
                }
                return;
            }
            finally {
                a2.i.unlock();
            }
        }
        F.debug(JobDto.m_cj((Object)"\u0017f\u0017\u0004\u0015l\u0018m\u001c{c\t\u0010N7F+@7Nyh5H+D\u001e[6\\)j1H7N<l/L7]yO6[yN+F,Yy`\u001d\u0013yR$"), (Object)a.getAlarmGroup().getId());
    }

    protected c_mba getAlarmStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmStatusInternal(alarmManager.h.m_aa(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        String string = alarmManager.J.m_wa().getNodeId();
        F.info(FrameSummary.m_cj((Object)"\t\u001d)\u0003%<)\u001f)\u0016-\u0003rQ\u001c\u0019!\u0002h\u001f'\u0015-Q`\n5Xh\u0019)\u0002h\u0013-\u0012'\u001c-Q<\u0019-Q\u00044\t5\r#fQ\u001a\u0014;\u0005'\u0003!\u001f/Q)\u0012<\u0018>\u0014h\u0010$\u0010:\u001c;_f_"), (Object)string);
        alarmManager.i.lock();
        try {
            Set set = a2.f.smembers(L).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                F.info(JobDto.m_cj((Object)"\u0018E8[4d8G8N<[y\u0001\u0015L8M<[yR$\u0000c\t\u0017FyH:]0_<\t8E8[4\t>[6\\)ZyO6\\7My@7\t\u000bL=@*\t-Fy[<Z-F+Lw"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            F.info(FrameSummary.m_cj((Object)"0$\u0010:\u001c\u0005\u0010&\u0010/\u0014:Q`=-\u0010,\u0014:Q3\faKh7'\u0004&\u0015h\n5Q)\u0012<\u0018>\u0014h\u0010$\u0010:\u001ch\u0016:\u001e=\u0001h8\f\u0002h\u0018&Q\u001a\u0014,\u0018;Q<\u001eh\u0003-\u0002<\u001e:\u0014rQ3\f"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = JobDto.m_cj((Object)"\u007f\u0010l\u000ev\u0018e\u0018{\u0014v\u001e{\u0016|\t");
            c_kka.m_rub(() -> {
                AlarmManager a3;
                arrayList.addAll(a3.j.m_ki(set));
            }, (String[])stringArray);
            F.info(FrameSummary.m_cj((Object)"\t\u001d)\u0003%<)\u001f)\u0016-\u0003hY\u0004\u0014)\u0015-\u0003h\n5XrQ\t\u0005<\u0014%\u0001<\u0018&\u0016h\u0005'Q:\u0014;\u0005'\u0003-Q3\fh\u0010$\u0010:\u001ch\u0016:\u001e=\u0001;_"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                AlarmManager a2;
                AlarmManager alarmManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = FrameSummary.m_cj((Object)"\t2\u001c8\u001e0\u001c4\u00170\u00040\u001a<");
                stringArray[1] = JobDto.m_cj((Object)"m\u001ch\u001a}\u0010\u007f\u0018}\u001cv\u0018e\u0018{\u0014");
                c_kka.m_lub(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1(alarmManager.J.m_wa().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            F.info(JobDto.m_cj((Object)"\u0018E8[4d8G8N<[y\u0001\u0015L8M<[yR$\u0000c\t\u001f@7@*A<MyH5H+Dy[<Z-F+H-@6GyY+F:L*Zw"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            F.error(FrameSummary.m_cj((Object)"\t\u001d)\u0003%<)\u001f)\u0016-\u0003hY\u0004\u0014)\u0015-\u0003h\n5XrQ\r\u0003:\u001e:Q,\u0004:\u0018&\u0016h\u0010$\u0010:\u001ch\u0003-\u0002<\u001e:\u0010<\u0018'\u001fh\u0001:\u001e+\u0014;\u0002rQ3\f"), objectArray);
            return;
        }
        finally {
            a2.i.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(JobDto.m_cj((Object)"e\u001ch\u001dl\u000b\u0013ym<H:]0_8]0G>\t8E8[4\t>[6\\)\t\"TyE6J8E5Pw"), (Object)a);
            a2.deactivateAlarmGroupInternal(a);
            return;
        }
        F.debug(FrameSummary.m_cj((Object)"?\u0007?e=\r0\f4\u001aKh#-\u0000=\u0014;\u0005!\u001f/Q$\u0014)\u0015-\u0003h\u0005'Q,\u0014)\u0012<\u0018>\u0010<\u0014h\u0010$\u0010:\u001ch\u0016:\u001e=\u0001h\n5_"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)102), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC deactivate alarm group " + a, (Throwable)exception);
        }
    }

    protected c_mba getAlarmGroupStatusInternal(AlarmGroup a) {
        AlarmManager a2;
        if (a == null) {
            return c_mba.F;
        }
        if ((a = a2.C.m_pkc(a.getId())) != null && a.m_umc()) {
            return c_mba.G;
        }
        return c_mba.F;
    }

    protected void deactivateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.j.m_lj(a));
    }

    protected c_mba getAlarmGroupStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmGroupStatusInternal(alarmManager.j.m_aa(a));
    }

    public AlarmManager(c_kba a, c_lha a2, c_fha a3, c_ye a4, JedisPooled a5, c_t a6) {
        AlarmManager a7;
        AlarmManager alarmManager = a7;
        AlarmManager alarmManager2 = a7;
        AlarmManager alarmManager3 = a7;
        AlarmManager alarmManager4 = a7;
        alarmManager4.i = new ReentrantLock();
        alarmManager3.h = a;
        alarmManager3.j = a2;
        alarmManager2.C = a3;
        alarmManager2.d = a4;
        alarmManager.f = a5;
        alarmManager.J = a6;
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(JobDto.m_cj((Object)"\u0015l\u0018m\u001c{c\t\u0018J-@/H-@7NyH5EyH5H+DyN+F,Y*\t?F+\t)[6C<J-\t\"TyE6J8E5Pw"), (Object)a);
            a2.activateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        F.debug(FrameSummary.m_cj((Object)"\u0006>\u0006\\\u00044\t5\r#rQ\u001a\u00149\u0004-\u0002<\u0018&\u0016h\u001d-\u0010,\u0014:Q<\u001eh\u0010+\u0005!\u0007)\u0005-Q)\u001d$Q)\u001d)\u0003%Q/\u0003'\u00048\u0002h\u0017'\u0003h\u0001:\u001e\"\u0014+\u0005h\n5_"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)108), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC activate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_mba getAlarmStatus(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(JobDto.m_cj((Object)"e\u001ch\u001dl\u000b\u0013yn<]-@7NyH5H+DyZ-H-\\*\t?F+\t\"TyE6J8E5Pw"), (Object)a);
            return a2.getAlarmStatusInternal(a);
        }
        F.debug(FrameSummary.m_cj((Object)"\u0006>\u0006\\\u00044\t5\r#rQ\u001a\u00149\u0004-\u0002<\u0018&\u0016h\u001d-\u0010,\u0014:Q.\u001e:Q)\u001d)\u0003%Q;\u0005)\u0005=\u0002h\u0017'\u0003h\n5_"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_mba)a2.J.m_ib(Short.valueOf((short)103), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get alarm status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_mba getAlarmStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.h.m_af(a, a2)) == null) {
            return c_mba.F;
        }
        return a3.getAlarmStatus(a.getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.J.m_sa((ClusterNodeListener)a);
        F.info(JobDto.m_cj((Object)"\u0018E8[4d8G8N<[y@7@-@8E0S<MyH7My[<N0Z-L+L=\t8Zyj5\\*]<[\u0017F=L\u0015@*]<G<[w"));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            AlarmManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.J.m_qb((short)101, (Object)a, AlarmManager.class.getDeclaredMethod(FrameSummary.m_cj((Object)")\u0012<\u0018>\u0010<\u0014\t\u001d)\u0003%6:\u001e=\u0001\u0001\u001f<\u0014:\u001f)\u001d"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.J.m_qb((short)102, (Object)a, AlarmManager.class.getDeclaredMethod(JobDto.m_cj((Object)"M<H:]0_8]<h5H+D\u001e[6\\)`7]<[7H5"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.J.m_qb((short)103, (Object)a, AlarmManager.class.getDeclaredMethod(FrameSummary.m_cj((Object)"/\u0014<0$\u0010:\u001c\u001b\u0005)\u0005=\u0002\u0001\u001f<\u0014:\u001f)\u001d"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.J.m_qb((short)104, (Object)a, AlarmManager.class.getDeclaredMethod(JobDto.m_cj((Object)">L-h5H+D\u001e[6\\)z-H-\\*`7]<[7H5"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.J.m_qb((short)105, (Object)a, AlarmManager.class.getDeclaredMethod(FrameSummary.m_cj((Object)"\u0016-\u0005\t\u001d)\u0003%\"<\u0010<\u0004;\u0014;31!:\u001e\"\u0014+\u0005\u0001\u0015\u0001\u001f<\u0014:\u001f)\u001d"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.J.m_qb((short)106, (Object)a, AlarmManager.class.getDeclaredMethod(JobDto.m_cj((Object)"N<]\u0018E8[4n+F,Y\n]8],Z<Z\u001bP\t[6C<J-`=`7]<[7H5"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            a.J.m_qb((short)107, (Object)a, AlarmManager.class.getDeclaredMethod(FrameSummary.m_cj((Object)"/\u0014<0$\u0010:\u001c\u001b\u0005)\u0005=\u0002-\u0002\u0001\u001f<\u0014:\u001f)\u001d"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.J.m_qb((short)108, (Object)a, AlarmManager.class.getDeclaredMethod(JobDto.m_cj((Object)"H:]0_8]<h5H+D\u001e[6\\)Z\u001bP\t[6C<J-`=`7]<[7H5"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer.class;
            a.J.m_qb((short)109, (Object)a, AlarmManager.class.getDeclaredMethod(FrameSummary.m_cj((Object)",\u0014)\u0012<\u0018>\u0010<\u0014\t\u001d)\u0003%6:\u001e=\u0001;31!:\u001e\"\u0014+\u0005\u0001\u0015\u0001\u001f<\u0014:\u001f)\u001d"), classArray9));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(JobDto.m_cj((Object)"\u001fH0E<My]6\t+L>@*]<[yh5H+D\u0014H7H>L+\t\u000by\u001a\t4L-A6M*"), noSuchMethodException);
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_kka.m_vbc(() -> {
            AlarmManager a2;
            a2.i.lock();
            try {
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_al("Project should be active to start alarm group " + a.getName());
                }
                c_mga c_mga2 = a2.C.m_ufc(a);
                c_mga2.m_mb();
                if (c_mga2.m_umc()) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a.getId().toString();
                    a2.f.sadd(L, stringArray);
                }
                return;
            }
            finally {
                a2.i.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @TransactionalEventListener(value={AlarmDeleteEvent.class})
    public void handleAlarmDeleteEvent(AlarmDeleteEvent a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            Alarm alarm = a.getAlarm();
            F.info(FrameSummary.m_cj((Object)"\u00044\t5\r#rQ\u0000\u0010&\u0015$\u0018&\u0016h0$\u0010:\u001c\f\u0014$\u0014<\u0014\r\u0007-\u001f<Q.\u001e:Q)\u001d)\u0003%Q\u00015rQ3\fdQ\u000f\u0003'\u00048Q\u00015rQ3\f"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_mga c_mga2 = a2.C.m_pkc(alarm.getGroupId());
            if (c_mga2 != null && c_mga2.m_umc()) {
                c_mga2.m_xkc(alarm);
                return;
            }
        } else {
            F.debug(JobDto.m_cj((Object)"g\u0016gte\u001ch\u001dl\u000b\u0013y`>G6[0G>\t\u0018E8[4m<E<]<l/L7]yO6[yH5H+Dy`\u001d\u0013yR$"), (Object)a.getAlarm().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_mba> getAlarmGroupStatuses(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(FrameSummary.m_cj((Object)"\u00044\t5\r#rQ\u000f\u0014<\u0005!\u001f/Q)\u001d$Q)\u001d)\u0003%Q/\u0003'\u00048Q;\u0005)\u0005=\u0002-\u0002h\u0017'\u0003h\u0001:\u001e\"\u0014+\u0005h\n5Q$\u001e+\u0010$\u001d1_"), (Object)a);
            return a2.getAlarmGroupStatusesByProjectIdInternal(a);
        }
        F.debug(JobDto.m_cj((Object)"g\u0016gte\u001ch\u001dl\u000b\u0013y{<X,L*]0G>\t5L8M<[yO6[yH5EyH5H+DyN+F,YyZ-H-\\*L*\t?F+\t)[6C<J-\t\"Tw"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.J.m_ib(Short.valueOf((short)106), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get alarm group statuses for project " + a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.j.m_da((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(FrameSummary.m_cj((Object)"\u00044\t5\r#rQ\t\u0012<\u0018>\u0010<\u0018&\u0016h\u0010$\u0010:\u001ch\u0016:\u001e=\u0001h\n5Q$\u001e+\u0010$\u001d1_"), (Object)a);
            a2.activateAlarmGroupInternal(a);
            return;
        }
        F.debug(JobDto.m_cj((Object)"\u0017f\u0017\u0004\u0015l\u0018m\u001c{c\t\u000bL(\\<Z-@7NyE<H=L+\t-FyH:]0_8]<\t8E8[4\t>[6\\)\t\"Tw"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)101), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC activate alarm group " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmGroupDeleteEvent.class})
    public void handleAlarmGroupDeleteEvent(AlarmGroupDeleteEvent a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.info(FrameSummary.m_cj((Object)"=\r0\f4\u001aKh9)\u001f,\u001d!\u001f/Q\t\u001d)\u0003%6:\u001e=\u0001\f\u0014$\u0014<\u0014\r\u0007-\u001f<Q.\u001e:Q/\u0003'\u00048Q\u00015rQ3\f"), (Object)a.getAlarmGroup().getId());
            a2.deactivateAlarmGroupInternal(a.getAlarmGroup().getId());
            return;
        }
        F.debug(JobDto.m_cj((Object)"\u0017f\u0017\u0004\u0015l\u0018m\u001c{c\t\u0010N7F+@7Nyh5H+D\u001e[6\\)m<E<]<l/L7]yO6[yN+F,Yy`\u001d\u0013yR$"), (Object)a.getAlarmGroup().getId());
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_kka.m_vbc(() -> {
            AlarmManager a2;
            a2.i.lock();
            try {
                c_mga c_mga2 = a2.C.m_pkc(a.getId());
                if (c_mga2 != null) {
                    c_mga2.m_pgb();
                    a2.C.m_qfc(a.getId(), c_mga2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.f.srem(L, stringArray);
                return;
            }
            finally {
                a2.i.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected Map<Integer, c_mba> getAlarmGroupStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.j.m_da((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroup::getId, arg_0 -> a2.getAlarmGroupStatusInternal(arg_0)));
    }

    @TransactionalEventListener(value={AlarmChangeEvent.class})
    public void handleAlarmChangeEvent(AlarmChangeEvent a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            Alarm alarm = a.getAlarm();
            F.info(FrameSummary.m_cj((Object)"\u00044\t5\r#rQ\u0000\u0010&\u0015$\u0018&\u0016h0$\u0010:\u001c\u000b\u0019)\u001f/\u0014\r\u0007-\u001f<Q.\u001e:Q)\u001d)\u0003%Q\u00015rQ3\fdQ\u000f\u0003'\u00048Q\u00015rQ3\f"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_mga c_mga2 = a2.C.m_pkc(alarm.getGroupId());
            if (c_mga2 != null && c_mga2.m_umc()) {
                if (Boolean.TRUE.equals(alarm.getIsActive())) {
                    c_mga2.m_vjc(alarm);
                    return;
                }
                c_mga2.m_xkc(alarm);
                return;
            }
        } else {
            F.debug(JobDto.m_cj((Object)"g\u0016gte\u001ch\u001dl\u000b\u0013y`>G6[0G>\t\u0018E8[4j1H7N<l/L7]yO6[yH5H+Dy`\u001d\u0013yR$"), (Object)a.getAlarm().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.deactivateAlarmGroup(alarmManager.j.m_rh(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_mba> getAlarmStatuses(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(FrameSummary.m_cj((Object)"\u00044\t5\r#rQ\u000f\u0014<\u0005!\u001f/Q)\u001d$Q)\u001d)\u0003%Q;\u0005)\u0005=\u0002-\u0002h\u0017'\u0003h\u0001:\u001e\"\u0014+\u0005h\n5Q$\u001e+\u0010$\u001d1_"), (Object)a);
            return a2.getAlarmStatusesByProjectIdInternal(a);
        }
        F.debug(JobDto.m_cj((Object)"g\u0016gte\u001ch\u001dl\u000b\u0013y{<X,L*]0G>\t5L8M<[yO6[yH5EyH5H+DyZ-H-\\*L*\t?F+\t)[6C<J-\t\"Tw"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.J.m_ib(Short.valueOf((short)105), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get alarm statuses for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmAddEvent.class})
    public void handleAlarmAddEvent(AlarmAddEvent a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            c_mga c_mga2;
            Alarm alarm = a.getAlarm();
            F.info(FrameSummary.m_cj((Object)"=\r0\f4\u001aKh9)\u001f,\u001d!\u001f/Q\t\u001d)\u0003%0,\u0015\r\u0007-\u001f<Q.\u001e:Q)\u001d)\u0003%Q\u00015rQ3\fdQ\u000f\u0003'\u00048Q\u00015rQ3\f"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            if (Boolean.TRUE.equals(alarm.getIsActive()) && (c_mga2 = a2.C.m_pkc(alarm.getGroupId())) != null && c_mga2.m_umc()) {
                c_mga2.m_vjc(alarm);
                return;
            }
        } else {
            F.debug(JobDto.m_cj((Object)"\u0017f\u0017\u0004\u0015l\u0018m\u001c{c\t\u0010N7F+@7Nyh5H+D\u0018M=l/L7]yO6[yH5H+Dy`\u001d\u0013yR$"), (Object)a.getAlarm().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.activateAlarmGroup(alarmManager.j.m_rh(a, a2).getId());
    }

    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String a, AlarmGroup a2) {
        AlarmManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            F.info(FrameSummary.m_cj((Object)"\t\u001d)\u0003%<)\u001f)\u0016-\u0003hY\u0004\u0014)\u0015-\u0003h\n5XrQ\u001a\u0014;\u0005'\u0003!\u001f/Q)\u001d)\u0003%Q/\u0003'\u00048Kh\n5Q`8\fKh\n5X"), objectArray);
            a3.activateAlarmGroupInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.d.m_lia(a2.getProject()).m_z("Alarm Group Restore (Leader " + a + ")", String.format(JobDto.m_cj((Object)"\f*\tq`\u001d\u0013y\f=\u0000yO8@5L=\t-Fy[<Z-F+Lw\t\u001aH,Z<\u0013y\f*"), objectArray));
            try {
                F.warn(FrameSummary.m_cj((Object)"\t\u001d)\u0003%<)\u001f)\u0016-\u0003hY\u0004\u0014)\u0015-\u0003h\n5XrQ\t\u0005<\u0014%\u0001<\u0018&\u0016h\u0005'Q,\u0014)\u0012<\u0018>\u0010<\u0014h\u0010$\u0010:\u001ch\u0016:\u001e=\u0001h\n5Q)\u0017<\u0014:Q:\u0014;\u0005'\u0003)\u0005!\u001e&Q.\u0010!\u001d=\u0003-_"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                F.error(JobDto.m_cj((Object)"\u0018E8[4d8G8N<[y\u0001\u0015L8M<[yR$\u0000c\t\u001fH0E<My]6\t=L8J-@/H-LyH5H+DyN+F,YyR$\t8O-L+\t+L*]6[8]0F7\t?H0E,[<\u0013yR$"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_mba> getAlarmStatuses(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.J.m_rb()) {
            F.debug(FrameSummary.m_cj((Object)"=\r0\f4\u001aKh6-\u0005<\u0018&\u0016h\u0010$\u0010:\u001ch\u0002<\u0010<\u0004;\u0014;Q.\u001e:Q3\fh8\f\u0002h\u001d'\u0012)\u001d$\brQ3\f"), (Object)a.size(), a);
            return a2.getAlarmStatusesInternal(a);
        }
        F.debug(JobDto.m_cj((Object)"\u0017f\u0017\u0004\u0015l\u0018m\u001c{c\t\u000bL(\\<Z-@7NyE<H=L+\t?F+\t8E8[4\t*]8],Z<ZyO6[yR$\t\u0010m*\u0013yR$"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.J.m_ib(Short.valueOf((short)107), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get alarm statuses for IDs " + a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.j.m_da((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    protected Map<Integer, c_mba> getAlarmStatusesInternal(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.info(FrameSummary.m_cj((Object)"\u00044\t5\r#rQ\u0000\u0010&\u0015$\u0018&\u0016h!:\u001e\"\u0014+\u0005\f\u0014)\u0012<\u0018>\u0010<\u0014\r\u0007-\u001f<Q.\u001e:Q8\u0003'\u001b-\u0012<Q\u00015rQ3\f"), (Object)a.getProject().getId());
            a2.deactivateAlarmGroupsByProjectIdInternal(a.getProject().getId());
            return;
        }
        F.debug(JobDto.m_cj((Object)"g\u0016gte\u001ch\u001dl\u000b\u0013y`>G6[0G>\t\t[6C<J-m<H:]0_8]<l/L7]yO6[yY+F3L:]y`\u001d\u0013yR$"), (Object)a.getProject().getId());
    }

    protected c_mba getAlarmStatusInternal(Alarm a) {
        AlarmManager a2;
        if (a == null) {
            return c_mba.F;
        }
        c_mga c_mga2 = a2.C.m_pkc(a.getGroup().getId());
        if (c_mga2 != null && c_mga2.m_umc() && c_mga2.m_xmc(a.getId())) {
            return c_mba.G;
        }
        return c_mba.F;
    }

    protected void activateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.activateAlarmGroupInternal(alarmManager.j.m_lj(a));
    }

    protected Map<Integer, c_mba> getAlarmStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.h.m_da((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Alarm::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(FrameSummary.m_cj((Object)"=\r0\f4\u001aKh5-\u0010+\u0005!\u0007)\u0005!\u001f/Q)\u001d$Q)\u001d)\u0003%Q/\u0003'\u00048\u0002h\u0017'\u0003h\u0001:\u001e\"\u0014+\u0005h\n5Q$\u001e+\u0010$\u001d1_"), (Object)a);
            a2.deactivateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        F.debug(JobDto.m_cj((Object)"g\u0016gte\u001ch\u001dl\u000b\u0013y{<X,L*]0G>\t5L8M<[y]6\t=L8J-@/H-LyH5EyH5H+DyN+F,Y*\t?F+\t)[6C<J-\t\"Tw"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.m_ib(Short.valueOf((short)109), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC deactivate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_mba getAlarmGroupStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.j.m_af(a, a2)) == null) {
            return c_mba.F;
        }
        return a3.getAlarmGroupStatus(a.getId());
    }

    public void notLeader() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        String string = alarmManager.J.m_wa().getNodeId();
        F.info(FrameSummary.m_cj((Object)"\t\u001d)\u0003%<)\u001f)\u0016-\u0003rQ\u001c\u0019!\u0002h\u001f'\u0015-Q`\n5Xh\u0018;Q\u0006>h=\u0007?\u000f4\u001aQ\u001c9\rQ\u00044\t5\r#fQ\u001b\u0005'\u00018\u0018&\u0016h\u0010$\u001dh\u001d'\u0012)\u001dh\u0010$\u0010:\u001ch\u0018&\u00028\u0014+\u0005'\u0003;_f_"), (Object)string);
        alarmManager.i.lock();
        try {
            a.C.m_mhc();
            F.info(JobDto.m_cj((Object)"\u0018E8[4d8G8N<[y\u0001\u0017F-\t\u0015L8M<[yR$\u0000c\t\u0018E5\t5F:H5\t8E8[4\t0G*Y<J-@6Gy]8Z2ZyA8_<\t;L<Gy[<X,L*]<My]6\t*]6Yw"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            F.error(FrameSummary.m_cj((Object)"0$\u0010:\u001c\u0005\u0010&\u0010/\u0014:Q`?'\u0005h=-\u0010,\u0014:Q3\faKh4:\u0003'\u0003h\u0015=\u0003!\u001f/Q8\u0003'\u0012-\u0002;Q'\u0017h\u0002<\u001e8\u0001!\u001f/Q$\u001e+\u0010$Q)\u001d)\u0003%Q!\u001f;\u0001-\u0012<\u001e:\u0002rQ3\f"), objectArray);
            return;
        }
        finally {
            a.i.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_mba getAlarmGroupStatus(Integer a) {
        AlarmManager a2;
        if (a2.J.m_rb()) {
            F.debug(JobDto.m_cj((Object)"e\u001ch\u001dl\u000b\u0013yn<]-@7NyH5H+DyN+F,YyZ-H-\\*\t?F+\t\"TyE6J8E5Pw"), (Object)a);
            return a2.getAlarmGroupStatusInternal(a);
        }
        F.debug(FrameSummary.m_cj((Object)"\u0006>\u0006\\\u00044\t5\r#rQ\u001a\u00149\u0004-\u0002<\u0018&\u0016h\u001d-\u0010,\u0014:Q.\u001e:Q)\u001d)\u0003%Q/\u0003'\u00048Q;\u0005)\u0005=\u0002h\u0017'\u0003h\n5_"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_mba)a2.J.m_ib(Short.valueOf((short)104), objectArray);
        }
        catch (Exception exception) {
            throw new c_xga("Failed to RPC get alarm group status for " + a, (Throwable)exception);
        }
    }
}

