/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.g.c_mba;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_lha;
import com.inscada.mono.config.c_ul;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.g.c_kf;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/alarms/groups"})
public class AlarmGroupController
extends ProjectBasedImportExportController {
    private final c_lha F;
    private final AlarmManager G;

    @PostMapping(value={"/deactivate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.G.deactivateAlarmGroups(a);
    }

    @PostMapping(value={"/{groupId}/deactivate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.G.deactivateAlarmGroup(a);
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_mba> getAlarmGroupStatuses(@RequestParam(value="projectId") Integer a) {
        return this.G.getAlarmGroupStatuses(a);
    }

    @DeleteMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.F.m_ia(a);
    }

    @DeleteMapping(value={"/multi"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.F.m_smc(List.of(a));
    }

    @PostMapping(value={"/activate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.G.activateAlarmGroups(a);
    }

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_mba getAlarmGroupStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.G.getAlarmGroupStatus(projectId, a);
    }

    @PostMapping
    public ResponseEntity<AlarmGroup> createAlarmGroup(@Valid @RequestBody AlarmGroup alarmGroup, UriComponentsBuilder a) {
        alarmGroup = this.F.m_slc(alarmGroup);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarmGroup.getId();
        return ResponseEntity.created((URI)a.path(c_ul.m_cj((Object)"Dh\fa\u0004f\u001bZ\u000fn")).buildAndExpand(objectArray).toUri()).body((Object)alarmGroup);
    }

    @GetMapping(value={"/{groupId}"})
    public AlarmGroup getAlarmGroup(@PathVariable(value="groupId") Integer a) {
        return this.F.m_aa(a);
    }

    @PutMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarmGroup(@PathVariable(value="groupId") Integer groupId, @Valid @RequestBody AlarmGroup a) {
        this.F.m_ljc(groupId, a);
    }

    @PostMapping(value={"/deactivate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.G.deactivateAlarmGroup(projectId, a);
    }

    @PostMapping(value={"/activate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.G.activateAlarmGroup(projectId, a);
    }

    @GetMapping(value={"/{alarmGroupId}/status"})
    public c_mba getAlarmGroupStatus(@PathVariable(value="alarmGroupId") Integer a) {
        return this.G.getAlarmGroupStatus(a);
    }

    @GetMapping
    public Collection<AlarmGroup> getAlarmGroups(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.F.m_va();
        }
        return this.F.m_da(a);
    }

    public AlarmGroupController(c_lha a, AlarmManager a2, c_hh a3, c_kf a4) {
        AlarmGroupController a5;
        AlarmGroupController alarmGroupController = a5;
        super(a3, EnumSet.of(c_wk.S), a4);
        alarmGroupController.F = a;
        alarmGroupController.G = a2;
    }

    @PostMapping(value={"/{groupId}/activate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.G.activateAlarmGroup(a);
    }
}

