/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.g.c_mba;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_dha;
import com.inscada.mono.auth.services.c_kia;
import com.inscada.mono.impexp.i.c_hh;
import com.inscada.mono.impexp.l.c_wk;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.g.c_kf;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AlarmController<T extends Alarm>
extends ProjectBasedImportExportController {
    protected final AlarmManager F;
    protected final c_dha<T> G;

    @DeleteMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarm(@PathVariable(value="alarmId") Integer a) {
        this.G.m_ia(a);
    }

    @PostMapping
    public ResponseEntity<T> createAlarm(@Valid @RequestBody T alarm, UriComponentsBuilder a) {
        alarm = this.G.m_ggc(alarm);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarm.getId();
        return ResponseEntity.created((URI)a.path(c_kia.m_cj((Object)"Y\u001b\u0017\f\u0017\u0012\u001b)\u0012\u001d")).buildAndExpand(objectArray).toUri()).body(alarm);
    }

    @PostMapping(value={"/filter/pages"})
    public Page<T> getAlarmsByFilter(@Valid @RequestBody AlarmFilter alarmFilter, Pageable a) {
        return this.G.m_epc(alarmFilter, a);
    }

    @GetMapping(value={"/name"})
    public T getAlarmByName(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="alarmName") String a) {
        return (T)this.G.m_rh(projectId, a);
    }

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_mba getAlarmStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.F.getAlarmStatus(projectId, a);
    }

    @GetMapping(value={"/parts"})
    public Collection<String> getPartsByProjectId(@RequestParam(name="projectId") Integer a) {
        return this.G.m_ykc(a);
    }

    @DeleteMapping(value={"/multi"}, params={"alarmIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmsByIds(@RequestParam(value="alarmIds") Integer[] a) {
        this.G.m_tkc(List.of(a));
    }

    @GetMapping(params={"projectId", "groupName"})
    public Collection<T> getAlarmsByGroupId(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="groupName") String a) {
        return this.G.m_wjc(projectId, a);
    }

    @PutMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarm(@PathVariable(value="alarmId") Integer alarmId, @Valid @RequestBody T a) {
        this.G.m_pmc(alarmId, a);
    }

    @GetMapping(params={"projectId"})
    public Collection<T> getAlarms(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.G.m_va();
        }
        return this.G.m_da(a);
    }

    @GetMapping(value={"/{alarmId}/status"})
    public c_mba getAlarmStatus(@PathVariable(value="alarmId") Integer a) {
        return this.F.getAlarmStatus(a);
    }

    @GetMapping(value={"/pages"})
    public Page<T> getAlarmsByProjectId(@RequestParam(name="projectId", required=false) Integer projectId, Pageable a) {
        if (projectId == null) {
            return this.G.m_yka(a);
        }
        return this.G.m_uua(projectId, a);
    }

    protected AlarmController(c_dha<T> a, AlarmManager a2, c_hh a3, c_kf a4) {
        AlarmController a5;
        AlarmController alarmController = a5;
        super(a3, EnumSet.of(c_wk.A), a4);
        alarmController.G = a;
        alarmController.F = a2;
    }

    @GetMapping(value={"/status"}, params={"alarmIds"})
    public Map<Integer, c_mba> getAlarmStatuses(@RequestParam(value="alarmIds") Integer[] a) {
        return this.F.getAlarmStatuses(Arrays.asList(a));
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_mba> getAlarmStatuses(@RequestParam(value="projectId") Integer a) {
        return this.F.getAlarmStatuses(a);
    }

    @GetMapping(value={"/{alarmId}"})
    public T getAlarm(@PathVariable(value="alarmId") Integer a) {
        return (T)this.G.m_aa(a);
    }
}

