/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.restcontrollers;

import com.inscada.mono.communication.base.services.k.c_ve;
import com.inscada.mono.shared.w.c_dc;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.k.c_ja;
import com.inscada.mono.user.model.ResetPasswordToken;
import com.inscada.mono.user.model.Role;
import com.inscada.mono.user.model.User;
import com.inscada.mono.user.model.UserDto;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final c_ja g;

    @GetMapping(value={"/{userId}/spaces/{spaceId}"})
    public Space getSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        return this.g.m_jc(userId, a);
    }

    public UserController(c_ja a) {
        UserController a2;
        a2.g = a;
    }

    @GetMapping
    public Collection<User> getUsers() {
        UserController a;
        return a.g.m_aa();
    }

    @GetMapping(value={"/{userId}/spaces"})
    public Collection<Space> getSpaces(@PathVariable(value="userId") Integer a) {
        return this.g.m_bc(a);
    }

    @PutMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUser(@PathVariable(value="userId") Integer userId, @Valid @RequestBody User a) {
        this.g.m_tc(userId, a);
    }

    @GetMapping(value={"/{userId}"})
    public User getUser(@PathVariable(value="userId") Integer a) {
        return this.g.m_ya(a);
    }

    @DeleteMapping(value={""}, params={"userIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUsersByIds(@RequestParam(value="userIds") Integer[] a) {
        this.g.m_ed(List.of(a));
    }

    @DeleteMapping(value={"/{userId}/spaces/{spaceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        this.g.m_uc(userId, a);
    }

    @PostMapping(value={"/{userId}/spaces"})
    public ResponseEntity<Space> addSpace(@PathVariable(value="userId") Integer userId, @RequestBody Integer spaceId, UriComponentsBuilder a) {
        Space space = this.g.m_qc(userId, spaceId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = spaceId;
        return ResponseEntity.created((URI)a.path(c_dc.m_ck((Object)"%\u000f\u007f\u0007o\u0006C\u0010w[y\u0004k\u0017o\u0007%\u000fy\u0004k\u0017o=n\t")).buildAndExpand(objectArray).toUri()).body((Object)space);
    }

    @GetMapping(value={"/active-space"})
    public String[] getAllSpaceUsers() {
        UserController a;
        return a.g.m_hc();
    }

    @PostMapping(value={"/{username}/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetPassword(@PathVariable(value="username") String username, @Valid @RequestBody ResetPasswordToken a) {
        this.g.m_dj(username, a);
    }

    @PutMapping(value={"/ui-configs"})
    public void setUIConfigs(@RequestBody String value, Principal a) {
        this.g.m_sh(value, a.getName());
    }

    @PostMapping
    public ResponseEntity<User> createUser(@Valid @RequestBody UserDto userDto, UriComponentsBuilder a) {
        userDto = this.g.m_kc(userDto);
        Object[] objectArray = new Object[1];
        objectArray[0] = userDto.getId();
        return ResponseEntity.created((URI)a.path(c_ve.m_ck((Object)"\u0001\n[\u0002K\u0003g\u0015S")).buildAndExpand(objectArray).toUri()).body((Object)userDto);
    }

    @GetMapping(value={"/ui-configs"})
    public String getUIConfigs(Principal a) {
        UserController a2;
        return a2.g.m_cg(a.getName());
    }

    @GetMapping(value={"/{userId}/roles"})
    public Collection<Role> getRoles(@PathVariable(value="userId") Integer a) {
        return this.g.m_nc(a);
    }

    @GetMapping(value={"/{userId}/roles/{roleId}"})
    public Role getRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        return this.g.m_wc(userId, a);
    }

    @PutMapping(value={"/agree"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void acceptEula(Principal a) {
        UserController a2;
        a2.g.m_tl(a.getName());
    }

    @PostMapping(value={"/{userId}/roles"})
    public ResponseEntity<Role> addRole(@PathVariable(value="userId") Integer userId, @RequestBody Integer roleId, UriComponentsBuilder a) {
        Role role = this.g.m_ac(userId, roleId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = roleId;
        return ResponseEntity.created((URI)a.path(c_dc.m_ck((Object)"%\u000f\u007f\u0007o\u0006C\u0010w[x\u001bf\u0011y[q\u0006e\u0018o=n\t")).buildAndExpand(objectArray).toUri()).body((Object)role);
    }

    @DeleteMapping(value={"/{userId}/roles/{roleId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        this.g.m_gc(userId, a);
    }

    @DeleteMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUser(@PathVariable(value="userId") Integer a) {
        this.g.m_qa(a);
    }

    @PostMapping(value={"/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetOwnPassword(@Valid @RequestBody ResetPasswordToken resetPasswordToken, Principal a) {
        this.g.m_mc(a.getName(), resetPasswordToken);
    }
}

