/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.trend.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.trend.model.Trend;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="trend_tag")
@CheckAtLeastOneNotNull.List(value={@CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"}), @CheckAtLeastOneNotNull(fieldNames={"trendId", "trend"})})
public class TrendTag
extends SpaceBaseModel {
    @Column(name="tag_order")
    private Integer order;
    @Column(name="min_scale")
    private Double minScale;
    @Min(value=1L)
    private Integer thickness;
    @Column(name="grid_thickness")
    private Double gridThickness;
    @Size(max=7)
    private String color;
    @Column(name="hide_value_axe")
    private Boolean hideValueAxe;
    @Column(name="max_scale")
    private Double maxScale;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="trend_id")
    private Trend trend;
    @Id
    @Column(name="trend_tag_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="trendTagSeq")
    @GenericGenerator(name="trendTagSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="trend_tag_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Column(name="variable_id", insertable=false, updatable=false)
    private Integer variableId;
    @Size(max=255)
    private String dsc;
    @NotBlank
    @Size(max=100)
    private String name;
    @NotNull
    @Column(name="status_flag")
    private Boolean status;
    @Column(name="trend_id", insertable=false, updatable=false)
    private Integer trendId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="variable_id")
    private Variable<?, ?, ?> variable;

    public void setVariable(Variable<?, ?, ?> a) {
        TrendTag a2;
        TrendTag trendTag = a2;
        trendTag.variable = a;
        trendTag.variableId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getVariableId() {
        TrendTag a;
        return a.variableId;
    }

    public void setTrendId(Integer a) {
        a.trendId = a;
    }

    public Short getVariableDecimalPoint() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getFractionalDigitCount();
        }
        return null;
    }

    public int hashCode() {
        TrendTag a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        objectArray[2] = a.getTrendId();
        return Objects.hash(objectArray);
    }

    public Double getMinScale() {
        TrendTag a;
        return a.minScale;
    }

    public Integer getTrendId() {
        TrendTag a;
        return a.trendId;
    }

    public Boolean getStatus() {
        TrendTag a;
        return a.status;
    }

    public Double getMaxScale() {
        TrendTag a;
        return a.maxScale;
    }

    public void setMinScale(Double a) {
        a.minScale = a;
    }

    public boolean equals(Object a) {
        TrendTag a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof TrendTag)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (TrendTag)a;
        return a2.getName().equals(a.getName()) && a2.getTrendId().equals(a.getTrendId());
    }

    public void setVariableId(Integer a) {
        a.variableId = a;
    }

    public TrendTag() {
        TrendTag a;
    }

    public String getColor() {
        TrendTag a;
        return a.color;
    }

    public Variable<?, ?, ?> getVariable() {
        TrendTag a;
        return a.variable;
    }

    public Integer getOrder() {
        TrendTag a;
        return a.order;
    }

    public void setOrder(Integer a) {
        a.order = a;
    }

    public Integer getId() {
        TrendTag a;
        return a.id;
    }

    public Double getGridThickness() {
        TrendTag a;
        return a.gridThickness;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setGridThickness(Double a) {
        a.gridThickness = a;
    }

    public void setTrend(Trend a) {
        TrendTag a2;
        TrendTag trendTag = a2;
        trendTag.trend = a;
        trendTag.trendId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Boolean getHideValueAxe() {
        TrendTag a;
        return a.hideValueAxe;
    }

    public void setColor(String a) {
        a.color = a;
    }

    public void setMaxScale(Double a) {
        a.maxScale = a;
    }

    public String getVariableName() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getName();
        }
        return null;
    }

    public String getVariableUnit() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getUnit();
        }
        return null;
    }

    public Trend getTrend() {
        TrendTag a;
        return a.trend;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setThickness(Integer a) {
        a.thickness = a;
    }

    public void setHideValueAxe(Boolean a) {
        a.hideValueAxe = a;
    }

    public String getName() {
        TrendTag a;
        return a.name;
    }

    public Integer getThickness() {
        TrendTag a;
        return a.thickness;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public String getDsc() {
        TrendTag a;
        return a.dsc;
    }

    public void setStatus(Boolean a) {
        a.status = a;
    }
}

