/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.auth.security.model.AuthenticationResponseToken;
import com.inscada.mono.broadcast.model.Broadcast;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.user.model.User;
import java.util.Objects;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.springframework.security.core.context.SecurityContextHolder;

@MappedSuperclass
public abstract class OwnedSpaceBaseModel
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="owner_id")
    protected User user;

    public void setUser(User a) {
        a.user = a;
    }

    @PrePersist
    @PreUpdate
    void setOwner() {
        OwnedSpaceBaseModel a;
        AuthenticationResponseToken authenticationResponseToken = (AuthenticationResponseToken)SecurityContextHolder.getContext().getAuthentication();
        Objects.requireNonNull(authenticationResponseToken, Broadcast.m_ck((Object)"9{\ff\u001d`\fg\u001bo\fg\u0017`Xc\r}\f.\u0016a\f.\u001akX`\rb\u0014"));
        a.setUser(authenticationResponseToken.getUser());
    }

    public String getOwner() {
        OwnedSpaceBaseModel a;
        return a.user.getUsername();
    }

    public User getUser() {
        OwnedSpaceBaseModel a;
        return a.user;
    }

    public OwnedSpaceBaseModel() {
        OwnedSpaceBaseModel a;
    }
}

