/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.broadcast.model.BroadcastCountResponse;
import com.inscada.mono.cluster.restcontrollers.ClusterController;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_ch;
import com.inscada.mono.shared.exceptions.c_ck;
import com.inscada.mono.shared.exceptions.c_fg;
import com.inscada.mono.shared.exceptions.c_mi;
import com.inscada.mono.shared.exceptions.c_ua;
import com.inscada.mono.shared.exceptions.c_yg;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String G = "Not Found Error";
    private static final String J = "Security Error";
    private static final String e = "Constraint Violation";
    private static final String a = "Unknown Error";
    private static final Logger k = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    @Value(value="${spring.profiles.active}")
    private String b;
    private static final String l = "Relation Exists Error";
    private static final String m = "Inscada Error";
    private static final String M = "Not Active Error";
    private static final String j = "Database Error";
    private static final String E = "Already Exists Error";
    private static final String L = "Validation Error";
    private static final String d = "File Storage Error";
    private static final String g = "Mismatch Error";

    @ExceptionHandler(value={c_yg.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleFileStorage(c_yg a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, d);
        k.error(ClusterController.m_ck((Object)"1\u001f\u001b\u0013W\u0005\u0003\u0019\u0005\u0017\u0010\u0013W\u0013\u0005\u0004\u0018\u0004MV\f\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = ex.getParameterName();
        objectArray[1] = ex.getParameterType();
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, String.format(BroadcastCountResponse.m_ck((Object)"Klh|p{|m9yx{xd|}|{9.<z>)vo9}`y|)>,j.9`j)t`jzpg~"), objectArray), (Exception)ex, L);
        k.error(ClusterController.m_ck((Object)";\u001e\u0005\u0004\u001f\u0019\u0011W\u0006\u0016\u0004\u0016\u001b\u0012\u0002\u0012\u0004MV\f\u000b"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4) {
        GeneralExceptionHandler a5;
        return a5.createExceptionDetails(a, a2, a3, a4, null);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException a2) {
        GeneralExceptionHandler a3;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails(HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, e, map);
        k.error(BroadcastCountResponse.m_ck((Object)"Jvgj}khpgm)o`vex}pfw39rd"), (Object)a2);
        return new ResponseEntity((Object)a2, HttpStatus.CONFLICT);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, L);
        k.error(ClusterController.m_ck((Object)":\u0013\u0004\u0005\u0016\u0011\u0012V\u0019\u0019\u0003V\u0005\u0013\u0016\u0012\u0016\u0014\u001b\u0013MV\f\u000b"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_ac.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleRelationExists(c_ac a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, l);
        k.error(BroadcastCountResponse.m_ck((Object)"Kluhm`vg9la`j}j)|{kfk39rd"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return ClusterController.m_ck((Object)"\u0007\u0017\u0003\u001eX\u0003\u0019\u001d\u0019\u0019\u0000\u0018");
        }
    }

    @ExceptionHandler(value={c_ck.class, EntityNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    protected ResponseEntity<Object> handleEntityNotFound(Exception a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.NOT_FOUND, a.getMessage(), a, G);
        k.error(BroadcastCountResponse.m_ck((Object)"Lw}p}`)wfm)\u007fflg}39rd"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.NOT_FOUND);
    }

    private /* synthetic */ boolean isDevelopment() {
        GeneralExceptionHandler a;
        String[] stringArray = new String[2];
        stringArray[0] = ClusterController.m_ck((Object)"\u0012\u0012\u0000");
        stringArray[1] = BroadcastCountResponse.m_ck((Object)"}|zm");
        return Arrays.asList(stringArray).contains(a.b);
    }

    @ExceptionHandler(value={c_mi.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMismatch(c_mi a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, g);
        k.error(ClusterController.m_ck((Object)":\u001f\u0004\u001b\u0016\u0002\u0014\u001eW\u0013\u0005\u0004\u0018\u0004MV\f\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_ua.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInscadaException(c_ua a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, m);
        k.error(BroadcastCountResponse.m_ck((Object)"Pgjjxmx)|{kfk39rd"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={TransactionSystemException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException a) {
        GeneralExceptionHandler a2;
        Throwable throwable = a.getRootCause();
        if (throwable instanceof ConstraintViolationException) {
            return a2.handleConstraintViolation((ConstraintViolationException)throwable);
        }
        throwable = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, j);
        k.error(ClusterController.m_ck((Object)"#\u0004\u0016\u0018\u0004\u0017\u0014\u0002\u001e\u0019\u0019V\u0004\u000f\u0004\u0002\u0012\u001bW\u0013\u0005\u0004\u0018\u0004MV\f\u000b"), (Object)throwable, (Object)a);
        return new ResponseEntity((Object)throwable, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> a2) {
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)BroadcastCountResponse.m_ck((Object)"%9"), (Iterable)a.getValue())).collect(Collectors.joining(BroadcastCountResponse.m_ck((Object)"9u9")));
    }

    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a2) {
        headers = new HashMap();
        status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return ClusterController.m_ck((Object)"9\u0019W\u001b\u0012\u0005\u0004\u0017\u0010\u0013W\u0017\u0001\u0017\u001e\u001a\u0016\u0014\u001b\u0013");
        }, Collectors.toList())));
        a2 = ex.getBindingResult().getGlobalErrors().stream().map(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return ClusterController.m_ck((Object)"9\u0019W\u001b\u0012\u0005\u0004\u0017\u0010\u0013W\u0017\u0001\u0017\u001e\u001a\u0016\u0014\u001b\u0013");
        }).collect(Collectors.toList());
        headers.putAll(status);
        if (!a2.isEmpty()) {
            headers.put(ClusterController.m_ck((Object)"\u0010\u001a\u0018\u0014\u0016\u001a"), a2);
        }
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, this.formatErrorMessages((Map)headers), (Exception)ex, L, (Map)headers);
        k.error(BroadcastCountResponse.m_ck((Object)"_xepmx}pfw)|{kfk39rd"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, L);
        k.error(ClusterController.m_ck((Object)">\u001a\u001b\u0013\u0010\u0017\u001bV\u0016\u0004\u0010\u0003\u001a\u0013\u0019\u0002MV\f\u000b"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleAllExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), a, a);
        k.error(BroadcastCountResponse.m_ck((Object)"\\wlay|jml})|{kfk39rd"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={c_ch.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleNotActive(c_ch a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, M);
        k.error(ClusterController.m_ck((Object)"9\u0019\u0003V\u0016\u0015\u0003\u001f\u0001\u0013W\u0013\u0005\u0004\u0018\u0004MV\f\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_fg.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleAlreadyExists(c_fg a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, E);
        k.error(BroadcastCountResponse.m_ck((Object)"Hu{|h}p9la`j}j)|{kfk39rd"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, j);
        k.error(ClusterController.m_ck((Object)"?\u0019\u0010\u001b\u0003\u000f25V\u001a\u0017\u0007\u0006\u0012\u0004W\u0013\u0005\u0004\u0018\u0004MV\f\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, m);
        k.error(BroadcastCountResponse.m_ck((Object)"Peul~hu)j}x}|39rd"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ String sanitizeMessage(String a, Exception a2) {
        GeneralExceptionHandler a3;
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof c_fg) {
            return ClusterController.m_ck((Object)"$\u0012\u0005\u0018\u0003\u0005\u0015\u0012V\u0016\u001a\u0005\u0013\u0016\u0012\u000eV\u0012\u000e\u001e\u0005\u0003\u0005");
        }
        if (a2 instanceof c_yg) {
            return BroadcastCountResponse.m_ck((Object)"_`ul9filkhm`vg9ox`ul}");
        }
        if (a2 instanceof c_mi) {
            return ClusterController.m_ck((Object)"$\u0012\u0005\u0018\u0003\u0005\u0015\u0012V\u001a\u001f\u0004\u001b\u0016\u0002\u0014\u001e");
        }
        if (a2 instanceof c_ch) {
            return BroadcastCountResponse.m_ck((Object)"[|zv|kj|)pz9gv}9hz}p\u007f|");
        }
        if (a2 instanceof c_ck) {
            return ClusterController.m_ck((Object)"%\u0013\u0004\u0019\u0002\u0004\u0014\u0013W\u0018\u0018\u0002W\u0010\u0018\u0003\u0019\u0012");
        }
        if (a2 instanceof c_ac) {
            return BroadcastCountResponse.m_ck((Object)"Kluhml})kljfl{zl9la`j}j");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return ClusterController.m_ck((Object)"2\u0016\u0002\u0016\u0014\u0016\u0005\u0012V\u0014\u0019\u0019\u0005\u0003\u0004\u0016\u001f\u0019\u0002W\u0000\u001e\u0019\u001b\u0017\u0003\u001f\u0018\u0018");
        }
        if (a2 instanceof TransactionSystemException) {
            return BroadcastCountResponse.m_ck((Object)"Mx}xkxz|)m{xgjhz}pfw)|{kfk");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return ClusterController.m_ck((Object)"#\u001f\u001a\u0013W\u0005\u0012\u0004\u001e\u0013\u0004V\u0013\u0017\u0003\u0017\u0015\u0017\u0004\u0013W\u0013\u0005\u0004\u0018\u0004");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return BroadcastCountResponse.m_ck((Object)"Xjzljz9m|gpl}");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return ClusterController.m_ck((Object)"?\u0019\u0000\u0016\u001a\u001e\u0012W\u001f\u0019\u0006\u0002\u0002");
        }
        if (a2 instanceof ConstraintViolationException) {
            return BroadcastCountResponse.m_ck((Object)"Ohu`}hm`vg9jvgj}khpgm)o`vex}pfw");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return ClusterController.m_ck((Object)">\u0018\u0001\u0017\u001b\u001f\u0013V\u0005\u0013\u0006\u0003\u0012\u0005\u0003V\u0011\u0019\u0005\u001b\u0016\u0002");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return BroadcastCountResponse.m_ck((Object)"Dpzj`wn9{|xl`kl})ihkhtlmlk");
        }
        if (a2 instanceof IllegalStateException) {
            return ClusterController.m_ck((Object)"?\u0019\u0000\u0016\u001a\u001e\u0012W\u0017\u0007\u0006\u001b\u001f\u0014\u0017\u0003\u001f\u0018\u0018W\u0005\u0003\u0017\u0003\u0013");
        }
        return BroadcastCountResponse.m_ck((Object)"Hw)lg|qilz}|m9lk{v{9fzjl{kl}");
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException a) {
        GeneralExceptionHandler a2;
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getName();
        objectArray[1] = a.getValue();
        objectArray[2] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : ClusterController.m_ck((Object)"\u0003\u0019\u001d\u0019\u0019\u0000\u0018");
        String string = String.format(BroadcastCountResponse.m_ck((Object)"Yx{xd|}|{9.<z>)n`ma9\u007fxell9.<z>)zfle})wfm){l9jvgolk}|m9}v)mpil9.<z>"), objectArray);
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, string, (Exception)a, L);
        k.error(BroadcastCountResponse.m_ck((Object)"Mpil9dpzthmjq39rd"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4, Map<String, List<String>> a5) {
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = a6;
        a2 = generalExceptionHandler.sanitizeMessage(a2, a3);
        String string = generalExceptionHandler.isDevelopment() ? a3.getClass().getName() : ClusterController.m_ck((Object)"3\u000f\u0015\u0012\u0006\u0003\u001f\u0018\u0018");
        String string2 = a6.isDevelopment() ? a4 : BroadcastCountResponse.m_ck((Object)"\\{kfk");
        String string3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a3) : null;
        return new ExceptionDetails(a.value(), a2, string, string2, a5, a4 = string3, new Date(), a6.getCurrentPath());
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(status, ex.getMessage(), ex, a);
        k.error(ClusterController.m_ck((Object)">\u0018\u0003\u0013\u0005\u0018\u0016\u001aW\u0013\u0005\u0004\u0018\u0004MV\f\u000b"), (Object)ex);
        return new ResponseEntity((Object)ex, status);
    }

    public GeneralExceptionHandler() {
        GeneralExceptionHandler a;
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    protected ResponseEntity<Object> handleSecurityExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.FORBIDDEN, a.getMessage(), a, J);
        k.error(ClusterController.m_ck((Object)"$\u0013\u0014\u0003\u0005\u001f\u0003\u000fW\u0013\u0005\u0004\u0018\u0004MV\f\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, j);
        k.error(BroadcastCountResponse.m_ck((Object)"Mx}x)pgml~{p}`)o`vex}pfw39rd"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }
}

