/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.settings.model;

import com.inscada.mono.shared.converters.AttributeEncryptor;
import com.inscada.mono.shared.model.SpaceBaseModel;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.simplejavamail.api.mailer.config.TransportStrategy;

@Entity
@Table(name="mail_settings")
public class MailSettings
extends SpaceBaseModel {
    @NotBlank
    @Email
    @Size(max=255)
    @Column(name="from_address")
    private String fromAddress;
    @NotBlank
    @Size(max=50)
    @Column(name="smtp_host")
    private String smtpHost;
    @NotNull
    @Column(name="protocol")
    @Enumerated(value=EnumType.STRING)
    private TransportStrategy transportStrategy;
    @NotBlank
    @Size(max=60)
    @Convert(converter=AttributeEncryptor.class)
    private String password;
    @NotNull
    @Min(value=0L)
    @Column(name="smtp_port")
    private Integer smtpPort;
    @NotBlank
    @Size(max=50)
    private String username;
    @Id
    @Column(name="mail_settings_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="mailSettingsSeq")
    @GenericGenerator(name="mailSettingsSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="mail_settings_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;

    public void setFromAddress(String a) {
        a.fromAddress = a;
    }

    public String getPassword() {
        MailSettings a;
        return a.password;
    }

    public void setSmtpPort(Integer a) {
        a.smtpPort = a;
    }

    public void setTransportStrategy(TransportStrategy a) {
        a.transportStrategy = a;
    }

    public void setUsername(String a) {
        a.username = a;
    }

    public void setSmtpHost(String a) {
        a.smtpHost = a;
    }

    public Integer getId() {
        MailSettings a;
        return a.id;
    }

    public MailSettings() {
        MailSettings a;
    }

    public Integer getSmtpPort() {
        MailSettings a;
        return a.smtpPort;
    }

    public String getFromAddress() {
        MailSettings a;
        return a.fromAddress;
    }

    public TransportStrategy getTransportStrategy() {
        MailSettings a;
        return a.transportStrategy;
    }

    public String getUsername() {
        MailSettings a;
        return a.username;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setPassword(String a) {
        a.password = a;
    }

    public String getSmtpHost() {
        MailSettings a;
        return a.smtpHost;
    }
}

