/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.auth.c_kka;
import com.inscada.mono.auth.security.k.c_cba;
import com.inscada.mono.cluster.k.c_vha;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_j;
import com.inscada.mono.impexp.model.ExtractedItem;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.w.c_od;
import com.inscada.mono.log.services.c_ng;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.script.enums.c_hm;
import com.inscada.mono.script.enums.c_td;
import com.inscada.mono.script.events.CancelEvent;
import com.inscada.mono.script.events.RescheduleEvent;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_pf;
import com.inscada.mono.script.services.c_sg;
import com.inscada.mono.script.services.c_uf;
import com.inscada.mono.shared.exceptions.c_ch;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener {
    private final c_j H;
    public static final short A = 305;
    public static final short i = 303;
    private final Lock G;
    private final Map<Integer, Job> J;
    public static final short e = 307;
    public static final short a = 306;
    public static final short k = 301;
    public static final short b = 302;
    private static final Logger l = LoggerFactory.getLogger(ScriptManager.class);
    private final c_pf m;
    public static final short M = 304;
    private static final String j = "scheduled_scripts";
    private final JedisPooled E;
    private final c_od L;
    private final c_ng d;
    private final c_sg g;

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.H.m_sa((ClusterNodeListener)a);
        l.info(ExtractedItem.m_ck((Object)"1%\u0010/\u00122/'\f'\u0005#\u0010f\u000b(\u000b2\u000b'\u000e/\u0018#\u0006f\u0003(\u0006f\u0010#\u0005/\u00112\u00074\u0007\"B'\u0011f!*\u00175\u0016#\u0010\b\r\"\u0007\n\u000b5\u0016#\f#\u0010h"));
    }

    protected void cancelScriptsByProjectIdInternal(Integer a) {
        ScriptManager a2;
        if ((a = a2.g.m_la((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            l.debug(c_cba.m_ck((Object)">\u001d3\u001c7\nHx!;\u001a=\u0016-\u001e1\u001c?R+\u0011*\u001b(\u0006x\t%R4\u001d;\u00134\u001e!\\"), (Object)a);
            a2.scheduleScriptInternal(a);
            return;
        }
        l.debug(ExtractedItem.m_ck((Object)",\t,k.\u0003#\u0002'\u0014Xf0#\u00133\u00075\u0016/\f!B*\u0007'\u0006#\u0010f\u0016)B5\u0001.\u0007\"\u0017*\u0007f\u0011%\u0010/\u00122B=\u001fh"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.H.m_sb(Short.valueOf((short)301), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC schedule script " + a, (Throwable)exception);
        }
    }

    protected Map<Integer, c_hm> getScriptStatusesByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.g.m_gm((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, a -> {
            ScriptManager a2;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_hm> getScriptStatuses(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.H.m_hb()) {
            l.debug(c_cba.m_ck((Object)"\u00147\u00196\u001d bR\u001f\u0017,\u00061\u001c?R+\u0011*\u001b(\u0006x\u0001,\u0013,\u0007+\u0017+R>\u001d*R#\u000fx;\u001c\u0001x\u001e7\u00119\u001e4\u000bbR#\u000f"), (Object)a.size(), a);
            return a2.getScriptStatusesByIdsInternal(a);
        }
        l.debug(ExtractedItem.m_ck((Object)",\t,k.\u0003#\u0002'\u0014Xf0#\u00133\u00075\u0016/\f!B*\u0007'\u0006#\u0010f\u0004)\u0010f\u0011%\u0010/\u00122B5\u0016'\u00163\u0011#\u0011f\u0004)\u0010f\u0019;B\u000f&5Xf\u0019;"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.H.m_sb(Short.valueOf((short)306), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_cba.m_ck((Object)"^"))), (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ScriptManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.H.m_yb((short)301, (Object)a, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_ck((Object)"\u0011%\n#\u00063\u000e#1%\u0010/\u00122+(\u0016#\u0010(\u0003*"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.H.m_yb((short)302, (Object)a, ScriptManager.class.getDeclaredMethod(c_cba.m_ck((Object)";\u00136\u0011=\u001e\u000b\u0011*\u001b(\u0006\u0011\u001c,\u0017*\u001c9\u001e"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.H.m_yb((short)303, (Object)a, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_ck((Object)"!\u000721%\u0010/\u0012212\u00032\u00175+(\u0016#\u0010(\u0003*"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.H.m_yb((short)304, (Object)a, ScriptManager.class.getDeclaredMethod(c_cba.m_ck((Object)"+\u00110\u0017<\u00074\u0017\u000b\u0011*\u001b(\u0006+0!\"*\u001d2\u0017;\u0006\u0011\u0016\u0011\u001c,\u0017*\u001c9\u001e"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.H.m_yb((short)305, (Object)a, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_ck((Object)"\u0001'\f%\u0007*1%\u0010/\u00122\u0011\u0004\u001b\u0016\u0010)\b#\u00012+\"+(\u0016#\u0010(\u0003*"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.H.m_yb((short)306, (Object)a, ScriptManager.class.getDeclaredMethod(c_cba.m_ck((Object)"?\u0017,!;\u00001\u0002,!,\u0013,\u0007+\u0017+0!;<\u0001\u0011\u001c,\u0017*\u001c9\u001e"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.H.m_yb((short)307, (Object)a, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_ck((Object)"\u0005#\u0016\u0015\u00014\u000b6\u0016\u0015\u0016'\u00163\u0011#\u0011\u0004\u001b\u0016\u0010)\b#\u00012+\"+(\u0016#\u0010(\u0003*"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(c_cba.m_ck((Object)"\u001e\u00131\u001e=\u0016x\u00067R*\u0017?\u001b+\u0006=\u0000x!;\u00001\u0002,?9\u001c9\u0015=\u0000x \b1x\u001f=\u00060\u001d<\u0001"), noSuchMethodException);
        }
    }

    protected void scheduleScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.scheduleScriptInternal(scriptManager.g.m_wj(a));
    }

    protected void cancelScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.cancelScriptInternal(scriptManager.g.m_wj(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        String string = scriptManager.H.m_gb().getNodeId();
        l.info(ExtractedItem.m_ck((Object)"\u0015\u00014\u000b6\u0016\u000b\u0003(\u0003!\u00074Xf6.\u000b5B(\r\"\u0007fJ=\u001foB.\u00035B$\u0007%\r+\u0007f\u0016.\u0007f.\u0003#\u0002'\u0014Lf0#\u00112\r4\u000b(\u0005f\u0011%\n#\u00063\u000e#\u0006f\u0011%\u0010/\u00122\u0011hLh"), (Object)string);
        scriptManager.G.lock();
        try {
            Set set = a2.E.smembers(j).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                l.info(c_cba.m_ck((Object)"\u000b\u0011*\u001b(\u0006\u0015\u00136\u0013?\u0017*Rp>=\u0013<\u0017*R#\u000fqHx<7R+\u00110\u0017<\u00074\u0017<R+\u0011*\u001b(\u0006+R>\u001d-\u001c<R1\u001cx =\u00161\u0001x\u00067R*\u0017+\u00067\u0000=\\"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            l.info(ExtractedItem.m_ck((Object)"1%\u0010/\u00122/'\f'\u0005#\u0010fJ\n\u0007'\u0006#\u0010f\u0019;K|B\u0000\r3\f\"B=\u001ff\u0011%\n#\u00063\u000e#\u0006f\u0011%\u0010/\u00122B\u000f&5B/\ff0#\u0006/\u0011f\u0016)B4\u00075\u0016)\u0010#Xf\u0019;"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = c_cba.m_ck((Object)"$\u00117\u000f-\u000b1\n;\b&");
            c_kka.m_occ(() -> {
                ScriptManager a3;
                arrayList.addAll(a3.g.m_te(set));
            }, (String[])stringArray);
            l.info(ExtractedItem.m_ck((Object)"1%\u0010/\u00122/'\f'\u0005#\u0010fJ\n\u0007'\u0006#\u0010f\u0019;K|B\u0007\u00162\u0007+\u00122\u000b(\u0005f\u0016)B4\u00075\u0016)\u0010#B=\u001ff\u0011%\u0010/\u00122\u0011h"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ScriptManager a2;
                ScriptManager scriptManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = c_cba.m_ck((Object)"!\u001b:\u001d6\r>\u001d-\u000b1\n;\b&");
                stringArray[1] = ExtractedItem.m_ck((Object)"\u0005#\b!\u0003.\u00191\u00050\u000f2\u0012");
                c_kka.m_byb(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1(scriptManager.H.m_gb().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            l.info(c_cba.m_ck((Object)"!;\u00001\u0002,?9\u001c9\u0015=\u0000xZ\u0014\u00179\u0016=\u0000x\t%[bR\u001e\u001b6\u001b+\u001a=\u0016x\u0001;\u00001\u0002,R*\u0017+\u00067\u00009\u00061\u001d6R(\u00007\u0011=\u0001+\\"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            l.error(ExtractedItem.m_ck((Object)"1%\u0010/\u00122/'\f'\u0005#\u0010fJ\n\u0007'\u0006#\u0010f\u0019;K|B\u0003\u00104\r4B\"\u00174\u000b(\u0005f\u0011%\u0010/\u00122B4\u00075\u0016)\u0010'\u0016/\r(B6\u0010)\u0001#\u00115Xf\u0019;"), objectArray);
            return;
        }
        finally {
            a2.G.unlock();
        }
    }

    protected Map<Integer, c_hm> getScriptStatusesByIdsInternal(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    protected void scheduleScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_kka.m_kvb(() -> {
            ScriptManager a2;
            a2.G.lock();
            try {
                Job job;
                ScriptManager scriptManager;
                block14: {
                    a2.cancelScriptInternal(a);
                    if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                        throw new c_ch("Project should be active to schedule script " + a.getName());
                    }
                    switch (c_uf.g[a.getType().ordinal()]) {
                        case 1: {
                            ScriptManager scriptManager2 = a2;
                            while (false) {
                            }
                            scriptManager = scriptManager2;
                            job = scriptManager2.createDailyScriptJob(a);
                            break block14;
                        }
                        case 2: {
                            ScriptManager scriptManager3 = a2;
                            scriptManager = scriptManager3;
                            job = scriptManager3.createPeriodicScriptJob(a);
                            break block14;
                        }
                        case 3: {
                            job = a2.createOnceScriptJob(a);
                            break;
                        }
                        case 4: {
                            return;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown schedule type of " + a.getType());
                        }
                    }
                    scriptManager = a2;
                }
                scriptManager.J.put(a.getId(), job);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.E.sadd(j, stringArray);
                return;
            }
            finally {
                a2.G.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(Integer a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            l.debug(c_cba.m_ck((Object)"\u00147\u00196\u001d bR\u001b\u00136\u0011=\u001e4\u001b6\u0015x\u00134\u001ex\u0001;\u00001\u0002,\u0001x\u00147\u0000x\u0002*\u001d2\u0017;\u0006x\t%R4\u001d;\u00134\u001e!\\"), (Object)a);
            a2.cancelScriptsByProjectIdInternal(a);
            return;
        }
        l.debug(ExtractedItem.m_ck((Object)"\b-\bO\n'\u0007&\u00030|B\u0014\u00077\u0017#\u00112\u000b(\u0005f\u000e#\u0003\"\u00074B2\rf\u0001'\f%\u0007*B'\u000e*B5\u00014\u000b6\u00165B \r4B6\u0010)\b#\u00012B=\u001fh"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.H.m_sb(Short.valueOf((short)305), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC cancel scripts for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String a, RepeatableScript a2) {
        ScriptManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            l.info(c_cba.m_ck((Object)"\u000b\u0011*\u001b(\u0006\u0015\u00136\u0013?\u0017*Rp>=\u0013<\u0017*R#\u000fqHx =\u0001,\u001d*\u001b6\u0015x\u0001;\u00001\u0002,Hx\t%Rp;\u001cHx\t%["), objectArray);
            a3.scheduleScriptInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.d.m_lga(a2.getProject()).m_c("Script Restore (Leader " + a + ")", String.format(ExtractedItem.m_ck((Object)"G5Bn+\u0002XfG\"Kf\u0004'\u000b*\u0007\"B2\rf\u0010#\u00112\r4\u0007hB\u0005\u00033\u0011#XfG5"), objectArray));
            try {
                l.warn(c_cba.m_ck((Object)"\u000b\u0011*\u001b(\u0006\u0015\u00136\u0013?\u0017*Rp>=\u0013<\u0017*R#\u000fqHx3,\u0006=\u001f(\u00061\u001c?R,\u001dx\u00119\u001c;\u00174R+\u0011*\u001b(\u0006x\t%R9\u0014,\u0017*R*\u0017+\u00067\u00009\u00061\u001d6R>\u00131\u001e-\u0000=\\"), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                l.error(ExtractedItem.m_ck((Object)"\u0015\u00014\u000b6\u0016\u000b\u0003(\u0003!\u00074Bn.#\u0003\"\u00074B=\u001foXf$'\u000b*\u0007\"B2\rf\u0001'\f%\u0007*B5\u00014\u000b6\u0016f\u0019;B'\u00042\u00074B4\u00075\u0016)\u0010'\u0016/\r(B \u0003/\u000e3\u0010#Xf\u0019;"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_hm getScriptStatus(Integer a, String a2) {
        ScriptManager a3;
        if ((a = a3.g.m_dg(a, a2)) == null) {
            return c_hm.E;
        }
        return a3.getScriptStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_hm> getScriptStatuses(Integer a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            l.debug(c_cba.m_ck((Object)">\u001d3\u001c7\nHx5=\u0006,\u001b6\u0015x\u00134\u001ex\u0001;\u00001\u0002,R+\u00069\u0006-\u0001=\u0001x\u00147\u0000x\u0002*\u001d2\u0017;\u0006x\t%R4\u001d;\u00134\u001e!\\"), (Object)a);
            return a2.getScriptStatusesByProjectIdInternal(a);
        }
        l.debug(ExtractedItem.m_ck((Object)"\b-\bO\n'\u0007&\u00030|B\u0014\u00077\u0017#\u00112\u000b(\u0005f\u000e#\u0003\"\u00074B \r4B'\u000e*B5\u00014\u000b6\u0016f\u00112\u00032\u00175\u00075B \r4B6\u0010)\b#\u00012B=\u001fh"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.H.m_sb(Short.valueOf((short)307), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    private /* synthetic */ String generateJobName(RepeatableScript a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = a.getType().m_t();
        objectArray[1] = a.getName();
        return String.format(c_cba.m_ck((Object)"}\u0001x!;\u00001\u0002,RuR}\u0001"), objectArray);
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.L.m_xka(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.m.m_jm((Script)a);
        }, Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }

    protected void scheduleScriptsByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.g.m_la((Integer)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> a.getType() != c_td.E).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            l.debug(ExtractedItem.m_ck((Object)"\n'\u0007&\u00030|B\u0005\u0003(\u0001#\u000e*\u000b(\u0005f\u0011%\u0010/\u00122B=\u001ff\u000e)\u0001'\u000e*\u001bh"), (Object)a);
            a2.cancelScriptInternal(a);
            return;
        }
        l.debug(c_cba.m_ck((Object)"\u0016=\u0016_\u00147\u00196\u001d bR\n\u0017)\u0007=\u0001,\u001b6\u0015x\u001e=\u0013<\u0017*R,\u001dx\u00119\u001c;\u00174R+\u0011*\u001b(\u0006x\t%\\"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.H.m_sb(Short.valueOf((short)302), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC cancel script " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_hm getScriptStatus(Integer a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            l.debug(ExtractedItem.m_ck((Object)"\n'\u0007&\u00030|B\u0001\u00072\u0016/\f!B5\u00014\u000b6\u0016f\u00112\u00032\u00175B \r4B=\u001ff\u000e)\u0001'\u000e*\u001bh"), (Object)a);
            return a2.getScriptStatusInternal(a);
        }
        l.debug(c_cba.m_ck((Object)"<\u0017<u>\u001d3\u001c7\nHx =\u0003-\u0017+\u00061\u001c?R4\u00179\u0016=\u0000x\u00147\u0000x\u0001;\u00001\u0002,R+\u00069\u0006-\u0001x\u00147\u0000x\t%\\"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_hm)a2.H.m_sb(Short.valueOf((short)303), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get script status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.scheduleScript(scriptManager.g.m_ho(a, a2).getId());
    }

    private /* synthetic */ Job createDailyScriptJob(RepeatableScript a) {
        ScriptManager a2;
        Comparable<Date> comparable = a.getTime();
        comparable = LocalTime.of(comparable.getHours(), comparable.getMinutes(), comparable.getSeconds());
        return a2.L.m_sba(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.m.m_jm((Script)a);
        }, (LocalTime)comparable);
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            RepeatableScript repeatableScript = a.getScript();
            l.info(ExtractedItem.m_ck((Object)".\u0003#\u0002'\u0014Xf*'\f\"\u000e/\f!B\u0014\u00075\u0001.\u0007\"\u0017*\u0007\u0003\u0014#\f2B \r4B5\u00014\u000b6\u0016|B=\u001ffJ\u000f&|B=\u001fo"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            if (a2.getScriptStatusInternal(repeatableScript.getId()) == c_hm.g) {
                a2.scheduleScriptInternal(repeatableScript.getId());
                return;
            }
        } else {
            l.debug(c_cba.m_ck((Object)"<\u0017<u>\u001d3\u001c7\nHx;?\u001c7\u00001\u001c?R\n\u0017+\u00110\u0017<\u00074\u0017\u001d\u0004=\u001c,R>\u001d*R+\u0011*\u001b(\u0006bR#\u000f"), (Object)a.getScript().getId());
        }
    }

    protected void cancelScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_kka.m_kvb(() -> {
            ScriptManager a2;
            a2.G.lock();
            try {
                Job job = (Job)a2.J.get(a.getId());
                if (job != null) {
                    a2.L.m_vaa(job);
                }
                ScriptManager scriptManager = a2;
                scriptManager.J.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                scriptManager.E.srem(j, stringArray);
                return;
            }
            finally {
                a2.G.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @Order(value=1)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            Integer n = a.getProject().getId();
            l.info(ExtractedItem.m_ck((Object)".\u0003#\u0002'\u0014Xf*'\f\"\u000e/\f!B\u0016\u0010)\b#\u00012&#\u0003%\u0016/\u0014'\u0016#'0\u0007(\u0016f\u0004)\u0010f\u00124\r,\u0007%\u0016f+\u0002Xf\u0019;"), (Object)n);
            a2.cancelScriptsByProjectIdInternal(n);
            return;
        }
        l.debug(c_cba.m_ck((Object)"\u0016=\u0016_\u00147\u00196\u001d bR\u0011\u00156\u001d*\u001b6\u0015x\"*\u001d2\u0017;\u0006\u001c\u00179\u0011,\u001b.\u0013,\u0017\u001d\u0004=\u001c,R>\u001d*R(\u00007\u0018=\u0011,R\u00116bR#\u000f"), (Object)a.getProject().getId());
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.L.m_sia(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            Script script = Script.newBuilder((RepeatableScript)a).build();
            a2.m.m_jm(script);
            a2.cancelScript(a.getId());
        }, Duration.ofMillis(a.getDelay().intValue()), false);
    }

    public ScriptManager(c_sg a, c_od a2, c_pf a3, c_ng a4, JedisPooled a5, c_j a6) {
        ScriptManager a7;
        ScriptManager scriptManager = a7;
        ScriptManager scriptManager2 = a7;
        ScriptManager scriptManager3 = a7;
        ScriptManager scriptManager4 = a7;
        a7.G = new ReentrantLock();
        scriptManager4.J = new ConcurrentHashMap();
        scriptManager3.g = a;
        scriptManager3.L = a2;
        scriptManager2.m = a3;
        scriptManager2.d = a4;
        scriptManager.E = a5;
        scriptManager.H = a6;
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            RepeatableScript repeatableScript = a.getScript();
            l.info(ExtractedItem.m_ck((Object)".\u0003#\u0002'\u0014Xf*'\f\"\u000e/\f!B\u0005\u0003(\u0001#\u000e\u0003\u0014#\f2B \r4B5\u00014\u000b6\u0016|B=\u001ffJ\u000f&|B=\u001fo"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            a2.cancelScriptInternal(repeatableScript);
            return;
        }
        l.debug(c_cba.m_ck((Object)"<\u0017<u>\u001d3\u001c7\nHx;?\u001c7\u00001\u001c?R\u001b\u00136\u0011=\u001e\u001d\u0004=\u001c,R>\u001d*R+\u0011*\u001b(\u0006bR#\u000f"), (Object)a.getScript().getId());
    }

    protected c_hm getScriptStatusInternal(Integer a) {
        ScriptManager a2;
        if (a2.J.containsKey(a)) {
            return c_hm.g;
        }
        return c_hm.E;
    }

    public void notLeader() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        String string = scriptManager.H.m_gb().getNodeId();
        l.info(ExtractedItem.m_ck((Object)"1%\u0010/\u00122/'\f'\u0005#\u0010|B\u0012\n/\u0011f\f)\u0006#Bn\u0019;Kf\u000b5B\b-f.\t,\u0001'\u0014B\u0012*\u0003B\n'\u0007&\u00030hB\u0005\u0003(\u0001#\u000e*\u000b(\u0005f\u0003*\u000ef\u000e)\u0001'\u000ef\u0011%\u0010/\u00122B,\r$\u0011hLh"), (Object)string);
        scriptManager.G.lock();
        try {
            new ArrayList(a.J.keySet()).forEach(a2 -> {
                ScriptManager a3;
                Job job = (Job)a3.J.get(a2);
                if (job != null) {
                    try {
                        l.info(ExtractedItem.m_ck((Object)"\u0015\u00014\u000b6\u0016\u000b\u0003(\u0003!\u00074Bn,)\u0016f.#\u0003\"\u00074B=\u001foXf!'\f%\u0007*\u000e/\f!B*\r%\u0003*B,\r$B \r4B5\u00014\u000b6\u0016f+\u0002Xf\u0019;"), (Object)string, a2);
                        a3.L.m_vaa(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        l.error(c_cba.m_ck((Object)"\u000b\u0011*\u001b(\u0006\u0015\u00136\u0013?\u0017*Rp<7\u0006x>=\u0013<\u0017*R#\u000fqHx7*\u00007\u0000x\u00119\u001c;\u00174\u001e1\u001c?R4\u001d;\u00134R2\u001d:R>\u001d*R+\u0011*\u001b(\u0006x;\u001cR#\u000fbR#\u000f"), objectArray);
                    }
                }
            });
            a.J.clear();
            l.info(c_cba.m_ck((Object)"!;\u00001\u0002,?9\u001c9\u0015=\u0000xZ\u0016\u001d,R\u0014\u00179\u0016=\u0000x\t%[bR\u0019\u001e4R4\u001d;\u00134R+\u0011*\u001b(\u0006x\u00187\u0010+R0\u0013.\u0017x\u0010=\u00176R*\u0017)\u0007=\u0001,\u0017<R,\u001dx\u00119\u001c;\u00174R9\u001c<R;\u001e=\u0013*\u0017<R>\u00007\u001fx\u001e7\u00119\u001ex\u0006*\u0013;\u00191\u001c?\\"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            l.error(ExtractedItem.m_ck((Object)"\u0015\u00014\u000b6\u0016\u000b\u0003(\u0003!\u00074Bn,)\u0016f.#\u0003\"\u00074B=\u001foXf'4\u0010)\u0010f\u00063\u0010/\f!B6\u0010)\u0001#\u00115B)\u0004f\u0001'\f%\u0007*\u000e/\f!B*\r%\u0003*B5\u00014\u000b6\u0016f\b)\u00005Xf\u0019;"), objectArray);
            return;
        }
        finally {
            a.G.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(Integer a) {
        ScriptManager a2;
        if (a2.H.m_hb()) {
            l.debug(c_cba.m_ck((Object)"\u00147\u00196\u001d bR\u000b\u00110\u0017<\u00074\u001b6\u0015x\u00134\u001ex\u0001;\u00001\u0002,\u0001x\u00147\u0000x\u0002*\u001d2\u0017;\u0006x\t%R4\u001d;\u00134\u001e!\\"), (Object)a);
            a2.scheduleScriptsByProjectIdInternal(a);
            return;
        }
        l.debug(ExtractedItem.m_ck((Object)"\b-\bO\n'\u0007&\u00030|B\u0014\u00077\u0017#\u00112\u000b(\u0005f\u000e#\u0003\"\u00074B2\rf\u0011%\n#\u00063\u000e#B'\u000e*B5\u00014\u000b6\u00165B \r4B6\u0010)\b#\u00012B=\u001fh"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.H.m_sb(Short.valueOf((short)304), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC schedule scripts for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.cancelScript(scriptManager.g.m_ho(a, a2).getId());
    }
}

