/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.restcontrollers;

import com.inscada.mono.animation.model.ScriptDto;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.script.enums.c_hm;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.services.ScriptManager;
import com.inscada.mono.script.services.c_pf;
import com.inscada.mono.script.services.c_sg;
import com.inscada.mono.shared.aspects.SpaceFilterAspect;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/scripts"})
public class ScriptController
extends ProjectBasedImportExportController {
    private final ScriptManager L;
    private final c_sg d;
    private final c_pf g;

    @PostMapping(value={"/{scriptId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="scriptId") Integer a) {
        this.L.scheduleScript(a);
    }

    @DeleteMapping(value={""}, params={"scriptIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScriptsByIds(@RequestParam(value="scriptIds") Integer[] a) {
        this.d.m_tg(List.of(a));
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_hm> getScriptStatuses(@RequestParam(value="scriptIds") Integer[] a) {
        return this.L.getScriptStatuses(List.of(a));
    }

    @PostMapping(value={"/{scriptId}/run"})
    public Object runScript(@PathVariable(value="scriptId") Integer a) {
        return this.g.m_mr(a);
    }

    @PutMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScript(@PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody RepeatableScript a) {
        this.d.m_oj(scriptId, a);
    }

    @PostMapping(value={"/runner"})
    public Object runScript(@RequestBody ScriptDto a) {
        return this.g.m_nx(a);
    }

    @DeleteMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScript(@PathVariable(value="scriptId") Integer a) {
        this.d.m_qa(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.L.scheduleScripts(a);
    }

    @GetMapping
    public Collection<RepeatableScript> getScripts(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.d.m_aa();
        }
        return this.d.m_la(a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.L.cancelScripts(a);
    }

    @GetMapping(value={"/{scriptId}/status"})
    public c_hm getScriptStatus(@PathVariable(value="scriptId") Integer a) {
        return this.L.getScriptStatus(a);
    }

    @GetMapping(value={"/summary"})
    public Collection<RepeatableScriptSummary> getScriptsSummary(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.d.m_am();
        }
        return this.d.m_gm(a);
    }

    @PostMapping
    public ResponseEntity<RepeatableScript> createScript(@Valid @RequestBody RepeatableScript script, UriComponentsBuilder a) {
        script = this.d.m_nd(script);
        Object[] objectArray = new Object[1];
        objectArray[0] = script.getId();
        return ResponseEntity.created((URI)a.path(SpaceFilterAspect.m_ck((Object)"`n<v=|?a\u0006q2")).buildAndExpand(objectArray).toUri()).body((Object)script);
    }

    public ScriptController(c_sg a, ScriptManager a2, c_pf a3, c_cd a4, c_ll a5) {
        ScriptController a6;
        ScriptController scriptController = a6;
        super(a4, EnumSet.of(c_ao.N), a5);
        a6.d = a;
        scriptController.L = a2;
        scriptController.g = a3;
    }

    @GetMapping(value={"/{scriptId}"})
    public RepeatableScript getScript(@PathVariable(value="scriptId") Integer a) {
        return this.d.m_ya(a);
    }

    @PostMapping(value={"/{scriptId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="scriptId") Integer a) {
        this.L.cancelScript(a);
    }

    @PatchMapping(value={"/{scriptId}/code"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScriptCode(@PathVariable(value="scriptId") Integer scriptId, @RequestBody String a) {
        this.d.m_hn(scriptId, a);
    }
}

