/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.services;

import com.inscada.mono.auth.c_kka;
import com.inscada.mono.auth.restcontrollers.AuthController;
import com.inscada.mono.cluster.k.c_vha;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_j;
import com.inscada.mono.job.model.DailyJob;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.MonthlyJob;
import com.inscada.mono.job.w.c_od;
import com.inscada.mono.log.model.LogEntryFilter;
import com.inscada.mono.log.services.c_ng;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.report.enums.c_ae;
import com.inscada.mono.report.enums.c_oj;
import com.inscada.mono.report.events.CancelEvent;
import com.inscada.mono.report.events.RescheduleEvent;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.services.c_hn;
import com.inscada.mono.report.services.c_qg;
import com.inscada.mono.shared.exceptions.c_ch;
import com.inscada.mono.shared.exceptions.c_ua;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ReportManager
implements ClusterNodeListener {
    public static final short H = 504;
    public static final short A = 506;
    private static final String i = "scheduledReports";
    public static final short G = 507;
    private static final Logger J = LoggerFactory.getLogger(ReportManager.class);
    private final Map<Integer, List<Job>> e;
    private final c_hn a;
    private final c_od k;
    public static final short b = 503;
    private final c_qg l;
    private final JedisPooled m;
    public static final short M = 502;
    public static final short j = 501;
    public static final short E = 505;
    private final Lock L;
    private final c_j d;
    private final c_ng g;

    protected void cancelReportsByProjectIdInternal(Integer a) {
        ReportManager a2;
        if ((a = a2.l.m_la((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelReportInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(Integer a, String a2) {
        ReportManager a3;
        ReportManager reportManager = a3;
        reportManager.cancelReport(reportManager.l.m_ho(a, a2).getId());
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            Report report = a.getReport();
            J.info(LogEntryFilter.m_ck((Object)"zWwVs@\f2~sXvZ{Xu\u0016@SaUzSvC~SW@wXf\u0016tY`\u0016`SbY`B(\u0016iK2\u001e[r(\u0016iK;"), (Object)report.getName(), (Object)report.getId());
            if (a2.getReportStatusInternal(report.getId()) == c_oj.E) {
                a2.scheduleReportInternal(report.getId());
                return;
            }
        } else {
            J.debug(AuthController.m_ck((Object)"l_l=nUcTgB\u00180kwL\u007fPyLw\u0002BGcAxGtW|GUTuLd\u0002vMb\u0002bG`MbV*\u0002k_"), (Object)a.getReport().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_oj getReportStatus(Integer a, String a2) {
        ReportManager a3;
        if ((a = a3.l.m_dg(a, a2)) == null) {
            return c_oj.g;
        }
        return a3.getReportStatus(a.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scheduleReportInternal$4(Report a) {
        a.L.lock();
        try {
            block11: {
                block12: {
                    block10: {
                        a.cancelReportInternal(a);
                        if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                            throw new c_ch("Project should be active to schedule report " + a.getName());
                        }
                        var2_3 = new ArrayList<MonthlyJob>();
                        try {
                            if (!Boolean.TRUE.equals(a.getPrintFlag())) break block10;
                            var3_4 = a.getPeriod() == c_ae.M ? a.scheduleMonthlyPrintReportJob(a) : a.scheduleDailyPrintReportJob(a);
                        }
                        catch (Exception var3_5) {
                            v0 = var4_6 = var2_3.iterator();
                            while (v0.hasNext()) {
                                var5_7 = (Job)var4_6.next();
                                v0 = var4_6;
                                a.k.m_vaa(var5_7);
                            }
                            throw new c_ua(LogEntryFilter.m_ck((Object)"TW{ZwR2B}\u0016aUzSvC~S2DwF}Df"), (Throwable)var3_5);
                        }
                        var2_3.add(var3_4);
                    }
                    if (!Boolean.TRUE.equals(a.getMailFlag())) break block11;
                    if (a.getPeriod() != c_ae.M) break block12;
                    v1 = a.scheduleMonthlyMailReportJob(a);
                    ** GOTO lbl28
                }
                v1 = a.scheduleDailyMailReportJob(a);
lbl28:
                // 2 sources

                var3_4 = v1;
                var2_3.add(var3_4);
            }
            v2 = a;
            v2.e.put(a.getId(), var2_3);
            v3 = new String[1];
            v3[0] = a.getId().toString();
            v2.m.sadd("scheduledReports", v3);
            return;
        }
        finally {
            a.L.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReports(Integer a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            J.debug(AuthController.m_ck((Object)"\\gQfUp*\u0002CAxGtW|K~E0C|N0PuR\u007fPdQ0D\u007fP0RbMzGsV0Ym\u0002|MsC|Ni\f"), (Object)a);
            a2.scheduleReportsByProjectIdInternal(a);
            return;
        }
        J.debug(LogEntryFilter.m_ck((Object)"\\y\\\u001b^sSrWd(\u0016@ScCwEf_|Q2ZwWvS`\u0016fY2Eq^wRgZw\u0016sZ~\u0016`SbY`Ba\u0016tY`\u0016bD}\\wUf\u0016iK<"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.d.m_sb(Short.valueOf((short)504), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC schedule reports for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$restoreSingleReportOnLeader$1(String a, Report a2) {
        ReportManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            J.info(AuthController.m_ck((Object)"BG`MbV]C~CwGb\u00028nuCtGb\u0002k_9\u00180puQdMbK~E0PuR\u007fPd\u00180Ym\u00028kT\u00180Ym\u000b"), objectArray);
            a3.scheduleReportInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.g.m_lga(a2.getProject()).m_c("Report Restore (Leader " + a + ")", String.format(LogEntryFilter.m_ck((Object)"\u0013a\u0016:\u007fV\f2\u0013v\u001f2Ps_~Sv\u0016fY2DwEfY`S<\u0016QWgEw\f2\u0013a"), objectArray));
            try {
                J.warn(AuthController.m_ck((Object)"BG`MbV]C~CwGb\u00028nuCtGb\u0002k_9\u00180cdVuO`VyLw\u0002dM0AqLsG|\u0002bG`MbV0Ym\u0002qDdGb\u0002bGcV\u007fPqVyM~\u0002vCyNePu\f"), (Object)a, (Object)a2.getId());
                a3.cancelReportInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                J.error(LogEntryFilter.m_ck((Object)"@SbY`B_W|WuS`\u0016:zwWvS`\u0016iK;\f2ps_~Sv\u0016fY2UsXqS~\u0016`SbY`B2Mo\u0016sPfS`\u0016`SaB}DsB{Y|\u0016tW{ZgDw\f2Mo"), objectArray2);
                return;
            }
        }
    }

    protected Map<Integer, c_oj> getReportStatusesByProjectIdInternal(Integer a2) {
        ReportManager a3;
        if ((a2 = a3.l.m_la((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Report::getId, a -> {
            ReportManager a2;
            return a2.getReportStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ReportManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.d.m_yb((short)501, (Object)a, ReportManager.class.getDeclaredMethod(AuthController.m_ck((Object)"cAxGtW|GBG`MbVYLdGbLqN"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.d.m_yb((short)502, (Object)a, ReportManager.class.getDeclaredMethod(LogEntryFilter.m_ck((Object)"UsXqS~dwF}Df\u007f|BwD|W~"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.d.m_yb((short)503, (Object)a, ReportManager.class.getDeclaredMethod(AuthController.m_ck((Object)"EuVBG`MbVCVqVeQYLdGbLqN"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.d.m_yb((short)504, (Object)a, ReportManager.class.getDeclaredMethod(LogEntryFilter.m_ck((Object)"Eq^wRgZwdwF}DfEPOBD}\\wUf\u007fv\u007f|BwD|W~"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.d.m_yb((short)505, (Object)a, ReportManager.class.getDeclaredMethod(AuthController.m_ck((Object)"sC~AuNBG`MbVc`irbMzGsVYFYLdGbLqN"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.d.m_yb((short)506, (Object)a, ReportManager.class.getDeclaredMethod(LogEntryFilter.m_ck((Object)"QwB@SbY`BABsBgEwEPO[Ra\u007f|BwD|W~"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.d.m_yb((short)507, (Object)a, ReportManager.class.getDeclaredMethod(AuthController.m_ck((Object)"wGdpuR\u007fPdqdCdWcGc`irbMzGsVYFYLdGbLqN"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(LogEntryFilter.m_ck((Object)"ps_~Sv\u0016fY2DwQ{EfS`\u0016@SbY`B_W|WuS`\u0016@fQ\u0016\u007fSf^}Ra"), noSuchMethodException);
        }
    }

    protected c_oj getReportStatusInternal(Integer a) {
        ReportManager a2;
        if (a2.e.containsKey(a)) {
            return c_oj.E;
        }
        return c_oj.g;
    }

    public ReportManager(c_qg a, c_od a2, c_hn a3, c_ng a4, JedisPooled a5, c_j a6) {
        ReportManager a7;
        ReportManager reportManager = a7;
        ReportManager reportManager2 = a7;
        ReportManager reportManager3 = a7;
        ReportManager reportManager4 = a7;
        a7.L = new ReentrantLock();
        reportManager4.e = new ConcurrentHashMap();
        reportManager3.l = a;
        reportManager3.k = a2;
        reportManager2.a = a3;
        reportManager2.g = a4;
        reportManager.m = a5;
        reportManager.d = a6;
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(Integer a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            J.debug(AuthController.m_ck((Object)"nUcTgB\u00180qsJuFeNyLw\u0002bG`MbV0Ym\u0002|MsC|Ni\f"), (Object)a);
            a2.scheduleReportInternal(a);
            return;
        }
        J.debug(LogEntryFilter.m_ck((Object)"x]x?zWwVs@\f2dwGgSaB{Xu\u0016~SsRwD2B}\u0016aUzSvC~S2DwF}Df\u0016iK<"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.d.m_sb(Short.valueOf((short)501), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC schedule report " + a, (Throwable)exception);
        }
    }

    protected Map<Integer, c_oj> getReportStatusesByIdsInternal(List<Integer> a) {
        ReportManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getReportStatusInternal(arg_0)));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ReportManager a;
        ReportManager reportManager = a;
        reportManager.registerRemoteCallsWithClusterNode();
        reportManager.d.m_sa((ClusterNodeListener)a);
        J.info(AuthController.m_ck((Object)"BG`MbV]C~CwGb\u0002yLyVyC|KjGt\u0002qLt\u0002bGwKcVuPuF0Cc\u0002SNeQdGbl\u007fFunyQdG~Gb\f"));
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyMailReportJob(Report a) {
        ReportManager a2;
        return a2.k.m_cga(a.getProject(), "Report Mail - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            comparable.set(5, a.getReportDay().shortValue());
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(2, -1);
            Date date = calendar.getTime();
            a2.a.m_ws(a.getId(), date, (Date)comparable, true, a.getLang());
        }, (int)a.getMailDay().shortValue(), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    protected void scheduleReportsByProjectIdInternal(Integer a) {
        ReportManager a2;
        if ((a = a2.l.m_la((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleReportInternal(arg_0));
    }

    private /* synthetic */ DailyJob scheduleDailyMailReportJob(Report a) {
        ReportManager a2;
        return a2.k.m_sba(a.getProject(), "Report Mail - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(5, -1);
            Date date = calendar.getTime();
            a2.a.m_ws(a.getId(), date, (Date)comparable, true, a.getLang());
        }, LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    public void notLeader() {
        ReportManager a;
        ReportManager reportManager = a;
        String string = reportManager.d.m_gb().getNodeId();
        J.info(LogEntryFilter.m_ck((Object)"dwF}Df{sXsQwD(\u0016F^{E2X}Rw\u0016:Mo\u001f2_a\u0016\\y2z]xUs@\u0016F~W\u0016^sSrWd<\u0016QW|UwZ~_|Q2W~Z2Z}UsZ2DwF}Df\u0016xYpE<\u0018<"), (Object)string);
        reportManager.L.lock();
        try {
            new ArrayList(a.e.keySet()).forEach(a2 -> {
                ReportManager a3;
                List list = (List)a3.e.get(a2);
                if (list != null) {
                    try {
                        J.info(LogEntryFilter.m_ck((Object)"@SbY`B_W|WuS`\u0016:x}B2zwWvS`\u0016iK;\f2usXqS~Z{Xu\u0016~YqW~\u0016xYp\u0016tY`\u0016`SbY`B2\u007fV\f2Mo"), (Object)string, a2);
                        list.forEach(arg_0 -> ((c_od)a3.k).m_vaa(arg_0));
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        J.error(AuthController.m_ck((Object)"BG`MbV]C~CwGb\u00028l\u007fV0nuCtGb\u0002k_9\u00180gbP\u007fP0AqLsG|NyLw\u0002|MsC|\u0002zMr\u0002vMb\u0002bG`MbV0kT\u0002k_*\u0002k_"), objectArray);
                    }
                }
            });
            a.e.clear();
            J.info(AuthController.m_ck((Object)"puR\u007fPdoqLqEuP0\n^Md\u0002\\GqFuP0Ym\u000b*\u0002QN|\u0002|MsC|\u0002bG`MbV0H\u007f@c\u0002xCfG0@uG~\u0002bGaWuQdGt\u0002dM0AqLsG|\u0002qLt\u0002sNuCbGt\u0002vP\u007fO0N\u007fAqN0VbCsIyLw\f"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            J.error(LogEntryFilter.m_ck((Object)"@SbY`B_W|WuS`\u0016:x}B2zwWvS`\u0016iK;\f2s`D}D2RgD{Xu\u0016bD}UwEa\u0016}P2UsXqS~Z{Xu\u0016~YqW~\u0016`SbY`B2\\}Ta\f2Mo"), objectArray);
            return;
        }
        finally {
            a.L.unlock();
        }
    }

    private /* synthetic */ DailyJob scheduleDailyPrintReportJob(Report a) {
        ReportManager a2;
        return a2.k.m_sba(a.getProject(), "Report Print - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(5, -1);
            Date date = calendar.getTime();
            a2.a.m_gw(a.getId(), date, (Date)comparable, true, a.getLang());
        }, LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            Report report = a.getReport();
            J.info(AuthController.m_ck((Object)"\\gQfUp*\u0002XC~F|K~E0aqLsG|gfG~V0D\u007fP0PuR\u007fPd\u00180Ym\u00028kT\u00180Ym\u000b"), (Object)report.getName(), (Object)report.getId());
            a2.cancelReportInternal(report);
            return;
        }
        J.debug(LogEntryFilter.m_ck((Object)"\\y\\\u001b^sSrWd(\u0016[Q|Y`_|Q2usXqS~sdS|B2P}D2DwF}Df\f2Mo"), (Object)a.getReport().getId());
    }

    protected void cancelReportInternal(Integer a) {
        ReportManager a2;
        ReportManager reportManager = a2;
        reportManager.cancelReportInternal(reportManager.l.m_wj(a));
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyPrintReportJob(Report a) {
        ReportManager a2;
        return a2.k.m_cga(a.getProject(), "Report Print - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            comparable.set(5, a.getReportDay().shortValue());
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(2, -1);
            Date date = calendar.getTime();
            a2.a.m_gw(a.getId(), date, (Date)comparable, true, a.getLang());
        }, (int)a.getPrintDay().shortValue(), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    protected void scheduleReportInternal(Integer a) {
        ReportManager a2;
        ReportManager reportManager = a2;
        reportManager.scheduleReportInternal(reportManager.l.m_wj(a));
    }

    @Order(value=3)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            Integer n = a.getProject().getId();
            J.info(AuthController.m_ck((Object)"\\gQfUp*\u0002XC~F|K~E0rbMzGsVTGqAdKfCdGUTuLd\u0002vMb\u0002`P\u007fHuAd\u0002Yf*\u0002k_"), (Object)n);
            a2.cancelReportsByProjectIdInternal(n);
            return;
        }
        J.debug(LogEntryFilter.m_ck((Object)"x]x?zWwVs@\f2\u007fuX}D{Xu\u0016BD}\\wUfrwWqB{@sBwsdS|B2P}D2F`YxSqB2\u007fV\f2Mo"), (Object)a.getProject().getId());
    }

    protected void scheduleReportInternal(Report a) {
        ReportManager a2;
        c_kka.m_kvb(() -> a2.lambda$scheduleReportInternal$4(a), (OwnedSpaceBaseModel)a);
    }

    protected void cancelReportInternal(Report a) {
        ReportManager a2;
        c_kka.m_kvb(() -> {
            ReportManager a2;
            a2.L.lock();
            try {
                Object object = (List)a2.e.get(a.getId());
                if (object != null) {
                    Object object2 = object = object.iterator();
                    while (object2.hasNext()) {
                        Job job = (Job)object.next();
                        object2 = object;
                        a2.k.m_vaa(job);
                    }
                }
                ReportManager reportManager = a2;
                reportManager.e.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                reportManager.m.srem(i, stringArray);
                return;
            }
            finally {
                a2.L.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<Integer, c_oj> getReportStatuses(List<Integer> a) {
        ReportManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.d.m_hb()) {
            J.debug(AuthController.m_ck((Object)"\\gQfUp*\u0002WGdVyLw\u0002bG`MbV0QdCdWcGc\u0002vMb\u0002k_0kTQ0N\u007fAqN|[*\u0002k_"), (Object)a.size(), a);
            return a2.getReportStatusesByIdsInternal(a);
        }
        J.debug(LogEntryFilter.m_ck((Object)"x]x?zWwVs@\f2dwGgSaB{Xu\u0016~SsRwD2P}D2DwF}Df\u0016aBsBgEwE2P}D2Mo\u0016[ra\f2Mo"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.d.m_sb(Short.valueOf((short)506), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get report statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(AuthController.m_ck((Object)"\u000e"))), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<Integer, c_oj> getReportStatuses(Integer a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            J.debug(LogEntryFilter.m_ck((Object)"^sSrWd(\u0016USfB{Xu\u0016sZ~\u0016`SbY`B2EfWfCaSa\u0016tY`\u0016bD}\\wUf\u0016iK2Z}UsZ~O<"), (Object)a);
            return a2.getReportStatusesByProjectIdInternal(a);
        }
        J.debug(AuthController.m_ck((Object)"l_l=nUcTgB\u00180puSeGcVyLw\u0002|GqFuP0D\u007fP0C|N0PuR\u007fPd\u0002cVqVeQuQ0D\u007fP0RbMzGsV0Ym\f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.d.m_sb(Short.valueOf((short)507), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReports(Integer a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            J.debug(LogEntryFilter.m_ck((Object)"zWwVs@\f2usXqS~Z{Xu\u0016sZ~\u0016`SbY`Ba\u0016tY`\u0016bD}\\wUf\u0016iK2Z}UsZ~O<"), (Object)a);
            a2.cancelReportsByProjectIdInternal(a);
            return;
        }
        J.debug(AuthController.m_ck((Object)"l_l=nUcTgB\u00180puSeGcVyLw\u0002|GqFuP0V\u007f\u0002sC~AuN0C|N0PuR\u007fPdQ0D\u007fP0RbMzGsV0Ym\f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.d.m_sb(Short.valueOf((short)505), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC cancel reports for project " + a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ReportManager a2;
        ReportManager reportManager = a2;
        String string = reportManager.d.m_gb().getNodeId();
        J.info(LogEntryFilter.m_ck((Object)"@SbY`B_W|WuS`\f2bz_a\u0016|YvS2\u001eiK;\u0016zWa\u0016pSqY\u007fS2BzS2zWwVs@\u00182dwEfY`_|Q2Eq^wRgZwR2DwF}DfE<\u0018<"), (Object)string);
        reportManager.L.lock();
        try {
            Set set = a2.m.smembers(i).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                J.info(AuthController.m_ck((Object)"BG`MbV]C~CwGb\u00028nuCtGb\u0002k_9\u00180l\u007f\u0002cAxGtW|Gt\u0002bG`MbVc\u0002vMeLt\u0002yL0puFyQ0V\u007f\u0002bGcV\u007fPu\f"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            J.info(LogEntryFilter.m_ck((Object)"dwF}Df{sXsQwD2\u001e^SsRwD2Mo\u001f(\u0016TYgXv\u0016iK2Eq^wRgZwR2DwF}Df\u0016[ra\u0016{X2dwR{E2B}\u0016`SaB}Dw\f2Mo"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = AuthController.m_ck((Object)"FkUuOpUr_pD}YvUo");
            c_kka.m_occ(() -> {
                ReportManager a3;
                arrayList.addAll(a3.l.m_te(set));
            }, (String[])stringArray);
            J.info(LogEntryFilter.m_ck((Object)"dwF}Df{sXsQwD2\u001e^SsRwD2Mo\u001f(\u0016SBfS\u007fFf_|Q2B}\u0016`SaB}Dw\u0016iK2DwF}DfE<"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ReportManager a2;
                ReportManager reportManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = AuthController.m_ck((Object)"qSjUfEnU}Bg@mBv");
                stringArray[1] = LogEntryFilter.m_ck((Object)"Qw\\uWzMdWf]dF");
                c_kka.m_byb(() -> reportManager.lambda$restoreSingleReportOnLeader$1(reportManager.d.m_gb().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            J.info(AuthController.m_ck((Object)"puR\u007fPdoqLqEuP0\n\\GqFuP0Ym\u000b*\u0002VK~KcJuF0PuR\u007fPd\u0002bGcV\u007fPqVyM~\u0002`P\u007fAuQc\f"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            J.error(LogEntryFilter.m_ck((Object)"dwF}Df{sXsQwD2\u001e^SsRwD2Mo\u001f(\u0016WD`Y`\u0016vC`_|Q2DwF}Df\u0016`SaB}DsB{Y|\u0016bD}UwEa\f2Mo"), objectArray);
            return;
        }
        finally {
            a2.L.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_oj getReportStatus(Integer a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            J.debug(AuthController.m_ck((Object)"nUcTgB\u00180euVdK~E0PuR\u007fPd\u0002cVqVeQ0D\u007fP0kT\u00180Ym\u0002|MsC|Ni\f"), (Object)a);
            return a2.getReportStatusInternal(a);
        }
        J.debug(LogEntryFilter.m_ck((Object)"\\y\\\u001b^sSrWd(\u0016@ScCwEf_|Q2ZwWvS`\u0016tY`\u0016`SbY`B2EfWfCa\u0016tY`\u0016[r(\u0016iK<"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_oj)a2.d.m_sb(Short.valueOf((short)503), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get report transfer status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(Integer a) {
        ReportManager a2;
        if (a2.d.m_hb()) {
            J.debug(AuthController.m_ck((Object)"nUcTgB\u00180aqLsG|NyLw\u0002bG`MbV0Ym\u0002|MsC|Ni\f"), (Object)a);
            a2.cancelReportInternal(a);
            return;
        }
        J.debug(LogEntryFilter.m_ck((Object)"x]x?zWwVs@\f2dwGgSaB{Xu\u0016~SsRwD2B}\u0016qW|UwZ2DwF}Df\u0016iK<"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.d.m_sb(Short.valueOf((short)502), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC cancel report " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(Integer a, String a2) {
        ReportManager a3;
        ReportManager reportManager = a3;
        reportManager.scheduleReport(reportManager.l.m_ho(a, a2).getId());
    }
}

