/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.restcontrollers;

import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.broadcast.model.BroadcastOperationResponse;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.report.enums.c_oj;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.report.model.ReportVariable;
import com.inscada.mono.report.services.ReportManager;
import com.inscada.mono.report.services.c_hn;
import com.inscada.mono.report.services.c_qg;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/reports"})
public class ReportController
extends ProjectBasedImportExportController {
    private final c_hn L;
    private final c_qg d;
    private final ReportManager g;

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public Collection<ReportSubgroup> getReportSubgroups(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.d.m_rr(reportId, a);
    }

    @DeleteMapping(value={"/groups/subgroups/variables"}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.d.m_qq(List.of(a));
    }

    @GetMapping
    public Collection<Report> getReports(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.d.m_aa();
        }
        return this.d.m_la(a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public ResponseEntity<ReportVariable> createReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportVariable reportVariable, UriComponentsBuilder a) {
        reportVariable = this.d.m_wr(reportId, groupId, subgroupId, reportVariable);
        Object[] objectArray = new Object[4];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = subgroupId;
        objectArray[3] = reportVariable.getId();
        return ResponseEntity.created((URI)a.path(AlarmFilter.m_ck((Object)"O%\u0012;\u00101\u0012*):\u001dq\u0007,\u000f+\u0010-O%\u0007,\u000f+\u0010\u0017\u0004#O-\u0015<\u0007,\u000f+\u0010-O%\u0013+\u00029\u00121\u0015.):\u001dq\u0016?\u00127\u0001<\f;\u0013q\u001b(\u0001,\t?\u00022\u0005\u0017\u0004#")).buildAndExpand(objectArray).toUri()).body((Object)reportVariable);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public Collection<ReportVariable> getReportVariables(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.d.m_lw(reportId, groupId, a);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody ReportVariable a) {
        this.d.m_zy(reportId, groupId, subgroupId, variableId, a);
    }

    @PostMapping(value={"/{reportId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReport(@PathVariable(value="reportId") Integer a) {
        this.g.scheduleReport(a);
    }

    @GetMapping(value={"/{reportId}/excelExport"})
    public ResponseEntity<byte[]> exportToExcel(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.L.m_tp(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = AlarmFilter.m_ck((Object)"?\u0014*\u0001=\b3\u00050\u0014e@8\t2\u00050\u00013\u0005cB\f\u0005.\u000f,\u0014p\u00182\u0013|");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(BroadcastOperationResponse.m_ck((Object)"\u001dt0o;u*6\u001ar-k1h7o7t0"), stringArray)).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        this.d.m_kt(reportId, a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public ResponseEntity<ReportSubgroup> createReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportSubgroup reportSubgroup, UriComponentsBuilder a) {
        reportSubgroup = this.d.m_ot(reportId, groupId, reportSubgroup);
        Object[] objectArray = new Object[3];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = reportSubgroup.getId();
        return ResponseEntity.created((URI)a.path(BroadcastOperationResponse.m_ck((Object)"q`,~.t,o\u0017\u007f#49i1n.hq`9i1n.R:fqh+y9i1n.hq`-n<|,t+k\u0017\u007f#")).buildAndExpand(objectArray).toUri()).body((Object)reportSubgroup);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportSubgroup a) {
        this.d.m_yz(reportId, groupId, subgroupId, a);
    }

    @PostMapping(value={"/cancel"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReports(@RequestParam(value="projectId") Integer a) {
        this.g.cancelReports(a);
    }

    @DeleteMapping(value={""}, params={"reportIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportsByIds(@RequestParam(value="reportIds") Integer[] a) {
        this.d.m_ed(List.of(a));
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        this.d.m_sy(reportId, groupId, a);
    }

    @DeleteMapping(value={"/groups"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.d.m_ur(List.of(a));
    }

    public ReportController(c_qg a, ReportManager a2, c_hn a3, c_cd a4, c_ll a5) {
        ReportController a6;
        ReportController reportController = a6;
        super(a4, EnumSet.of(c_ao.B), a5);
        a6.d = a;
        reportController.g = a2;
        reportController.L = a3;
    }

    @GetMapping(value={"/{reportId}/preview"})
    public ResponseEntity<byte[]> previewReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.L.m_ar(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = BroadcastOperationResponse.m_ck((Object)"?o*z=s3~0oe;8r2~0z3~c9,~.t,opk:}|");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(AlarmFilter.m_ck((Object)"\u001d\u000f0\u0014;\u000e*M\u001a\t-\u00101\u00137\u00147\u000f0"), stringArray)).contentType(MediaType.APPLICATION_PDF).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @PostMapping
    public ResponseEntity<Report> createReport(@Valid @RequestBody Report report, UriComponentsBuilder a) {
        report = this.d.m_iq(report);
        Object[] objectArray = new Object[1];
        objectArray[0] = report.getId();
        return ResponseEntity.created((URI)a.path(AlarmFilter.m_ck((Object)"q\u001b,\u0005.\u000f,\u0014\u0017\u0004#")).buildAndExpand(objectArray).toUri()).body((Object)report);
    }

    @PostMapping(value={"/{reportId}/mail"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void mailReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.L.m_ws(reportId, startDate, endDate, false, a);
    }

    @PostMapping(value={"/{reportId}/print"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void printReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.L.m_gw(reportId, startDate, endDate, false, a);
    }

    @PostMapping(value={"/{reportId}/groups"})
    public ResponseEntity<ReportGroup> createReportGroup(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody ReportGroup reportGroup, UriComponentsBuilder a) {
        reportGroup = this.d.m_bx(reportId, reportGroup);
        Object[] objectArray = new Object[2];
        objectArray[0] = reportId;
        objectArray[1] = reportGroup.getId();
        return ResponseEntity.created((URI)a.path(BroadcastOperationResponse.m_ck((Object)"4%i;k1i*R:fq|,t+k-4%|,t+k\u0017\u007f#")).buildAndExpand(objectArray).toUri()).body((Object)reportGroup);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}"})
    public ReportGroup getReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.d.m_ku(reportId, a);
    }

    @PutMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReport(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody Report a) {
        this.d.m_nt(reportId, a);
    }

    @GetMapping(value={"/{reportId}"})
    public Report getReport(@PathVariable(value="reportId") Integer a) {
        return this.d.m_ya(a);
    }

    @GetMapping(value={"/{reportId}/groups"})
    public Collection<ReportGroup> getReportGroups(@PathVariable(value="reportId") Integer a) {
        return this.d.m_cx(a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    public ReportSubgroup getReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.d.m_eq(reportId, groupId, a);
    }

    @PostMapping(value={"/{reportId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReport(@PathVariable(value="reportId") Integer a) {
        this.g.cancelReport(a);
    }

    @DeleteMapping(value={"/groups/subgroups"}, params={"subgroupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubgroupsByIds(@RequestParam(value="subgroupIds") Integer[] a) {
        this.d.m_fx(List.of(a));
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    public ReportVariable getReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        return this.d.m_wt(reportId, groupId, subgroupId, a);
    }

    @GetMapping(value={"/{reportId}/status"})
    public c_oj getReportStatus(@PathVariable(value="reportId") Integer a) {
        return this.g.getReportStatus(a);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportGroup a) {
        this.d.m_cz(reportId, groupId, a);
    }

    @GetMapping(value={"/statuses"})
    public Map<Integer, c_oj> getReportStatuses(@RequestParam(value="reportIds") Integer[] a) {
        return this.g.getReportStatuses(Arrays.asList(a));
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        this.d.m_hy(reportId, groupId, subgroupId, a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReports(@RequestParam(value="projectId") Integer a) {
        this.g.scheduleReports(a);
    }

    @DeleteMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReport(@PathVariable(value="reportId") Integer a) {
        this.d.m_qa(a);
    }
}

