/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="report_group")
@CheckAtLeastOneNotNull(fieldNames={"reportId", "report"})
public class ReportGroup
extends SpaceBaseModel {
    @JsonIgnore
    @OneToMany(mappedBy="reportGroup", orphanRemoval=true)
    private Set<ReportSubgroup> reportSubgroups;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="report_id")
    private Report report;
    @Id
    @Column(name="report_group_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="reportGroupSeq")
    @GenericGenerator(name="reportGroupSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="report_group_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Column(name="report_id", updatable=false, insertable=false)
    private Integer reportId;
    @NotNull
    @Min(value=1L)
    @Column(name="group_order")
    private Short groupOrder;
    @NotBlank
    @Size(max=100)
    private String name;

    public Short getGroupOrder() {
        ReportGroup a;
        return a.groupOrder;
    }

    public void setReport(Report a) {
        ReportGroup a2;
        ReportGroup reportGroup = a2;
        reportGroup.report = a;
        reportGroup.reportId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setName(String a) {
        a.name = a;
    }

    public ReportGroup() {
        ReportGroup a;
        ReportGroup reportGroup = a;
        reportGroup.reportSubgroups = new HashSet();
    }

    public Report getReport() {
        ReportGroup a;
        return a.report;
    }

    public Integer getId() {
        ReportGroup a;
        return a.id;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public int hashCode() {
        ReportGroup a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        objectArray[2] = a.getReportId();
        return Objects.hash(objectArray);
    }

    public Set<ReportSubgroup> getReportSubgroups() {
        ReportGroup a;
        return a.reportSubgroups;
    }

    public Integer getReportId() {
        ReportGroup a;
        return a.reportId;
    }

    public String getName() {
        ReportGroup a;
        return a.name;
    }

    public void setReportId(Integer a) {
        a.reportId = a;
    }

    public void setGroupOrder(Short a) {
        a.groupOrder = a;
    }

    public boolean equals(Object a) {
        ReportGroup a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof ReportGroup)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (ReportGroup)a;
        return a2.getName().equals(a.getName()) && a2.getReportId().equals(a.getReportId());
    }

    public void setReportSubgroups(Set<ReportSubgroup> a) {
        a.reportSubgroups = a;
    }
}

