/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.restcontrollers;

import com.inscada.mono.broadcast.model.Broadcast;
import com.inscada.mono.impexp.model.ImportResult;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.project.k.c_yf;
import com.inscada.mono.project.k.c_zg;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.project.model.ProjectClone;
import com.inscada.mono.project.model.ProjectLocationDto;
import com.inscada.mono.project.model.ProjectStatus;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/projects"})
public class ProjectController
extends ProjectBasedImportExportController {
    private final c_yf d;
    private final c_ll g;
    private final c_zg g;

    @PutMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProject(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody Project a) {
        this.g.m_hq(projectId, a);
    }

    @GetMapping(value={"/{projectId}"})
    public Project getProject(@PathVariable(value="projectId") Integer a) {
        return this.g.m_ya(a);
    }

    @PatchMapping(value={"/{projectId}/location"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProjectLocation(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody ProjectLocationDto a) {
        this.g.m_gr(projectId, a.getLatitude(), a.getLongitude());
    }

    @DeleteMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteProject(@PathVariable(value="projectId") Integer a) {
        this.g.m_qa(a);
    }

    @GetMapping(value={"/name"}, params={"name"})
    public Project getProject(@RequestParam(name="name") String a) {
        return this.g.m_zl(a);
    }

    @PostMapping(value={"/clone"})
    public ImportResult cloneProject(@Valid @RequestBody ProjectClone projectClone, @RequestParam(name="includeProjectAttachments", required=false) Boolean a) throws IOException {
        projectClone.setIncludeProjectAttachments(a);
        return this.g.m_dt(projectClone);
    }

    @GetMapping
    public Collection<Project> getProjects(@RequestParam(name="isActive", required=false) Boolean a) {
        if (a == null) {
            return this.g.m_aa();
        }
        return this.g.m_sw(a);
    }

    public ProjectController(c_ll a, c_yf a2, c_zg a3, c_cd a4) {
        ProjectController a5;
        ProjectController projectController = a5;
        super(a4, EnumSet.of(c_ao.X), a);
        a5.g = a;
        projectController.d = a2;
        projectController.g = a3;
    }

    @GetMapping(value={"/{projectId}/status"})
    public ProjectStatus getStatus(@PathVariable(value="projectId") Integer a) {
        return this.d.m_xp(a);
    }

    @PostMapping
    public ResponseEntity<Project> createProject(@Valid @RequestBody Project project, UriComponentsBuilder a) {
        project = this.g.m_iv(project);
        Object[] objectArray = new Object[1];
        objectArray[0] = project.getId();
        return ResponseEntity.created((URI)a.path(Broadcast.m_ck((Object)"!\u0003~\na\u0012k\u001bz1j\u0005")).buildAndExpand(objectArray).toUri()).body((Object)project);
    }
}

