/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="project_attachment")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class ProjectAttachment
extends SpaceBaseModel {
    @NotNull
    @Size(min=0)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private byte[] data;
    @NotBlank
    @Size(max=255)
    @Column(name="file_type")
    private String fileType;
    @NotBlank
    @Size(max=255)
    @Column(name="file_name")
    private String fileName;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @Id
    @Column(name="project_attachment_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="projectAttachmentSeq")
    @GenericGenerator(name="projectAttachmentSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="project_attachment_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @NotBlank
    @Size(max=100)
    private String name;
    @Size(max=255)
    private String dsc;
    @NotNull
    @Min(value=0L)
    @Column(name="file_size")
    private Integer fileSize;

    public int hashCode() {
        ProjectAttachment a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public Integer getId() {
        ProjectAttachment a;
        return a.id;
    }

    public Integer getFileSize() {
        ProjectAttachment a;
        return a.fileSize;
    }

    public ProjectAttachment(Integer a, Integer a2, String a3, String a4, String a5, Integer a6, String a7, Project a8, String a9, Date a10, String a11, Date a12) {
        ProjectAttachment a13;
        ProjectAttachment projectAttachment = a13;
        ProjectAttachment projectAttachment2 = a13;
        ProjectAttachment projectAttachment3 = a13;
        ProjectAttachment projectAttachment4 = a13;
        ProjectAttachment projectAttachment5 = a13;
        ProjectAttachment projectAttachment6 = a13;
        projectAttachment6.id = a;
        projectAttachment6.projectId = a2;
        projectAttachment5.name = a3;
        projectAttachment5.dsc = a4;
        projectAttachment4.fileName = a5;
        projectAttachment4.fileSize = a6;
        projectAttachment3.fileType = a7;
        projectAttachment3.project = a8;
        projectAttachment2.createdBy = a9;
        projectAttachment2.creationDate = a10;
        projectAttachment.lastModifiedBy = a11;
        projectAttachment.lastModifiedDate = a12;
    }

    public boolean equals(Object a) {
        ProjectAttachment a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof ProjectAttachment)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (ProjectAttachment)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public String getFileName() {
        ProjectAttachment a;
        return a.fileName;
    }

    public String getFileType() {
        ProjectAttachment a;
        return a.fileType;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setData(byte[] a) {
        a.data = a;
    }

    public void setProject(Project a) {
        ProjectAttachment a2;
        ProjectAttachment projectAttachment = a2;
        projectAttachment.project = a;
        projectAttachment.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public String getName() {
        ProjectAttachment a;
        return a.name;
    }

    public Integer getProjectId() {
        ProjectAttachment a;
        return a.projectId;
    }

    public void setName(String a) {
        a.name = a;
    }

    public byte[] getData() {
        ProjectAttachment a;
        return a.data;
    }

    public Project getProject() {
        ProjectAttachment a;
        return a.project;
    }

    public void setFileType(String a) {
        a.fileType = a;
    }

    public String getDsc() {
        ProjectAttachment a;
        return a.dsc;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public ProjectAttachment() {
        ProjectAttachment a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setFileName(String a) {
        a.fileName = a;
    }

    public void setFileSize(Integer a) {
        a.fileSize = a;
    }
}

