/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.faceplate.restcontrollers;

import com.inscada.mono.communication.base.template.k.k.c_nm;
import com.inscada.mono.config.c_kh;
import com.inscada.mono.faceplate.k.c_sj;
import com.inscada.mono.faceplate.model.Faceplate;
import com.inscada.mono.faceplate.model.FaceplateElement;
import com.inscada.mono.faceplate.model.FaceplatePlaceholder;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/faceplates"})
public class FaceplateController
extends ProjectBasedImportExportController {
    private final c_sj g;

    @PutMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody FaceplateElement a) {
        this.g.m_saa(faceplateId, elementId, a);
    }

    @DeleteMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        this.g.m_qea(faceplateId, a);
    }

    @PostMapping(value={"/{faceplateId}/elements"})
    public ResponseEntity<FaceplateElement> createFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplateElement faceplateElement, UriComponentsBuilder a) {
        faceplateElement = this.g.m_gha(faceplateId, faceplateElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplateElement.getId();
        return ResponseEntity.created((URI)a.path(c_kh.m_ck((Object)"V\u0002\u001f\u0018\u001a\u001c\t\u0015\u0018\r\u001c0\u001d\u0004V\u001c\u0015\u001c\u0014\u001c\u0017\r\nV\u0002\u001c\u0015\u001c\u0014\u001c\u0017\r0\u001d\u0004")).buildAndExpand(objectArray).toUri()).body((Object)faceplateElement);
    }

    @GetMapping(value={"/{faceplateId}/elements/{elementId}"})
    public FaceplateElement getFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        return this.g.m_cfa(faceplateId, a);
    }

    @PutMapping(value={"/{faceplateId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateSvg(@PathVariable(value="faceplateId") Integer faceplateId, @RequestBody String a) {
        this.g.m_iea(faceplateId, a);
    }

    @PostMapping(value={"/{faceplateId}/clone"}, params={"name"})
    public ResponseEntity<Faceplate> cloneFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        faceplateId = this.g.m_zia(faceplateId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplateId.getId();
        return ResponseEntity.created((URI)a.path(c_nm.m_ck((Object)"Yc\u0010y\u0015}\u0006t\u0017l\u0013Q\u0012e")).buildAndExpand(objectArray).toUri()).body((Object)faceplateId);
    }

    @PutMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer placeholderId, @Valid @RequestBody FaceplatePlaceholder a) {
        this.g.m_gga(faceplateId, placeholderId, a);
    }

    @GetMapping
    public Collection<Faceplate> getFaceplates(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.g.m_aa();
        }
        return this.g.m_la(a);
    }

    @GetMapping(value={"/{faceplateId}/placeholders"})
    public Collection<FaceplatePlaceholder> getFaceplatePlaceholders(@PathVariable(value="faceplateId") Integer a) {
        return this.g.m_yfa(a);
    }

    public FaceplateController(c_sj a, c_cd a2, c_ll a3) {
        super(a2, EnumSet.of(c_ao.j), a3);
        FaceplateController a4;
        a4.g = a;
    }

    @GetMapping(value={"/{faceplateId}/elements"})
    public Collection<FaceplateElement> getFaceplateElements(@PathVariable(value="faceplateId") Integer a) {
        return this.g.m_lja(a);
    }

    @PutMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody Faceplate a) {
        this.g.m_cia(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    public FaceplatePlaceholder getFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        return this.g.m_iaa(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}"})
    public Faceplate getFaceplate(@PathVariable(value="faceplateId") Integer a) {
        return this.g.m_ya(a);
    }

    @PostMapping
    public ResponseEntity<Faceplate> createFaceplate(@Valid @RequestBody Faceplate faceplate, UriComponentsBuilder a) {
        faceplate = this.g.m_dca(faceplate);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplate.getId();
        return ResponseEntity.created((URI)a.path(c_kh.m_ck((Object)"V\u0002\u001f\u0018\u001a\u001c\t\u0015\u0018\r\u001c0\u001d\u0004")).buildAndExpand(objectArray).toUri()).body((Object)faceplate);
    }

    @DeleteMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplate(@PathVariable(value="faceplateId") Integer a) {
        this.g.m_qa(a);
    }

    @DeleteMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        this.g.m_jja(faceplateId, a);
    }

    @DeleteMapping(value={"/{faceplateId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElementsByIds(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(value="elementIds") Integer[] a) {
        this.g.m_lea(faceplateId, a);
    }

    @PostMapping(value={"/{faceplateId}/placeholders"})
    public ResponseEntity<FaceplatePlaceholder> createFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplatePlaceholder faceplatePlaceholder, UriComponentsBuilder a) {
        faceplatePlaceholder = this.g.m_pja(faceplateId, faceplatePlaceholder);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplatePlaceholder.getId();
        return ResponseEntity.created((URI)a.path(c_nm.m_ck((Object)"7\r~\u0017{\u0013h\u001ay\u0002}?|\u000b7\u0006t\u0017{\u0013p\u0019t\u0012}\u0004kYc\u0013t\u0013u\u0013v\u0002Q\u0012e")).buildAndExpand(objectArray).toUri()).body((Object)faceplatePlaceholder);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Faceplate> getFaceplatesByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.g.m_nea(projectId, a);
    }

    @GetMapping(value={"/{faceplateId}/svg"})
    public ResponseEntity<InputStreamResource> getFaceplateSvg(@PathVariable(value="faceplateId") Integer a) {
        a = this.g.m_ya(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(c_kh.m_ck((Object)":\u0016\u0017\r\u001c\u0017\rT=\u0010\n\t\u0016\n\u0010\r\u0010\u0016\u0017"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)c_nm.m_ck((Object)"q\u001by\u0011}Yk\u0000\u007f]`\u001bt"))).body((Object)byteArrayInputStream);
    }
}

