/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.alarm.model.CheckedAlarm;
import com.inscada.mono.auth.c_kka;
import com.inscada.mono.cluster.k.c_vha;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_j;
import com.inscada.mono.communication.base.enums.c_ika;
import com.inscada.mono.communication.base.enums.c_vga;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_gga;
import com.inscada.mono.communication.base.services.c_lla;
import com.inscada.mono.communication.base.services.c_uba;
import com.inscada.mono.communication.base.services.k.c_id;
import com.inscada.mono.datatransfer.events.CancelEvent;
import com.inscada.mono.datatransfer.events.RescheduleEvent;
import com.inscada.mono.datatransfer.k.c_hl;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.c_ml;
import com.inscada.mono.datatransfer.services.c_rf;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.job.w.c_od;
import com.inscada.mono.log.services.c_ng;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_ch;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener {
    public static final short C = 405;
    public static final short I = 406;
    private final c_gga H;
    private final c_j A;
    public static final short i = 403;
    private final Lock G;
    public static final short J = 401;
    public static final short e = 407;
    private final c_od a;
    private final c_lla k;
    private final c_uba b;
    private final c_rf l;
    private final Map<Integer, Job> m;
    private static final String M = "scheduledDataTransfers";
    public static final short j = 402;
    private final JedisPooled E;
    private static final Logger L = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short d = 404;
    private final c_ng g;

    protected Map<Integer, c_hl> getDataTransferStatusesByProjectIdInternal(Integer a2) {
        DataTransferManager a3;
        if ((a2 = a3.l.m_la((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(DataTransfer::getId, a -> {
            DataTransferManager a2;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String a, DataTransfer a2) {
        DataTransferManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            L.info(c_id.m_ck((Object)"\u007fQOQoBZ^HV^BvQUQ\\UI\u0010\u0013|^Q_UI\u0010@M\u0012\n\u001bb^CO_IYUW\u001bTZDZ\u0010OBZ^HV^B\u0001\u0010@M\u001b\u0018rt\u0001\u0010@M\u0012"), objectArray);
            a3.scheduleDataTransferInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.g.m_lga(a2.getProject()).m_c("Data Transfer Restore (Leader " + a + ")", String.format(CheckedAlarm.m_ck((Object)"\u0003V\u0006\roa\u001c\u0005\u0003A\u000f\u0005@DOICA\u0006QI\u0005T@UQIWC\u000b\u0006fGPU@\u001c\u0005\u0003V"), objectArray));
            try {
                L.warn(c_id.m_ck((Object)"\u007fQOQoBZ^HV^BvQUQ\\UI\u0010\u0013|^Q_UI\u0010@M\u0012\n\u001bqOD^]KDR^\\\u0010O_\u001bSZ^XUW\u0010_QOQ\u001bDIQUC]UI\u0010@M\u001bQ]D^B\u001bB^CO_IQOYT^\u001bVZYWEIU\u0015"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                L.error(CheckedAlarm.m_ck((Object)"bDRDrWGKUCCWkDHDA@T\u0005\u000eiCDB@T\u0005]X\u000f\u001f\u0006cGLJ@B\u0005RJ\u0006FGKE@J\u0005BDRD\u0006QTDHV@@T\u0005]X\u0006D@QCW\u0006WCVRJTDRLIK\u0006CGLJPT@\u001c\u0005]X"), objectArray2);
                return;
            }
        }
    }

    private /* synthetic */ void lambda$handleCurrentValues$10(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        a = (VariableValue)a.get(a5.getSourceVariableId());
        a2 = (VariableValue)a2.get(a5.getTargetVariableId());
        a3 = (Variable)a3.get(a5.getTargetVariableId());
        if (a != null && a3 != null && a6.isValueInThresholdRange(a5.getThreshold(), (VariableValue)a, (VariableValue)a2)) {
            a2 = new HashMap<String, Object>();
            a2.put(c_id.m_ck((Object)"MQWE^"), a.getValue());
            a4.put(a3.getName(), a2);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.A.m_sa((ClusterNodeListener)a);
        L.info(CheckedAlarm.m_ck((Object)"bDRDrWGKUCCWkDHDA@T\u0005OKOQODJL\\@B\u0005GKB\u0005T@ALUQCWCA\u0006DU\u0005eISVR@TkIACiOVR@H@T\u000b"));
    }

    protected void scheduleDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.l.m_uha(a));
    }

    protected void cancelDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_kka.m_kvb(() -> {
            DataTransferManager a2;
            a2.G.lock();
            try {
                Job job = (Job)a2.m.get(a.getId());
                if (job != null) {
                    a2.a.m_vaa(job);
                }
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.m.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.E.srem(M, stringArray);
                return;
            }
            finally {
                a2.G.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected void scheduleDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.l.m_vea((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    private /* synthetic */ boolean lambda$handleStatValues$12(Date a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        DataTransferManager dataTransferManager = a6;
        String string = dataTransferManager.buildStatCacheKey(a5);
        if (!dataTransferManager.shouldRecalculateStats(a5, a, string = dataTransferManager.E.get(string))) {
            a6.updateVariableWithCachedValue(string, a5, a2, a3, a4);
            return false;
        }
        return true;
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            DataTransferManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.A.m_yb((short)401, (Object)a, DataTransferManager.class.getDeclaredMethod(c_id.m_ck((Object)"CXX^TN\\^tZDZdIQUC]UIyUD^BUQW"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.A.m_yb((short)402, (Object)a, DataTransferManager.class.getDeclaredMethod(CheckedAlarm.m_ck((Object)"EDHFCIbDRDrWGKUCCWoKR@TKGI"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.A.m_yb((short)403, (Object)a, DataTransferManager.class.getDeclaredMethod(c_id.m_ck((Object)"\\UOtZDZdIQUC]UIcOQOEHyUD^BUQW"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.A.m_yb((short)404, (Object)a, DataTransferManager.class.getDeclaredMethod(CheckedAlarm.m_ck((Object)"UFN@BPJ@bDRDrWGKUCCWUg_uTJL@EQoAoKR@TKGI"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.A.m_yb((short)405, (Object)a, DataTransferManager.class.getDeclaredMethod(c_id.m_ck((Object)"SZ^XUWtZDZdIQUC]UICyIkBTZ^SOy_yUD^BUQW"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.A.m_yb((short)406, (Object)a, DataTransferManager.class.getDeclaredMethod(CheckedAlarm.m_ck((Object)"A@RaGQGqTDHV@@TvRDRPU@Ug_lBVoKR@TKGI"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.A.m_yb((short)407, (Object)a, DataTransferManager.class.getDeclaredMethod(c_id.m_ck((Object)"W^D\u007fQOQoBZ^HV^BhDZDNC^CyIkBTZ^SOy_yUD^BUQW"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(CheckedAlarm.m_ck((Object)"`DOICA\u0006QI\u0005T@ALUQCW\u0006aGQGqTDHV@@ThGKGBCW\u0006wvf\u0006HCQNJBV"), noSuchMethodException);
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(c_id.m_ck((Object)"TZDZ\u001dOBZ^HV^B\u0001\\ZCO\u001dXQWS\u0016DR]^\nMQIYZRWU\u0001\u0015_\n\u001eC\u0001\u0015H"), objectArray);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            L.debug(CheckedAlarm.m_ck((Object)"j`gacw\u001c\u0005uFN@BPJLHB\u0006AGQG\u0005RWGKUCCW\u0006^[\u0005JJEDJI_\u000b"), (Object)a);
            a2.scheduleDataTransferInternal(a);
            return;
        }
        L.debug(c_id.m_ck((Object)"u\u007fu\u001dwuzt~b\u0001\u0010iUJE^COYUW\u001b\\^Q_UI\u0010O_\u001bCXX^TN\\^\u0010_QOQ\u001bDIQUC]UI\u0010@M\u0015"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.m_sb(Short.valueOf((short)401), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC schedule data transfer " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            L.debug(CheckedAlarm.m_ck((Object)"icdb`t\u001f\u0006vEMCASIOKA\u0005GIJ\u0005BDRD\u0006QTDHV@@TV\u0006CIW\u0006UTJL@EQ\u0006^[\u0005JJEDJI_\u000b"), (Object)a);
            a2.scheduleDataTransfersByProjectIdInternal(a);
            return;
        }
        L.debug(c_id.m_ck((Object)"~t~\u0016|~q\u007fui\n\u001bb^ANUHDR^\\\u0010WUZT^B\u001bDT\u0010HSSU_EWU\u001bQW\\\u001bTZDZ\u0010OBZ^HV^BH\u0010]_I\u0010KBTZ^SO\u0010@M\u0015"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.m_sb(Short.valueOf((short)404), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC schedule data transfers for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$handleStatValues$17(Date a, Map a2, Map a3, Map a4, Date a5, List a6) {
        DataTransferManager a7;
        Integer[] integerArray = (Integer[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(Integer[]::new);
        c_vga[] c_vgaArray = (c_vga[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_vga[]::new);
        a = a7.k.m_xob(integerArray, a5, (Date)a, c_vgaArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableIdAsInt, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16((Map)a, a2, a3, a4, arg_0));
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            L.info(CheckedAlarm.m_ck((Object)"icdb`t\u001f\u0006mGKBIOKA\u0005t@UFN@BPJ@cSCKR\u0005@JT\u0005BDRD\u0006QTDHV@@T\u001f\u0006^[\u0005\u000elb\u001f\u0006^[\f"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            if (a2.getDataTransferStatusInternal(dataTransfer.getId()) == c_hl.E) {
                a2.scheduleDataTransferInternal(dataTransfer.getId());
                return;
            }
        } else {
            L.debug(c_id.m_ck((Object)"~t~\u0016|~q\u007fui\n\u001by\\^TBR^\\\u0010iUHSSU_EWU~F^^O\u0010]_I\u0010_QOQ\u001bDIQUC]UI\n\u001bKF"), (Object)a.getDataTransfer().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_hl> getDataTransferStatuses(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.A.m_hb()) {
            L.debug(CheckedAlarm.m_ck((Object)"icdb`t\u001f\u0006bCQRLHB\u0006AGQG\u0005RWGKUCCW\u0006VRDRPU@U\u0005@JT\u0005]X\u0006lbV\u0006IIFGIJ\\\u001c\u0005]X"), (Object)a.size(), a);
            return a2.getDataTransferStatusesByIdsInternal(a);
        }
        L.debug(c_id.m_ck((Object)"u\u007fu\u001dwuzt~b\u0001\u0010iUJE^COYUW\u001b\\^Q_UI\u0010]_I\u0010_QOQ\u001bDIQUC]UI\u0010HDZDNC^C\u001bVTB\u001bKF\u0010rtH\n\u001bKF"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.A.m_sb(Short.valueOf((short)406), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(CheckedAlarm.m_ck((Object)"\t"))), (Throwable)exception);
        }
    }

    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a2) {
        DataTransferManager a3;
        Object object = (Integer[])a.stream().map(DataTransferDetail::getSourceVariableId).toArray(Integer[]::new);
        Object object2 = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a3.b.m_vwa(object2).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        DataTransferManager dataTransferManager = a3;
        object = dataTransferManager.H.m_ftb(object);
        object2 = dataTransferManager.H.m_ftb((Integer[])object2.toArray(Integer[]::new));
        a.forEach(arg_0 -> a3.lambda$handleCurrentValues$10((Map)object, (Map)object2, map, a2, arg_0));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.cancelDataTransfer(dataTransferManager.l.m_ho(a, a2).getId());
    }

    protected void cancelDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.l.m_la((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, VariableValue<?> a2, VariableValue<?> a3) {
        double d;
        double d2;
        if (a == null || a3 == null) {
            return true;
        }
        if (!(a2 instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d3 = ((Number)a2.getValue()).doubleValue();
        double d4 = ((Number)a3.getValue()).doubleValue();
        return (d3 == 0.0 ? (d2 = Math.abs(d4 - d3)) : (d = Math.abs((d4 - d3) / d3 * 100.0))) >= a;
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            L.debug(c_id.m_ck((Object)"|~q\u007fui\n\u001bsZ^XUW\\R^\\\u0010_QOQ\u001bDIQUC]UI\u0010@M\u001b\\TSZ\\WI\u0015"), (Object)a);
            a2.cancelDataTransferInternal(a);
            return;
        }
        L.debug(CheckedAlarm.m_ck((Object)"kik\u000bicdb`t\u001f\u0006wCTS@UQOKA\u0005J@GACW\u0006QI\u0005EDHFCI\u0006AGQG\u0005RWGKUCCW\u0006^[\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.m_sb(Short.valueOf((short)402), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC cancel data transfer " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            L.debug(c_id.m_ck((Object)"wuzt~b\u0001\u0010xQUS^\\WYUW\u001bQW\\\u001bTZDZ\u0010OBZ^HV^BH\u0010]_I\u0010KBTZ^SO\u0010@M\u001b\\TSZ\\WI\u0015"), (Object)a);
            a2.cancelDataTransfersByProjectIdInternal(a);
            return;
        }
        L.debug(CheckedAlarm.m_ck((Object)"hjh\bj`gacw\u001c\u0005t@WPCVRLHB\u0006ICDB@T\u0005RJ\u0006FGKE@J\u0005GIJ\u0005BDRD\u0006QTDHV@@TV\u0006CIW\u0006UTJL@EQ\u0006^[\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.m_sb(Short.valueOf((short)405), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC cancel data transfers for project " + a, (Throwable)exception);
        }
    }

    public DataTransferManager(c_rf a, c_uba a2, c_gga a3, c_lla a4, c_od a5, JedisPooled a6, c_ng a7, c_j a8) {
        DataTransferManager a9;
        DataTransferManager dataTransferManager = a9;
        DataTransferManager dataTransferManager2 = a9;
        DataTransferManager dataTransferManager3 = a9;
        DataTransferManager dataTransferManager4 = a9;
        DataTransferManager dataTransferManager5 = a9;
        a9.G = new ReentrantLock();
        dataTransferManager5.m = new ConcurrentHashMap();
        dataTransferManager4.l = a;
        dataTransferManager4.b = a2;
        dataTransferManager3.H = a3;
        dataTransferManager3.k = a4;
        dataTransferManager2.a = a5;
        dataTransferManager2.g = a7;
        dataTransferManager.E = a6;
        dataTransferManager.A = a8;
    }

    public void notLeader() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        String string = dataTransferManager.A.m_gb().getNodeId();
        L.info(c_id.m_ck((Object)"\u007fQOQoBZ^HV^BvQUQ\\UI\n\u001bdSYH\u0010U__U\u001b\u0018@M\u0012\u0010RC\u001b~t\u0010w\u007fuw~b\u001bdsu\u001b|~q\u007fui\u001e\u001bsZ^XUW\\R^\\\u0010Z\\W\u0010W_XQW\u0010_QOQ\u001bDIQUC]UI\u0010Q_YC\u0015\u001e\u0015"), (Object)string);
        dataTransferManager.G.lock();
        try {
            new ArrayList(a.m.keySet()).forEach(a2 -> {
                DataTransferManager a3;
                Job job = (Job)a3.m.get(a2);
                if (job != null) {
                    try {
                        L.info(CheckedAlarm.m_ck((Object)"bDRDrWGKUCCWkDHDA@T\u0005\u000ekIQ\u0006iCDB@T\u0005]X\u000f\u001f\u0006fGKE@JIOKA\u0005JJEDJ\u0005LJD\u0005@JT\u0005BDRD\u0006QTDHV@@T\u0005oa\u001c\u0005]X"), (Object)string, a2);
                        a3.a.m_vaa(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        L.error(c_id.m_ck((Object)"\u007fQOQoBZ^HV^BvQUQ\\UI\u0010\u0013~TD\u001b|^Q_UI\u0010@M\u0012\n\u001buIBTB\u001bSZ^XUW\\R^\\\u0010W_XQW\u0010Q_Y\u0010]_I\u0010_QOQ\u001bDIQUC]UI\u0010rt\u001bKF\n\u001bKF"), objectArray);
                    }
                }
            });
            a.m.clear();
            L.info(CheckedAlarm.m_ck((Object)"bDRDrWGKUCCWkDHDA@T\u0005\u000ekIQ\u0006iCDB@T\u0005]X\u000f\u001f\u0006dJI\u0006IIFGI\u0006AGQG\u0005RWGKUCCW\u0006OIGU\u0005NDP@\u0006GC@H\u0005T@WPCVR@B\u0005RJ\u0006FGKE@J\u0005GKB\u0005EICDT@B\u0005@WIH\u0006IIFGI\u0006QTDENOKA\u000b"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            L.error(c_id.m_ck((Object)"tZDZdIQUC]UI}Z^ZW^B\u001b\u0018u_O\u0010wUZT^B\u001bKF\u0019\u0001\u0010~BI_I\u0010_EIYUW\u001b@I_XUHC\u001b_]\u0010XQUS^\\WYUW\u001b\\TSZ\\\u001bTZDZ\u0010OBZ^HV^B\u001bZTRH\n\u001bKF"), objectArray);
            return;
        }
        finally {
            a.G.unlock();
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            Integer n = a.getProject().getId();
            L.info(CheckedAlarm.m_ck((Object)"j`gacw\u001c\u0005nDHAJLHB\u0006uTJL@EQb@GFRLPDR@cSCKR\u0005@JT\u0005VWIOCFR\u0005oa\u001c\u0005]X"), (Object)n);
            a2.cancelDataTransfersByProjectIdInternal(n);
            return;
        }
        L.debug(c_id.m_ck((Object)"~t~\u0016|~q\u007fui\n\u001by\\^TBR^\\\u0010kBTZ^SOt^QXDRFZD^uMUUD\u001bVTB\u001b@I_QUXD\u001by\u007f\n\u001bKF"), (Object)a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_hl> getDataTransferStatuses(Integer a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            L.debug(CheckedAlarm.m_ck((Object)"j`gacw\u001c\u0005a@RQOKA\u0005GIJ\u0005BDRD\u0006QTDHV@@T\u0005UQGQSVCV\u0006CIW\u0006UTJL@EQ\u0006^[\u0005JJEDJI_\u000b"), (Object)a);
            return a2.getDataTransferStatusesByProjectIdInternal(a);
        }
        L.debug(c_id.m_ck((Object)"~t~\u0016|~q\u007fui\n\u001bb^ANUHDR^\\\u0010WUZT^B\u001bVTB\u001bQW\\\u001bTZDZ\u0010OBZ^HV^B\u001bCOQOEHUH\u0010]_I\u0010KBTZ^SO\u0010@M\u0015"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.A.m_sb(Short.valueOf((short)407), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_ika a) {
        switch (c_ml.g[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + a);
    }

    protected void scheduleDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_kka.m_kvb(() -> {
            DataTransferManager a2;
            a2.G.lock();
            try {
                a2.cancelDataTransferInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_ch("Project should be active to schedule data transfer " + a.getName());
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = a.getName();
                PeriodicJob periodicJob = a2.a.m_iia(a.getProject(), String.format(CheckedAlarm.m_ck((Object)"\u0003V\u0006aGQG\u0005rWGKUCCW"), objectArray), () -> {
                    DataTransferManager a2;
                    a2.transfer(a);
                }, Duration.ofMillis(a.getPeriod().intValue()));
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.m.put(a.getId(), periodicJob);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.E.sadd(M, stringArray);
                return;
            }
            finally {
                a2.G.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected c_hl getDataTransferStatusInternal(Integer a) {
        DataTransferManager a2;
        if (a2.m.containsKey(a)) {
            return c_hl.E;
        }
        return c_hl.g;
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.l.m_ho(a, a2).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        String string = dataTransferManager.A.m_gb().getNodeId();
        L.info(c_id.m_ck((Object)"tZDZdIQUC]UI}Z^ZW^B\u0001\u0010oXRC\u001b^TT^\u0010\u0013KF\u0019\u001bXZC\u001bR^ST]^\u0010OX^\u0010wuzt~b\u0015\u0010iUHDTBR^\\\u0010HSSU_EWU_\u0010_QOQ\u001bDIQUC]UIC\u0015\u001e\u0015"), (Object)string);
        dataTransferManager.G.lock();
        try {
            Set set = a2.E.smembers(M).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                L.info(CheckedAlarm.m_ck((Object)"aGQGqTDHV@@ThGKGBCW\u0006\rj@GACW\u0006^[\f\u001c\u0005hJ\u0006VEMCASICA\u0006AGQG\u0005RWGKUCCWU\u0005@JSKB\u0005OK\u0006wCAOV\u0006QI\u0005T@UQIWC\u000b"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            L.info(c_id.m_ck((Object)"\u007fQOQoBZ^HV^BvQUQ\\UI\u0010\u0013|^Q_UI\u0010@M\u0012\n\u001bvTEUT\u001bKF\u0010HSSU_EWU_\u0010_QOQ\u001bDIQUC]UI\u0010rtH\u0010R^\u001bb^TRC\u001bDT\u0010IUHDTB^\n\u001bKF"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = CheckedAlarm.m_ck((Object)"plcryagqgzrwgkuccw");
            c_kka.m_occ(() -> {
                DataTransferManager a3;
                arrayList.addAll(a3.l.m_jca(set));
            }, (String[])stringArray);
            L.info(c_id.m_ck((Object)"\u007fQOQoBZ^HV^BvQUQ\\UI\u0010\u0013|^Q_UI\u0010@M\u0012\n\u001bqOD^]KDR^\\\u0010O_\u001bB^CO_IU\u001bKF\u0010_QOQ\u001bDIQUC]UIC\u0015"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                DataTransferManager a2;
                DataTransferManager dataTransferManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = CheckedAlarm.m_ck((Object)"ufn`bpj`yagqgzrwgkuccw");
                stringArray[1] = c_id.m_ck((Object)"sz~xuwo\u007fqoqddiquc}ui");
                c_kka.m_byb(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1(dataTransferManager.A.m_gb().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            L.info(CheckedAlarm.m_ck((Object)"bDRDrWGKUCCWkDHDA@T\u0005\u000eiCDB@T\u0005]X\u000f\u001f\u0006cOKOVN@B\u0005BDRD\u0006QTDHV@@T\u0005T@UQIWGQOJH\u0005VWIFCVU\u000b"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            L.error(c_id.m_ck((Object)"\u007fQOQoBZ^HV^BvQUQ\\UI\u0010\u0013|^Q_UI\u0010@M\u0012\n\u001buIBTB\u001bTNBR^\\\u0010_QOQ\u001bDIQUC]UI\u0010IUHDTBZDR_U\u0010KBTS^CH\n\u001bKF"), objectArray);
            return;
        }
        finally {
            a2.G.unlock();
        }
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(CheckedAlarm.m_ck((Object)"AGQG\bRWGKUCCW\u001cVRDRV\u001cSGWODDIC\u001f\u0003A\u001c\u0000U\u001f\u0003V"), objectArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_hl getDataTransferStatus(Integer a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            L.debug(c_id.m_ck((Object)"|~q\u007fui\n\u001bw^DOYUW\u001bTZDZ\u0010OBZ^HV^B\u001bCOQOEH\u0010]_I\u0010rt\u0001\u0010@M\u001b\\TSZ\\WI\u0015"), (Object)a);
            return a2.getDataTransferStatusInternal(a);
        }
        L.debug(CheckedAlarm.m_ck((Object)"hjh\bj`gacw\u001c\u0005t@WPCVRLHB\u0006ICDB@T\u0005@JT\u0005BDRD\u0006QTDHV@@T\u0005UQGQSV\u0006CIW\u0006lb\u001f\u0006^[\u000b"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_hl)a2.A.m_sb(Short.valueOf((short)403), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get data transfer status for " + a, (Throwable)exception);
        }
    }

    protected void cancelDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.l.m_wj(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_hl getDataTransferStatus(Integer a, String a2) {
        DataTransferManager a3;
        if ((a = a3.l.m_dg(a, a2)) == null) {
            return c_hl.g;
        }
        return a3.getDataTransferStatus(a.getId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats a, c_vga a2) {
        switch (c_ml.d[a2.ordinal()]) {
            case 1: {
                return a.getMinValue();
            }
            case 2: {
                return a.getMaxValue();
            }
            case 3: {
                return a.getAvgValue();
            }
            case 4: {
                return a.getSumValue();
            }
            case 5: {
                return a.getCountValue();
            }
            case 6: {
                return a.getFirstValue();
            }
            case 7: {
                return a.getLastValue();
            }
            case 8: {
                return a.getMaxDiffValue();
            }
            case 9: {
                return a.getLastFirstDiffValue();
            }
            case 10: {
                return a.getMiddleValue();
            }
            case 11: {
                return a.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + a2);
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        DataTransferManager a2;
        if (a2.A.m_hb()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            L.info(c_id.m_ck((Object)"wuzt~b\u0001\u0010sQUTWYUW\u001bsZ^XUWuMUUD\u001bVTB\u001bTZDZ\u0010OBZ^HV^B\u0001\u0010@M\u001b\u0018rt\u0001\u0010@M\u0012"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            a2.cancelDataTransferInternal(dataTransfer);
            return;
        }
        L.debug(CheckedAlarm.m_ck((Object)"hjh\bj`gacw\u001c\u0005oBHJTLHB\u0006fGKE@J`P@HQ\u0006CIW\u0006AGQG\u0005RWGKUCCW\u001c\u0005]X"), (Object)a.getDataTransfer().getId());
    }

    private /* synthetic */ void lambda$handleStatValues$16(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        if ((a = (LoggedVariableValueStats)a.get(a5.getSourceVariableId())) != null && (a2 = (Variable)a2.get(a5.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = a6.extractValue((LoggedVariableValueStats)a, a5.getCalcType());
            a = (VariableValue)a3.get(a5.getTargetVariableId());
            DataTransferManager dataTransferManager = a6;
            a3 = dataTransferManager.buildStatCacheKey(a5);
            String string = dataTransferManager.buildStatLastCalcTimeKey(a5);
            int n = dataTransferManager.getMaxTTLForRangeType(a5.getRangeType());
            dataTransferManager.E.setex((String)a3, (long)n, String.valueOf(d));
            a6.E.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager.isValueInThresholdRange(a5.getThreshold(), Double.valueOf(d), (VariableValue)a)) {
                a = new HashMap<String, Double>();
                a.put(c_id.m_ck((Object)"MQWE^"), d);
                a4.put(a2.getName(), a);
            }
        }
    }

    private /* synthetic */ void transfer(DataTransfer a) {
        DataTransferManager a2;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(a3 -> {
            if (a3.getCalcType() != null && a3.getRangeType() != null) {
                arrayList2.add(a3);
                return;
            }
            arrayList.add(a3);
        });
        HashMap hashMap = new HashMap();
        if (!arrayList.isEmpty()) {
            a2.handleCurrentValues(arrayList, hashMap);
        }
        if (!arrayList2.isEmpty()) {
            a2.handleStatValues(arrayList2, hashMap);
        }
        if (!hashMap.isEmpty()) {
            a2.H.m_bqb(a.getProjectId(), hashMap);
        }
    }

    protected Map<Integer, c_hl> getDataTransferStatusesByIdsInternal(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    private /* synthetic */ void handleStatValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a3) {
        DataTransferManager a4;
        Object object = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a4.b.m_vwa(object).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = a4.H.m_ftb((Integer[])object.toArray(Integer[]::new));
        Date date = new Date();
        a.stream().filter(arg_0 -> a4.lambda$handleStatValues$12(date, map, a3, (Map)object, arg_0)).collect(Collectors.groupingBy(a2 -> {
            DataTransferManager a3;
            return (Date)a3.calculateDateRange(date, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> a4.lambda$handleStatValues$17(date, map, (Map)object, a3, arg_0, arg_1));
    }

    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date a, c_ika a2) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        calendar.setTime(a);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Calendar calendar3 = (Calendar)calendar2.clone();
        switch (c_ml.g[a2.ordinal()]) {
            case 1: {
                Calendar calendar4 = calendar;
                while (false) {
                }
                calendar4.set(12, 0);
                return Pair.of((Object)calendar4.getTime(), (Object)a);
            }
            case 2: {
                calendar3.add(11, -1);
                Calendar calendar5 = calendar;
                calendar5.add(11, -2);
                calendar5.set(12, 0);
                return Pair.of((Object)calendar5.getTime(), (Object)calendar3.getTime());
            }
            case 3: {
                Calendar calendar6 = calendar;
                calendar6.set(11, 0);
                calendar6.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 4: {
                calendar3.add(5, -1);
                Calendar calendar7 = calendar;
                calendar.add(5, -2);
                calendar7.set(11, 0);
                calendar7.set(12, 0);
                return Pair.of((Object)calendar7.getTime(), (Object)calendar3.getTime());
            }
            case 5: {
                Calendar calendar8 = calendar;
                Calendar calendar9 = calendar;
                calendar9.set(7, calendar9.getFirstDayOfWeek());
                calendar8.set(11, 0);
                calendar8.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 6: {
                calendar3.add(3, -1);
                Calendar calendar10 = calendar;
                calendar.add(3, -2);
                Calendar calendar11 = calendar;
                calendar11.set(7, calendar11.getFirstDayOfWeek());
                calendar10.set(11, 0);
                calendar10.set(12, 0);
                return Pair.of((Object)calendar10.getTime(), (Object)calendar3.getTime());
            }
            case 7: {
                Calendar calendar12 = calendar;
                calendar.set(5, 1);
                calendar12.set(11, 0);
                calendar12.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 8: {
                calendar3.add(2, -1);
                Calendar calendar13 = calendar;
                Calendar calendar14 = calendar;
                calendar14.add(2, -2);
                calendar14.set(5, 1);
                calendar13.set(11, 0);
                calendar13.set(12, 0);
                return Pair.of((Object)calendar13.getTime(), (Object)calendar3.getTime());
            }
            case 9: {
                Calendar calendar15 = calendar;
                calendar.set(6, 1);
                calendar15.set(11, 0);
                calendar15.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 10: {
                calendar3.add(1, -1);
                Calendar calendar16 = calendar;
                Calendar calendar17 = calendar;
                calendar17.add(1, -2);
                calendar17.set(6, 1);
                calendar16.set(11, 0);
                calendar16.set(12, 0);
                return Pair.of((Object)calendar16.getTime(), (Object)calendar3.getTime());
            }
        }
        throw new IllegalArgumentException(CheckedAlarm.m_ck((Object)"pH@^UCFR@B\u0005TDHBC\u0005R\\V@"));
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, Double a2, VariableValue<?> a3) {
        DataTransferManager a4;
        return a4.isValueInThresholdRange(a, (VariableValue)new NumberVariableValue((Number)a2, new Date()), a3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail a, Date a2, String a3) {
        Date date;
        int n;
        boolean bl;
        DataTransferManager a4;
        if (a3 == null) {
            return true;
        }
        a3 = Calendar.getInstance();
        String string = a4.E.get(a4.buildStatLastCalcTimeKey(a));
        if (string == null) {
            return true;
        }
        ((Calendar)a3).setTimeInMillis(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(a2);
        boolean bl2 = false;
        switch (c_ml.g[a.getRangeType().ordinal()]) {
            case 1: 
            case 2: {
                bl = bl2 = ((Calendar)a3).get(11) != calendar.get(11);
                break;
            }
            case 3: 
            case 4: {
                bl = bl2 = ((Calendar)a3).get(6) != calendar.get(6);
                break;
            }
            case 5: 
            case 6: {
                bl = bl2 = ((Calendar)a3).get(3) != calendar.get(3);
                break;
            }
            case 7: 
            case 8: {
                bl = bl2 = ((Calendar)a3).get(2) != calendar.get(2);
                break;
            }
            case 9: 
            case 10: {
                bl2 = ((Calendar)a3).get(1) != calendar.get(1);
            }
            default: {
                bl = bl2;
            }
        }
        if (bl) {
            DataTransferManager dataTransferManager = a4;
            String string2 = dataTransferManager.buildStatCacheKey(a);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey(a);
            String[] stringArray = new String[2];
            stringArray[0] = string2;
            stringArray[1] = string3;
            dataTransferManager.E.del(stringArray);
            return true;
        }
        if (!a.getRangeType().toString().startsWith(c_id.m_ck((Object)"xEIB^^O"))) {
            return false;
        }
        switch (c_ml.g[a.getRangeType().ordinal()]) {
            case 1: {
                n = 5;
                date = a2;
                break;
            }
            case 3: {
                n = 5;
                date = a2;
                break;
            }
            case 5: {
                n = 60;
                date = a2;
                break;
            }
            case 7: {
                n = 720;
                date = a2;
                break;
            }
            case 9: {
                n = 720;
                date = a2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected range type: " + a.getRangeType());
            }
        }
        long l = date.getTime();
        long l2 = Long.parseLong(string);
        return l - l2 >= (long)(n * 60 * 1000);
    }

    private /* synthetic */ void updateVariableWithCachedValue(String a, DataTransferDetail a2, Map<Integer, Variable<?, ?, ?>> a3, Map<String, Map<String, Object>> a4, Map<Integer, VariableValue<?>> a5) {
        if ((a3 = a3.get(a2.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = Double.parseDouble((String)a);
            a = a5.get(a2.getTargetVariableId());
            if (a6.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), a)) {
                a = new HashMap<String, Double>();
                a.put(CheckedAlarm.m_ck((Object)"SGIS@"), d);
                a4.put(a3.getName(), (Map<String, Object>)a);
            }
        }
    }
}

