/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.restcontrollers;

import com.inscada.mono.communication.protocols.opcda.model.Leaf;
import com.inscada.mono.datatransfer.k.c_hl;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.DataTransferManager;
import com.inscada.mono.datatransfer.services.c_rf;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.space.c_vc;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/datatransfer"})
public class DataTransferController
extends ProjectBasedImportExportController {
    private final c_rf d;
    private final DataTransferManager g;

    @PostMapping(value={"/{dataTransferId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="dataTransferId") Integer a) {
        this.g.cancelDataTransfer(a);
    }

    @GetMapping(value={"/{dataTransferId}"})
    public DataTransfer getDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        return this.d.m_ya(a);
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_hl> getDataTransferStatuses(@RequestParam(value="dataTransferIds") Integer[] a) {
        return this.g.getDataTransferStatuses(Arrays.asList(a));
    }

    @GetMapping
    public Collection<DataTransfer> getDataTransfers(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.d.m_aa();
        }
        return this.d.m_la(a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.g.cancelDataTransfers(a);
    }

    @DeleteMapping(value={""}, params={"dataTransferIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfersByIds(@RequestParam(value="dataTransferIds") Integer[] a) {
        this.d.m_yba(List.of(a));
    }

    @GetMapping(value={"/{dataTransferId}/details/{detailId}"})
    public DataTransferDetail getDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        return this.d.m_fha(dataTransferId, a);
    }

    @PostMapping(value={"/{dataTransferId}/details"})
    public ResponseEntity<DataTransferDetail> createDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransferDetail dataTransferDetail, UriComponentsBuilder a) {
        dataTransferDetail = this.d.m_vca(dataTransferId, dataTransferDetail);
        Object[] objectArray = new Object[2];
        objectArray[0] = dataTransferId;
        objectArray[1] = dataTransferDetail.getId();
        return ResponseEntity.created((URI)a.path(Leaf.m_ck((Object)"'ClY|Y\\JiV{^mJA\\u\u0017l]|YaT{\u0017s\\mLiQdqlE")).buildAndExpand(objectArray).toUri()).body((Object)dataTransferDetail);
    }

    @PutMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDataTransfer(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransfer a) {
        this.d.m_hga(dataTransferId, a);
    }

    @PostMapping
    public ResponseEntity<DataTransfer> createDataTransfer(@Valid @RequestBody DataTransfer dataTransfer, UriComponentsBuilder a) {
        dataTransfer = this.d.m_vba(dataTransfer);
        Object[] objectArray = new Object[1];
        objectArray[0] = dataTransfer.getId();
        return ResponseEntity.created((URI)a.path(c_vc.m_ck((Object)"eO.U>U\u001eF+Z9R/F\u0003P7")).buildAndExpand(objectArray).toUri()).body((Object)dataTransfer);
    }

    public DataTransferController(c_rf a, DataTransferManager a2, c_cd a3, c_ll a4) {
        DataTransferController a5;
        DataTransferController dataTransferController = a5;
        super(a3, EnumSet.of(c_ao.i), a4);
        dataTransferController.d = a;
        dataTransferController.g = a2;
    }

    @DeleteMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        this.d.m_wha(dataTransferId, a);
    }

    @GetMapping(value={"/{dataTransferId}/status"})
    public c_hl getDataTransferStatus(@PathVariable(value="dataTransferId") Integer a) {
        return this.g.getDataTransferStatus(a);
    }

    @PutMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer detailId, @Valid @RequestBody DataTransferDetail a) {
        this.d.m_xca(dataTransferId, detailId, a);
    }

    @DeleteMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        this.d.m_qa(a);
    }

    @DeleteMapping(value={"/details"}, params={"dataTransferDetailIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransferDetailsByIds(@RequestParam(value="dataTransferDetailIds") Integer[] a) {
        this.d.m_fia(List.of(a));
    }

    @GetMapping(value={"/{dataTransferId}/details"})
    public Collection<DataTransferDetail> getDetails(@PathVariable(value="dataTransferId") Integer a) {
        return this.d.m_vda(a);
    }

    @PostMapping(value={"/{dataTransferId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="dataTransferId") Integer a) {
        this.g.scheduleDataTransfer(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.g.scheduleDataTransfers(a);
    }
}

