/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.restcontrollers;

import com.inscada.mono.animation.messages.AnimationResultsMessage;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.template.k.c_fd;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.shared.model.BaseModel;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class TemplateController<TDeviceTemplate extends DeviceTemplate<TFrameTemplate>, TFrameTemplate extends FrameTemplate<TDeviceTemplate, TVariableTemplate>, TVariableTemplate extends VariableTemplate<TFrameTemplate, TDeviceTemplate>, TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TTemplateService extends c_fd<TDeviceTemplate, TFrameTemplate, TVariableTemplate, TConnection, TDevice, TFrame, TVariable>> {
    private final TTemplateService g;

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public Collection<TVariableTemplate> getVariables(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return this.g.m_tra(deviceId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames"})
    public Collection<TFrameTemplate> getFrames(@PathVariable(value="deviceId") Integer a) {
        return this.g.m_gwa(a);
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        this.g.m_hpa(deviceId, frameId, a);
    }

    @PostMapping(value={"/devices"})
    public ResponseEntity<TDeviceTemplate> createDevice(@Valid @RequestBody TDeviceTemplate device, UriComponentsBuilder a) {
        device = this.g.m_bma(device);
        Object[] objectArray = new Object[1];
        objectArray[0] = device.getId();
        return ResponseEntity.created((URI)a.path(AnimationResultsMessage.m_ck((Object)"O\u001d\u0005\u000f\t\u001a\u0005\nO\u0002\u0004\u001c\u0016\u0010\u0003\u001c)\u001d\u001d")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @PostMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public ResponseEntity<TVariableTemplate> createVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TVariableTemplate variable, UriComponentsBuilder a) {
        variable = this.g.m_yra(deviceId, frameId, variable);
        Object[] objectArray = new Object[3];
        objectArray[0] = deviceId;
        objectArray[1] = frameId;
        objectArray[2] = variable.getId();
        return ResponseEntity.created((URI)a.path(BaseModel.m_ck((Object)"\u0011T[FWS[C\u0011KZUHY]UwTC\u001fXB_][C\u0011KXB_][yZM\u0011F_BWQ\\\\[C\u0011KHQLY_RRUwTC")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.g.m_wva(deviceId, a);
    }

    public TemplateController(TTemplateService a) {
        TemplateController a2;
        a2.g = a;
    }

    @PutMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDeviceTemplate a) {
        this.g.m_gra(deviceId, a);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDeviceTemplate> getDevices() {
        TemplateController a;
        return a.g.m_boa();
    }

    @DeleteMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="deviceId") Integer a) {
        this.g.m_fma(a);
    }

    @GetMapping(value={"/devices/{deviceId}"})
    public TDeviceTemplate getDevice(@PathVariable(value="deviceId") Integer a) {
        return (TDeviceTemplate)this.g.m_xoa(a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    public TFrameTemplate getFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrameTemplate)this.g.m_wla(deviceId, a);
    }

    @PostMapping(value={"/devices/{deviceId}/frames"})
    public ResponseEntity<TFrameTemplate> createFrame(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrameTemplate frame, UriComponentsBuilder a) {
        frame = this.g.m_rpa(deviceId, frame);
        Object[] objectArray = new Object[2];
        objectArray[0] = deviceId;
        objectArray[1] = frame.getId();
        return ResponseEntity.created((URI)a.path(AnimationResultsMessage.m_ck((Object)"V\u0004\u001c\u0016\u0010\u0003\u001c\u0013V\u001b\u001d\u0005\u000f\t\u001a\u00050\u0004\u0004O\u001f\u0012\u0018\r\u001c\u0013V\u001b\u001f\u0012\u0018\r\u001c)\u001d\u001d")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrameTemplate a) {
        this.g.m_ota(deviceId, frameId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    public TVariableTemplate getVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        return (TVariableTemplate)this.g.m_lsa(deviceId, frameId, a);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariableTemplate a) {
        this.g.m_iua(deviceId, frameId, variableId, a);
    }
}

