/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.shared.model.SpaceBaseModel;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Where;

@Entity
@Table(name="device")
@Inheritance(strategy=InheritanceType.JOINED)
@Where(clause="conn_id is null")
public class DeviceTemplate<TFrameTemplate extends FrameTemplate<?, ?>>
extends SpaceBaseModel {
    protected String properties;
    @Size(max=255)
    protected String dsc;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Id
    @Column(name="device_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="deviceTemplateSeq")
    @GenericGenerator(name="deviceTemplateSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="device_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @JsonIgnore
    @OneToMany(mappedBy="device", orphanRemoval=true, targetEntity=FrameTemplate.class)
    protected Set<TFrameTemplate> frames;

    public DeviceTemplate() {
        DeviceTemplate a;
        DeviceTemplate deviceTemplate = a;
        deviceTemplate.frames = new HashSet();
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public int hashCode() {
        DeviceTemplate a;
        Object[] objectArray = new Object[2];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        return Objects.hash(objectArray);
    }

    public Integer getId() {
        DeviceTemplate a;
        return a.id;
    }

    public String getDsc() {
        DeviceTemplate a;
        return a.dsc;
    }

    public void setFrames(Set<TFrameTemplate> a) {
        a.frames = a;
    }

    public void setProperties(String a) {
        a.properties = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public boolean equals(Object a) {
        DeviceTemplate a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof DeviceTemplate)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (DeviceTemplate)a;
        return a2.getName().equals(a.getName());
    }

    public String getProperties() {
        DeviceTemplate a;
        return a.properties;
    }

    public Set<TFrameTemplate> getFrames() {
        DeviceTemplate a;
        return a.frames;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public String getName() {
        DeviceTemplate a;
        return a.name;
    }
}

