/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.alarm.model.CheckedAlarm;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.repositories.VariableRepository;
import com.inscada.mono.communication.base.services.c_eg;
import com.inscada.mono.communication.base.services.k.c_id;
import com.inscada.mono.expression.k.c_xm;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_ck;
import com.inscada.mono.shared.exceptions.c_mi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_mk<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>> {
    protected final c_ll M;
    protected final c_xm j;
    protected final c_eg<TConnection, TDevice, TFrame> E;
    protected final VariableRepository<TVariable> L;
    protected final ApplicationEventPublisher d;
    protected static final String[] g;

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_wra(VariableFilter a2) {
        c_mk a3;
        c_mk c_mk2 = a3;
        c_mk2.L.deleteAllByFilter(a2);
        c_mk2.E.m_la(a2.getProjectId()).forEach(a -> {
            c_mk a2;
            a2.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    private /* synthetic */ void m_rla(TVariable a, TVariable a2, boolean a3) {
        c_mk a4;
        TVariable TVariable = a2;
        c_mk c_mk2 = a4;
        c_mk2.m_nla(a);
        Connection connection = TVariable.getConnection();
        BeanUtils.copyProperties(a, a2, (String[])g);
        c_mk2.m_tqa(TVariable);
        a = a2.getConnection();
        if (a3) {
            a4.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, connection));
            if (!a.getId().equals(connection.getId())) {
                a4.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, a));
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_aua(Integer a) {
        c_mk a2;
        if ((a = a2.L.findByFrameId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_la(Integer a) {
        c_mk a2;
        if ((a = a2.L.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Order(value=5)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_ke(ProjectDeleteEvent a) {
        c_mk a2;
        a2.m_xa(a.getProject().getId());
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_qa(Integer a) {
        c_mk a2;
        if ((a = a2.m_ya(a)) != null) {
            if (a.getSourceVariableDataTransferDetails() != null && !a.getSourceVariableDataTransferDetails().isEmpty()) {
                throw new c_ac(CheckedAlarm.m_ck((Object)"sGWODDIC\u0005B@J@RLIK\u0006CGLJ@B\u000b\u0006aGQG\u0005RWGKUCCW\u0006ACQGLJ\u0005C]OVRV"));
            }
            if (a.getTargetVariableDataTransferDetails() != null && !a.getTargetVariableDataTransferDetails().isEmpty()) {
                throw new c_ac(c_id.m_ck((Object)"mQIYZRWU\u001bT^\\^DR_U\u0010]QR\\^T\u0015\u0010\u007fQOQ\u001bDIQUC]UI\u0010_UOQR\\\u001bUCYHDH"));
            }
            c_mk c_mk2 = a2;
            c_mk2.L.delete((Object)a);
            c_mk2.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a.getConnection()));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_laa(Pageable a) {
        c_mk a2;
        return a2.L.findAll(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_oua(Integer a, String[] a2) {
        c_mk a3;
        if (a2 == null || a2.length == 0) {
            return Collections.emptyList();
        }
        if ((a = a3.L.findByProjectIdAndNameIn((Integer)a, a2)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    protected void m_nla(TVariable a) {
        c_mk a2;
        if (a.getProject() == null) {
            TVariable TVariable = a;
            TVariable.setProject(a2.M.m_wj(TVariable.getProjectId()));
        }
        if (a.getFrame() == null) {
            TVariable TVariable = a;
            TVariable.setFrame(a2.E.m_fta(TVariable.getFrameId()));
        }
        if (a.getValueExpression() == null && a.getValueExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setValueExpression(a2.j.m_wj(TVariable.getValueExpressionId()));
        }
        if (a.getLogExpression() == null && a.getLogExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setLogExpression(a2.j.m_wj(TVariable.getLogExpressionId()));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_xa(Integer a2) {
        if (a2 != null) {
            c_mk a3;
            c_mk c_mk2 = a3;
            c_mk2.L.deleteByProjectId(a2);
            c_mk2.E.m_la(a2).forEach(a -> {
                c_mk a2;
                a2.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_wj(Integer a) {
        c_mk a2;
        Variable variable = a2.m_ya(a);
        if (variable == null) {
            throw new c_ck("Variable not found with id of " + a);
        }
        return (TVariable)variable;
    }

    public Long m_jwa() {
        c_mk a;
        return a.L.count();
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_ypa(Integer a, Pageable a2) {
        c_mk a3;
        return a3.L.findByProjectId(a, a2);
    }

    public void m_sra(TVariable a) {
        c_mk a2;
        c_mk c_mk2 = a2;
        c_mk2.m_nla(a);
        c_mk2.m_tqa(a);
    }

    public c_mk(c_ll a, c_eg<TConnection, TDevice, TFrame> a2, c_xm a3, VariableRepository<TVariable> a4, ApplicationEventPublisher a5) {
        c_mk a6;
        c_mk c_mk2 = a6;
        c_mk c_mk3 = a6;
        a6.M = a;
        c_mk3.E = a2;
        c_mk3.j = a3;
        c_mk2.L = a4;
        c_mk2.d = a5;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_tta(TVariable a, boolean a2) {
        Variable variable;
        c_mk a3;
        TVariable TVariable = a;
        a3.m_nla(TVariable);
        if ((TVariable.getId() != null ? (variable = a3.m_ya(a.getId())) : (variable = a3.m_wa(a.getProjectId(), a.getName()))) != null) {
            a3.m_rla(a, variable, a2);
            return;
        }
        a3.m_vsa(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE')")
    public TVariable m_qpa(TVariable a) {
        c_mk a2;
        return (TVariable)a2.m_vsa(a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_ya(Integer a) {
        c_mk a2;
        return (TVariable)((Variable)a2.L.findById((Object)a).orElse(null));
    }

    protected void m_tqa(TVariable a) {
        if (!a.getConnection().getProject().equals((Object)a.getProject())) {
            throw new c_mi(CheckedAlarm.m_ck((Object)"`WGHC\u0005D@JJHBU\u0005RJ\u0006DHJRMCW\u0006UTJL@EQ"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_zva(Integer a, String a2, String a3, String a4) {
        c_mk a5;
        if ((a = a5.L.findVariablesByFrameName((Integer)a, a2, a3, a4)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    private /* synthetic */ TVariable m_vsa(TVariable a, boolean a2) {
        c_mk a3;
        c_mk c_mk2 = a3;
        c_mk2.m_sra(a);
        Variable variable = (Variable)c_mk2.L.save(a);
        if (a2) {
            a3.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a3, a.getConnection()));
        }
        return (TVariable)variable;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_xva(List<Integer> a2) {
        c_mk a3;
        c_mk c_mk2 = a3;
        a2 = c_mk2.m_vwa(a2);
        c_mk2.L.deleteInBatch(a2);
        a2.stream().map(Variable::getConnection).distinct().forEach(a -> {
            c_mk a2;
            a2.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_aa() {
        c_mk a;
        return a.L.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_wa(Integer a, String a2) {
        c_mk a3;
        return (TVariable)a3.L.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_hoa(Integer a, String a2) {
        c_mk a3;
        Variable variable = a3.m_wa(a, a2);
        if (variable == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ck(String.format(c_id.m_ck((Object)"fZBRQY\\^\u0010U_O\u0010]_N^_\n\u001b@I_QUXD\u001bY_\n\u001b\u0015_\u001c\u001b^Z]^\n\u001b\u0015H"), objectArray));
        }
        return (TVariable)variable;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_kwa(VariableFilter a, Pageable a2) {
        c_mk a3;
        return a3.L.findVariablesByFilter(a, a2);
    }

    static {
        String[] stringArray = new String[7];
        stringArray[0] = CheckedAlarm.m_ck((Object)"OA");
        stringArray[1] = c_id.m_ck((Object)"H@ZS^");
        stringArray[2] = CheckedAlarm.m_ck((Object)"UTJL@EQ");
        stringArray[3] = c_id.m_ck((Object)"XB^QOU_rB");
        stringArray[4] = CheckedAlarm.m_ck((Object)"EWCDRLIKbDR@");
        stringArray[5] = c_id.m_ck((Object)"\\ZCO}TTRVRU_rB");
        stringArray[6] = CheckedAlarm.m_ck((Object)"JDUQkJBL@LCAbDR@");
        g = stringArray;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_VARIABLE')")
    public void m_ena(Integer a, TVariable a2) {
        c_mk a3;
        c_mk c_mk2 = a3;
        a = c_mk2.m_wj(a);
        c_mk2.m_rla(a2, (Variable)a, true);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_bh(Collection<TVariable> a2, boolean a3) {
        c_mk a4;
        a2.forEach(arg_0 -> a4.m_nla(arg_0));
        Object object = a2.stream().map(Variable::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.L.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Variable::getProjectId, Collectors.mapping(Variable::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_mk a2;
            return a2.L.findByProjectIdAndNameIn((Integer)a.getKey(), (String[])((Set)a.getValue()).stream().toArray(String[]::new)).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        HashSet<Connection> hashSet = new HashSet<Connection>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Variable variable = (Variable)a2.next();
            if ((variable.getId() != null ? (Variable)map.get(variable.getId()) : (Variable)object.get(ImmutablePair.of((Object)variable.getProjectId(), (Object)variable.getName()))) != null) {
                Variable variable2;
                Variable variable3 = variable2;
                Connection connection = variable3.getConnection();
                Variable variable4 = variable;
                BeanUtils.copyProperties((Object)variable4, (Object)variable2, (String[])g);
                a4.m_tqa(variable4);
                Connection connection2 = variable3.getConnection();
                if (connection.getId() != null) {
                    hashSet.add(connection);
                }
                if (connection2.getId() != null && !connection2.getId().equals(connection.getId())) {
                    hashSet.add(connection2);
                }
                arrayList.add(variable2);
                continue;
            }
            a4.m_tqa(variable);
            arrayList.add(variable);
            hashSet.add(variable.getConnection());
        }
        a4.L.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_mk a2;
                a2.d.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_vwa(List<Integer> a) {
        c_mk a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyList();
        }
        return a2.L.findAllById(a);
    }
}

