/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_kka;
import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.auth.services.k.w.k.c_hia;
import com.inscada.mono.cluster.k.c_vha;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_j;
import com.inscada.mono.communication.base.enums.c_mja;
import com.inscada.mono.communication.base.events.DeleteEvent;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.ConnectorFactory;
import com.inscada.mono.communication.base.services.c_c;
import com.inscada.mono.communication.base.services.c_wia;
import com.inscada.mono.communication.base.services.c_xf;
import com.inscada.mono.license.services.c_cn;
import com.inscada.mono.log.services.c_ng;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_ch;
import com.inscada.mono.shared.exceptions.c_ck;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener {
    private final JedisPooled C;
    public static final short I = 210;
    private final Lock H;
    public static final short A = 204;
    public static final short i = 205;
    public static final short G = 209;
    private final c_ng J;
    private final c_cn e;
    public static final short a = 207;
    public static final short k = 202;
    public static final short b = 203;
    private static final Logger l = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short m = 208;
    public static final short M = 201;
    private final c_j j;
    private final c_wia E;
    private static final String L = "activeConnections";
    private final ConnectorFactory<C, V> d;
    public static final short g = 206;

    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String a, Connection a2) {
        ConnectionManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            l.info(AuthToken.m_ck((Object)"\b%%$.)?#$$\u0006+%+,/9jc\u0006.+//9j07bpk\u0018.9?%9#%-k)$$%/(>\"%%pk16jc\u0003\u000fpk16c"), objectArray);
            a3.startConnectionInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.J.m_lga(a2.getProject()).m_c("Connection Restore (Leader " + a + ")", String.format(c_hia.m_ck((Object)"ovj-\u0003Ap%oac%,d#i/ajq%%8`9q%w/+jF+p9`p%ov"), objectArray));
            try {
                l.warn(AuthToken.m_ck((Object)"\b%%$.)?#$$\u0006+%+,/9jc\u0006.+//9j07bpk\u000b?>.';>\"$,j?%k9?%;j(%%$.)?#$$k16j*,?/9j9/8>$8*>\"%%j-+\"&>8.d"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                l.error(c_hia.m_ck((Object)"F%k$`)q#j$H+k+b/wj-\u0006`+a/wj~7,p%\fd#i/ajq%%9q%ujf%k$`)q#j$%1xjd,q/wjw/v>j8d>l%kjc+l&p8`p%1x"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.stopConnection(connectionManager.E.m_bwb(a, a2).getId());
    }

    public void notLeader() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        String string = connectionManager.j.m_gb().getNodeId();
        l.info(AuthToken.m_ck((Object)"\t$$%/(>\"%%\u0007*$*-.8qj\u001f\"\"9k$$..jc16ck#8j\u0005\u0005k\u0006\u0004\u0004\f\u000f\u0019j\u001f\u0002\u000ej\u0007\u000f\n\u000e\u000e\u0018ej\u0018>$:;#%-k+'&k&$)*&k)$$%/(>$88ded"), (Object)string);
        connectionManager.H.lock();
        try {
            a.d.stopAllLocalConnectors();
            l.info(c_hia.m_ck((Object)"\tj$k/f>l%k\u0007d$d-`8%bK%qjI/d.`8%1xc?jD&iji%f+ijf%k$`)q%w9%\"d<`jg/`$%8`;p/v>`.%>jjv>j:%+k.%)i/d8`.%,w%hji%f+ijq8d)n#k-+"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            l.error(AuthToken.m_ck((Object)"\b%%$.)?#$$\u0006+%+,/9jc\u0004$>k\u0006.+//9j07bpk\u000f98$8k.>8\"$,j;8$).98j$,k9?%;:\"$,j'%(+'j(%%$.)?%99qj07"), objectArray);
            return;
        }
        finally {
            a.H.unlock();
        }
    }

    protected c_mja getConnectionStatusInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.d.getConnector(a)) != null && a.m_cdb()) {
            return c_mja.L;
        }
        return c_mja.g;
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(Integer a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            l.debug(AuthToken.m_ck((Object)"\u0007\u000f\n\u000e\u000e\u0018qj\u0018>*8?#%-k+'&k)$$%/(>\"%%9k,$8k:9%!/(>k16j'%(+'&2d"), (Object)a);
            a2.startConnectionsByProjectIdInternal(a);
            return;
        }
        l.debug(c_hia.m_ck((Object)"\u0004J\u0004(\u0006@\u000bA\u000fWp%\u0018`;p/v>l$bji/d.`8%>jjv>d8qjd&ijf%k$`)q#j$vjc%wju8j `)qj~7+"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.j.m_sb(Short.valueOf((short)206), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC start connections for project " + a, (Throwable)exception);
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            Integer n = a.getProject().getId();
            l.info(AuthToken.m_ck((Object)"\u0007\u000f\n\u000e\u000e\u0018qj\u0003+%.'#%-k\u001a9%!/(>\u000f/*)?#=+?/\u000e<.$?j-%9j;8$ .)?j\u0002\u000eqj07"), (Object)n);
            a2.stopConnectionsByProjectIdInternal(n);
            return;
        }
        l.debug(c_hia.m_ck((Object)"\u0004J\u0004(\u0006@\u000bA\u000fWp%\u0003b$j8l$bjU8j `)q\u000e`+f>l<d>`\u000fs/k>%,j8%:w%o/f>%\u0003Ap%1x"), (Object)a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_mja getConnectionStatus(Integer a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            l.debug(AuthToken.m_ck((Object)"\u0006\u000e\u000b\u000f\u000f\u0019pk\r.>?#%-k)$$%/(>\"%%j8>*>>9k,$8k16j'%(+'&2d"), (Object)a);
            return a2.getConnectionStatusInternal(a);
        }
        l.debug(c_hia.m_ck((Object)"K\u0005KgI\u000fD\u000e@\u0018?jW/t?`9q#k-%&`+a/wjc%wjf%k$`)q#j$%9q+q?vjc%wj~7+"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_mja)a2.j.m_sb(Short.valueOf((short)203), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get connection status for " + a, (Throwable)exception);
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> a3) {
        ConnectionManager a4;
        a3.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((a, a2) -> {
            ConnectionManager a3;
            if ((a = a3.d.getConnector(a)) != null) {
                a.m_rya(a2);
            }
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_mja> getConnectionStatuses(Integer[] a) {
        ConnectionManager a2;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.j.m_hb()) {
            l.debug(AuthToken.m_ck((Object)"\u0006\u000e\u000b\u000f\u000f\u0019pk\r.>?#%-k)$$%/(>\"%%j8>*>>9.9k,$8k16j\u0002\u000e8j'%(+'&2d"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal(a);
        }
        l.debug(c_hia.m_ck((Object)"K\u0005KgI\u000fD\u000e@\u0018?jW/t?`9q#k-%&`+a/wjc%wjf%k$`)q#j$%9q+q?v/vjc%wj~7%\u0003A9+"), (Object)a.length);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.j.m_sb(Short.valueOf((short)209), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get connection statuses for IDs " + Arrays.toString((Object[])a), (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.E.m_gcc((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.startConnectionInternal(arg_0));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ConnectionManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.j.m_yb((short)201, (Object)a, ConnectionManager.class.getDeclaredMethod(c_hia.m_ck((Object)"v>d8q\tj$k/f>l%k\u0003k>`8k+i"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.j.m_yb((short)202, (Object)a, ConnectionManager.class.getDeclaredMethod(AuthToken.m_ck((Object)"8>$:\b%%$.)?#$$\u0002$?/9$*&"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.j.m_yb((short)203, (Object)a, ConnectionManager.class.getDeclaredMethod(c_hia.m_ck((Object)"b/q\tj$k/f>l%k\u0019q+q?v\u0003k>`8k+i"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = SetValueRequest.class;
            a.j.m_yb((short)204, (Object)a, ConnectionManager.class.getDeclaredMethod(AuthToken.m_ck((Object)"8/?\u001c*8\"+)&.\u001c*&>/\u0002$?/9$*&"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Collection.class;
            a.j.m_yb((short)205, (Object)a, ConnectionManager.class.getDeclaredMethod(c_hia.m_ck((Object)"v/q\u001cd8l+g&`\u001cd&p/v\u0003k>`8k+i"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.j.m_yb((short)206, (Object)a, ConnectionManager.class.getDeclaredMethod(AuthToken.m_ck((Object)"9?+9>\b%%$.)?#$$8\b2\u001a9%!/(>\u0002.\u0002$?/9$*&"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.j.m_yb((short)207, (Object)a, ConnectionManager.class.getDeclaredMethod(c_hia.m_ck((Object)"9q%u\tj$k/f>l%k9G3U8j `)q\u0003a\u0003k>`8k+i"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.j.m_yb((short)208, (Object)a, ConnectionManager.class.getDeclaredMethod(AuthToken.m_ck((Object)",/?\t$$%/(>\"%%\u0019?+??8/8\b2\u001a9%!/(>\u0002.\u0002$?/9$*&"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer[].class;
            a.j.m_yb((short)209, (Object)a, ConnectionManager.class.getDeclaredMethod(c_hia.m_ck((Object)"-`>F%k$`)q#j$V>d>p9`9G3L.v\u0003k>`8k+i"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = Integer.class;
            a.j.m_yb((short)210, (Object)a, ConnectionManager.class.getDeclaredMethod(AuthToken.m_ck((Object)")8$=8/\b%%$.)?#$$\u0002$?/9$*&"), classArray10));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(c_hia.m_ck((Object)"\fd#i/ajq%%8`-l9q/wjF%k$`)q#j$H+k+b/wjW\u001aFjh/q\"j.v"), noSuchMethodException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        String string = connectionManager.j.m_gb().getNodeId();
        l.info(AuthToken.m_ck((Object)"\b%%$.)?#$$\u0006+%+,/9pk\u001e##8j%%//kb07bj#+8j)/(%&/k>#/k\u0006\u000e\u000b\u000f\u000f\u0019dk\u0018.9?%9#%-k+(>\"<.j(%%$.)?#$$8ded"), (Object)string);
        connectionManager.H.lock();
        try {
            Set set = a2.C.smembers(L).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                l.info(c_hia.m_ck((Object)"F%k$`)q#j$H+k+b/wj-\u0006`+a/wj~7,p%\u0004jjd)q#s/%)j$k/f>l%k9%,j?k.%#kjW/a#vjq%%8`9q%w/+"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            l.info(AuthToken.m_ck((Object)"\t$$%/(>\"%%\u0007*$*-.8kb\u0007/*..8k16cqj\r%>$/j07k+(>\"<.j(%%$.)?#$$k\u0003\u000f9k#%j\u0019//#8j?%k8.9?%9/qj07"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = c_hia.m_ck((Object)"\u001cL\u000fR\u0015F\u0005K\u0004@\tQ\u0003J\u0004Z\u0003Q\u000fH");
            c_kka.m_occ(() -> {
                ConnectionManager a3;
                arrayList.addAll(a3.E.m_rzb(set));
            }, (String[])stringArray);
            l.info(AuthToken.m_ck((Object)"\b%%$.)?#$$\u0006+%+,/9jc\u0006.+//9j07bpk\u000b?>.';>\"$,j?%k8.9?%9/k16j(%%$.)?#$$8d"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ConnectionManager a2;
                ConnectionManager connectionManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = c_hia.m_ck((Object)"\u0019Q\u000bW\u001eZ\tJ\u0004K\u000fF\u001eL\u0005K");
                stringArray[1] = AuthToken.m_ck((Object)"\u0019\u001f\u0005\u001b\u0015\b\u0005\u0005\u0004\u000e\t\u001f\u0003\u0004\u0004");
                c_kka.m_byb(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1(connectionManager.j.m_gb().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            l.info(c_hia.m_ck((Object)"F%k$`)q#j$H+k+b/wj-\u0006`+a/wj~7,p%\fl$l9m/ajf%k$`)q#j$%8`9q%w+q#j$%:w%f/v9+"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            l.error(AuthToken.m_ck((Object)"\b%%$.)?#$$\u0006+%+,/9jc\u0006.+//9j07bpk\u000f98$8k.>8\"$,j(%%$.)?#$$k8.9?%9+?#$$k:9%(/89qj07"), objectArray);
            return;
        }
        finally {
            a2.H.unlock();
        }
    }

    protected void startConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_kka.m_kvb(() -> {
            ConnectionManager a2;
            a2.H.lock();
            try {
                a2.stopConnectionInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_ch("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.e.m_qia();
                connectionManager.d.provideConnector(a).m_edb();
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                connectionManager.C.sadd(L, stringArray);
                return;
            }
            finally {
                a2.H.unlock();
            }
        }, a);
    }

    protected void stopConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_kka.m_kvb(() -> {
            ConnectionManager a2;
            a2.H.lock();
            try {
                c_xf c_xf2 = a2.d.getConnector(a.getId());
                if (c_xf2 != null) {
                    c_xf2.m_obb();
                    a2.d.removeConnector(a.getId(), c_xf2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.C.srem(L, stringArray);
                return;
            }
            finally {
                a2.H.unlock();
            }
        }, a);
    }

    public ConnectionManager(c_wia a, c_cn a2, c_ng a3, ConnectorFactory<C, V> a4, JedisPooled a5, c_j a6) {
        ConnectionManager a7;
        ConnectionManager connectionManager = a7;
        ConnectionManager connectionManager2 = a7;
        ConnectionManager connectionManager3 = a7;
        ConnectionManager connectionManager4 = a7;
        connectionManager4.H = new ReentrantLock();
        connectionManager3.E = a;
        connectionManager3.e = a2;
        connectionManager2.J = a3;
        connectionManager2.d = a4;
        connectionManager.C = a5;
        connectionManager.j = a6;
    }

    protected void stopConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.stopConnectionInternal(connectionManager.E.m_wj(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_mja> getConnectionStatuses(Integer a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            l.debug(c_hia.m_ck((Object)"I\u000fD\u000e@\u0018?jB/q>l$bjd&ijf%k$`)q#j$%9q+q?v/vjc%wju8j `)qj~7%&j)d&i3+"), (Object)a);
            return a2.getConnectionStatusesByProjectIdInternal(a);
        }
        l.debug(AuthToken.m_ck((Object)"\u0004\u0004\u0004f\u0006\u000e\u000b\u000f\u000f\u0019pk\u0018.;>/8>\"$,j'/*..8k,$8k+'&k)$$%/(>\"%%j8>*>>9.9k,$8k:9%!/(>k16d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.j.m_sb(Short.valueOf((short)208), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get connection statuses for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_mja getConnectionStatus(Integer a, String a2) {
        ConnectionManager a3;
        if ((a = a3.E.m_dg(a, a2)) == null) {
            return c_mja.g;
        }
        return a3.getConnectionStatus(a.getId());
    }

    protected Map<Integer, c_mja> getConnectionStatusesByProjectIdInternal(Integer a2) {
        ConnectionManager a3;
        if ((a2 = a3.E.m_la((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Connection::getId, a -> {
            ConnectionManager a2;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @TransactionalEventListener(value={RestartEvent.class})
    public void handleRestartEvent(RestartEvent a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            Connection connection = a.getConnection();
            l.info(c_hia.m_ck((Object)"I\u000fD\u000e@\u0018?jM+k.i#k-%\u0018`9q+w>@<`$qjc%wjf%k$`)q#j$?j~7%bL\u000e?j~7,"), (Object)connection.getName(), (Object)connection.getId());
            a2.H.lock();
            try {
                if (a2.getConnectionStatusInternal(connection.getId()) == c_mja.L) {
                    a2.startConnectionInternal(connection.getId());
                }
                return;
            }
            finally {
                a2.H.unlock();
            }
        }
        l.debug(AuthToken.m_ck((Object)"\u0005\u0005\u0005g\u0007\u000f\n\u000e\u000e\u0018qj\u0002-%%9#%-k\u0018.9?+9>\u000e<.$?j-%9j(%%$.)?#$$qj07"), (Object)a.getConnection().getId());
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            l.debug(c_hia.m_ck((Object)"I\u000fD\u000e@\u0018?jV>d8q#k-%)j$k/f>l%kj~7%&j)d&i3+"), (Object)a);
            a2.startConnectionInternal(a);
            return;
        }
        l.debug(AuthToken.m_ck((Object)"\u0004\u0004\u0004f\u0006\u000e\u000b\u000f\u000f\u0019pk\u0018.;>/8>\"$,j'/*..8k>$j8>*8?j(%%$.)?#$$k16d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.j.m_sb(Short.valueOf((short)201), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC start connection " + a, (Throwable)exception);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> a) {
        ConnectionManager a2;
        c_xf c_xf2 = a2.d.getConnector(a.getConnectionId());
        if (c_xf2 == null) {
            throw new c_ck("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_xf2.m_kya(a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.j.m_sa((ClusterNodeListener)a);
        l.info(c_hia.m_ck((Object)"\tj$k/f>l%k\u0007d$d-`8%#k#q#d&l0`.%+k.%8`-l9q/w/ajd9%\ti?v>`8K%a/I#v>`$`8+"));
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> a) {
        ConnectionManager a2;
        Objects.requireNonNull(a, AuthToken.m_ck((Object)"\u0018/?\u001c*&>/\u0019/:?.9?j(+%$$>k(.j%?'&"));
        Objects.requireNonNull(a.getConnectionId(), c_hia.m_ck((Object)"\tj$k/f>l%k\u0003ajl$%\u0019`>S+i?`\u0018`;p/v>%)d$k%qjg/%$p&i"));
        if (a2.j.m_hb()) {
            l.debug(AuthToken.m_ck((Object)"\u0007\u000f\n\u000e\u000e\u0018qj\u0018/?>\"$,j=+9#*('/k<*&>/k,$8k)$$%/(>\"%%j07k&$)*&'3qj07"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        l.debug(c_hia.m_ck((Object)"K\u0005KgI\u000fD\u000e@\u0018?jW/t?`9q#k-%&`+a/wjq%%9`>%<d8l+g&`js+i?`jc%wjf%k$`)q#j$%1xp%1x"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.j.m_sb(Short.valueOf((short)204), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.startConnection(connectionManager.E.m_bwb(a, a2).getId());
    }

    protected void startConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.startConnectionInternal(connectionManager.E.m_qzb(a));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            l.debug(c_hia.m_ck((Object)"I\u000fD\u000e@\u0018?jV>j:u#k-%)j$k/f>l%kj~7%&j)d&i3+"), (Object)a);
            a2.stopConnectionInternal(a);
            return;
        }
        l.debug(AuthToken.m_ck((Object)"\u0005\u0005\u0005g\u0007\u000f\n\u000e\u000e\u0018qj\u0019/:?.9?#%-k&.+//9j?%k9?%;j(%%$.)?#$$k16d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.j.m_sb(Short.valueOf((short)202), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC stop connection " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(Integer a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            l.debug(c_hia.m_ck((Object)"\u0006@\u000bA\u000fWp%\u0019q%u:l$bjd&ijf%k$`)q#j$vjc%wju8j `)qj~7%&j)d&i3+"), (Object)a);
            a2.stopConnectionsByProjectIdInternal(a);
            return;
        }
        l.debug(AuthToken.m_ck((Object)"\u0004\u0004\u0004f\u0006\u000e\u000b\u000f\u000f\u0019pk\u0018.;>/8>\"$,j'/*..8k>$j8>$:k+'&k)$$%/(>\"%%9k,$8k:9%!/(>k16d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.j.m_sb(Short.valueOf((short)207), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC stop connections for project " + a, (Throwable)exception);
        }
    }

    protected void stopConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.E.m_la((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    protected Map<Integer, c_mja> getConnectionStatusesByIdsInternal(Integer[] a2) {
        ConnectionManager a3;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> a3.getConnectionStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(Integer a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            l.debug(c_hia.m_ck((Object)"\u0006@\u000bA\u000fWp%\u001a`8c%w'l$bjg8j=v/%%u/w+q#j$%,j8%)j$k/f>l%kj~7%&j)d&i3+"), (Object)a);
            return a2.browseConnectionInternal(a);
        }
        l.debug(AuthToken.m_ck((Object)"\u0005\u0005\u0005g\u0007\u000f\n\u000e\u000e\u0018qj\u0019/:?.9?#%-k&.+//9j?%k:.8-%9'k(9%<9.j$:.8*>\"%%j-%9j(%%$.)?#$$k16d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return a2.j.m_sb(Short.valueOf((short)210), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC browse connection " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> a22) {
        ConnectionManager a3;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, AuthToken.m_ck((Object)"\u0018/?\u001c*&>/\u0019/:?.9?j(+%$$>k(.j%?'&")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_hia.m_ck((Object)"\tj$k/f>l%k\u0003ajl$%\u0019`>S+i?`\u0018`;p/v>%)d$k%qjg/%$p&i")));
        if (a3.j.m_hb()) {
            l.debug(c_hia.m_ck((Object)"I\u000fD\u000e@\u0018?jV/q>l$bj~7%<d8l+g&`js+i?`9%&j)d&i3+"), (Object)a22.size());
            a3.setVariableValuesInternal(a22);
            return;
        }
        l.debug(AuthToken.m_ck((Object)"\u0005\u0005\u0005g\u0007\u000f\n\u000e\u000e\u0018qj\u0019/:?.9?#%-k&.+//9j?%k9.>k16j=+9#*('/k<*&>/8d"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<SetValueRequest<V>>(a22);
            a3.j.m_sb(Short.valueOf((short)205), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new c_vha(c_hia.m_ck((Object)"C+l&`.%>jjW\u001aFjv/qjs+w#d(i/%<d&p/v"), (Throwable)a22);
        }
    }

    @TransactionalEventListener(value={DeleteEvent.class})
    public void handleDeleteEvent(DeleteEvent a) {
        ConnectionManager a2;
        if (a2.j.m_hb()) {
            Connection connection = a.getConnection();
            l.info(AuthToken.m_ck((Object)"\u0007\u000f\n\u000e\u000e\u0018qj\u0003+%.'#%-k\u000e.&.>.\u000f=/%>k,$8k)$$%/(>\"%%pk16jc\u0003\u000fpk16c"), (Object)connection.getName(), (Object)connection.getId());
            a2.stopConnectionInternal(connection);
            return;
        }
        l.debug(c_hia.m_ck((Object)"K\u0005KgI\u000fD\u000e@\u0018?jL-k%w#k-%\u000e`&`>`\u000fs/k>%,j8%)j$k/f>l%kp%1x"), (Object)a.getConnection().getId());
    }

    protected Object browseConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        Connection connection = connectionManager.E.m_wj(a);
        return c_kka.m_cbc(() -> {
            ConnectionManager a2;
            if ((a = a2.d.getConnector(a)) instanceof c_c) {
                return ((c_c)a).m_da();
            }
            throw new RuntimeException(AuthToken.m_ck((Object)"\t8$=8/k%;/9+?#$$k$$>k9>:;%9>.."));
        }, (OwnedSpaceBaseModel)connection);
    }
}

