/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.services.c_mk;
import com.inscada.mono.datasource.sql.model.metadata.FunctionMetadata;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class VariableController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>> {
    private final c_mk<TConnection, TDevice, TFrame, TVariable> g;

    public VariableController(c_mk<TConnection, TDevice, TFrame, TVariable> a) {
        VariableController a2;
        a2.g = a;
    }

    @GetMapping(params={"variableIds"})
    public Collection<TVariable> getVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        return this.g.m_vwa(Arrays.asList(a));
    }

    @DeleteMapping(value={""}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.g.m_xva(List.of(a));
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void upsertVariables(@Valid @RequestBody Collection<TVariable> a) {
        this.g.m_bh(a, true);
    }

    @GetMapping(value={"/{variableId}"})
    public TVariable getVariable(@PathVariable(value="variableId") Integer a) {
        return (TVariable)this.g.m_ya(a);
    }

    @GetMapping(params={"frameId"})
    public Collection<TVariable> getVariablesByFrameId(@RequestParam(name="frameId", required=false) Integer a) {
        if (a == null) {
            return this.g.m_aa();
        }
        return this.g.m_aua(a);
    }

    @GetMapping(params={"projectId"})
    public Collection<TVariable> getVariables(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.g.m_aa();
        }
        return this.g.m_la(a);
    }

    @GetMapping(params={"projectId", "name"})
    public TVariable getVariableByName(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return (TVariable)this.g.m_hoa(projectId, a);
    }

    @PutMapping(value={"/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariable a) {
        this.g.m_ena(variableId, a);
    }

    @PostMapping
    public ResponseEntity<TVariable> createVariable(@Valid @RequestBody TVariable variable, UriComponentsBuilder a) {
        variable = this.g.m_qpa(variable);
        Object[] objectArray = new Object[1];
        objectArray[0] = variable.getId();
        return ResponseEntity.created((URI)a.path(FunctionMetadata.m_ck((Object)"G+\u001e1\u001a9\t2\u00045!4\u0015")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @DeleteMapping(value={"/filter"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariablesByFilter(@Valid @RequestBody VariableFilter a) {
        this.g.m_wra(a);
    }

    @GetMapping(value={"/pages"}, params={"projectId"})
    public Page<TVariable> getVariablesByPages(@RequestParam(name="projectId") Integer projectId, Pageable a) {
        return this.g.m_ypa(projectId, a);
    }

    @DeleteMapping(value={"/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="variableId") Integer a) {
        this.g.m_qa(a);
    }
}

