/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_eg;
import com.inscada.mono.communication.base.template.k.c_fd;
import com.inscada.mono.communication.base.template.model.DeviceGenerationRequest;
import com.inscada.mono.datasource.influxdb.restcontrollers.CustomInfluxDBDatabaseController;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TConnectionService extends c_eg<TConnection, TDevice, TFrame>, TTemplateService extends c_fd> {
    protected final TConnectionService d;
    protected final TTemplateService g;

    @DeleteMapping(value={"/devices"}, params={"deviceIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevicesByIds(@RequestParam(value="deviceIds") Integer[] a) {
        this.d.m_cpa(List.of(a));
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        this.d.m_uoa(connectionId, a);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrame a) {
        this.d.m_kqa(connectionId, deviceId, frameId, a, Boolean.valueOf(true));
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDevice a) {
        this.d.m_jpa(connectionId, deviceId, a, Boolean.valueOf(true));
    }

    @PostMapping(value={"/{connectionId}/devices"})
    public ResponseEntity<TDevice> createDevice(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TDevice device, UriComponentsBuilder a) {
        device = this.d.m_vla(connectionId, device, Boolean.valueOf(true));
        Object[] objectArray = new Object[2];
        objectArray[0] = connectionId;
        objectArray[1] = device.getId();
        return ResponseEntity.created((URI)a.path(CustomInfluxDBDatabaseController.m_ck((Object)"\u0019]UIXHSEBOYH\u007fBK\tRC@OUCE\tMBSP_ESoR[")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @GetMapping(value={"/device/{deviceId}"})
    public TDevice getDeviceById(@PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.d.m_xpa(a);
    }

    @GetMapping(value={"/{connectionId}/devices"})
    public Collection<TDevice> getDevices(@PathVariable(value="connectionId") Integer a) {
        return this.d.m_lua(a);
    }

    @GetMapping(value={"/{connectionId}"})
    public TConnection getConnection(@PathVariable(value="connectionId") Integer a) {
        return (TConnection)this.d.m_ya(a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.d.m_ioa(connectionId, deviceId, a);
    }

    @DeleteMapping(value={"/frames"}, params={"frameIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFramesByIds(@RequestParam(value="frameIds") Integer[] a) {
        this.d.m_rua(List.of(a));
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    public TFrame getFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrame)this.d.m_gna(connectionId, deviceId, a);
    }

    @GetMapping(value={"/frames"})
    public Collection<TFrame> getFrames(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.d.m_isa();
        }
        return this.d.m_bqa(a);
    }

    @DeleteMapping(value={""}, params={"connectionIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnectionsByIds(@RequestParam(value="connectionIds") Integer[] a) {
        this.d.m_jqa(List.of(a));
    }

    @GetMapping
    public Collection<TConnection> getConnections(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.d.m_aa();
        }
        return this.d.m_la(a);
    }

    @PostMapping(value={"/{connectionId}/devices/generate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void generateFromTemplate(@PathVariable(value="connectionId") Integer connectionId, @RequestBody DeviceGenerationRequest a) {
        this.g.m_dua(connectionId, a);
    }

    protected ConnectionController(TConnectionService a, TTemplateService a2) {
        ConnectionController a3;
        ConnectionController connectionController = a3;
        connectionController.d = a;
        connectionController.g = a2;
    }

    @PostMapping
    public ResponseEntity<TConnection> createConnection(@Valid @RequestBody TConnection connection, UriComponentsBuilder a) {
        connection = this.d.m_qwa(connection);
        Object[] objectArray = new Object[1];
        objectArray[0] = connection.getId();
        return ResponseEntity.created((URI)a.path(EvalAnimationMessage.m_ck((Object)"\f\u0010@\u0004M\u0005F\bW\u0002L\u0005j\u000f^")).buildAndExpand(objectArray).toUri()).body(connection);
    }

    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnection(@PathVariable(value="connectionId") Integer a) {
        this.d.m_qa(a);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDevice> getDevicesByProjectId(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.d.m_boa();
        }
        return this.d.m_xqa(a);
    }

    @PostMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public ResponseEntity<TFrame> createFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrame frame, UriComponentsBuilder a) {
        frame = this.d.m_tna(connectionId, deviceId, frame, Boolean.valueOf(true));
        Object[] objectArray = new Object[3];
        objectArray[0] = connectionId;
        objectArray[1] = deviceId;
        objectArray[2] = frame.getId();
        return ResponseEntity.created((URI)a.path(CustomInfluxDBDatabaseController.m_ck((Object)"\tMEYHXCUR_IXoR[\u0019BSP_ESU\u0019]RC@OUC\u007fBK\tPTWKSU\u0019]PTWKSoR[")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public Collection<TFrame> getFrames(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return this.d.m_dwa(connectionId, a);
    }

    @GetMapping(value={"/frame/{frameId}"})
    public TFrame getFrameById(@PathVariable(value="frameId") Integer a) {
        return (TFrame)this.d.m_coa(a);
    }

    public static String m_ck(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 5 << 3 ^ 1;
        int cfr_ignored_0 = 1 << 3 ^ (2 ^ 5);
        int n4 = n2;
        int n5 = (2 ^ 5) << 4 ^ (3 << 2 ^ 1);
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}"})
    public TDevice getDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.d.m_rta(connectionId, a);
    }

    @PutMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConnection(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TConnection a) {
        this.d.m_eva(connectionId, a);
    }
}

